/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsSourceWatermark;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.types.logical.RowType;

@JsonTypeName(value="SourceWatermark")
public final class SourceWatermarkSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_SOURCE_WATERMARK_ENABLED = "sourceWatermarkEnabled";
    @JsonProperty(value="sourceWatermarkEnabled")
    private final boolean sourceWatermarkEnabled;

    @JsonCreator
    public SourceWatermarkSpec(@JsonProperty(value="sourceWatermarkEnabled") boolean sourceWatermarkEnabled, @JsonProperty(value="producedType") RowType producedType) {
        super(producedType);
        this.sourceWatermarkEnabled = sourceWatermarkEnabled;
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        if (tableSource instanceof SupportsSourceWatermark) {
            if (this.sourceWatermarkEnabled) {
                ((SupportsSourceWatermark)tableSource).applySourceWatermark();
            }
        } else {
            throw new TableException(String.format("%s does not support SupportsSourceWatermark.", tableSource.getClass().getName()));
        }
    }

    @Override
    public String getDigests(SourceAbilityContext context) {
        return "watermark=[SOURCE_WATERMARK()]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceWatermarkSpec that = (SourceWatermarkSpec)o;
        return this.sourceWatermarkEnabled == that.sourceWatermarkEnabled;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceWatermarkEnabled);
    }
}

