/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.dataview.NullSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

@Internal
final class LogicalTypeJsonDeserializer
extends StdDeserializer<LogicalType> {
    private static final long serialVersionUID = 1L;

    LogicalTypeJsonDeserializer() {
        super(LogicalType.class);
    }

    public LogicalType deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode logicalTypeNode = (JsonNode)jsonParser.readValueAsTree();
        SerdeContext serdeContext = SerdeContext.get((DatabindContext)ctx);
        return LogicalTypeJsonDeserializer.deserialize(logicalTypeNode, serdeContext);
    }

    static LogicalType deserialize(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        if (logicalTypeNode.isTextual()) {
            return LogicalTypeJsonDeserializer.deserializeWithCompactSerialization(logicalTypeNode.asText(), serdeContext);
        }
        return LogicalTypeJsonDeserializer.deserializeWithExtendedSerialization(logicalTypeNode, serdeContext);
    }

    private static LogicalType deserializeWithCompactSerialization(String serializableString, SerdeContext serdeContext) {
        DataTypeFactory dataTypeFactory = serdeContext.getFlinkContext().getCatalogManager().getDataTypeFactory();
        return dataTypeFactory.createLogicalType(serializableString);
    }

    private static LogicalType deserializeWithExtendedSerialization(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        LogicalType logicalType = LogicalTypeJsonDeserializer.deserializeFromRoot(logicalTypeNode, serdeContext);
        if (logicalTypeNode.has("nullable")) {
            boolean isNullable = logicalTypeNode.get("nullable").asBoolean();
            return logicalType.copy(isNullable);
        }
        return logicalType.copy(true);
    }

    private static LogicalType deserializeFromRoot(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        LogicalTypeRoot typeRoot = LogicalTypeRoot.valueOf((String)logicalTypeNode.get("type").asText());
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return LogicalTypeJsonDeserializer.deserializeZeroLengthString(typeRoot, logicalTypeNode);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return LogicalTypeJsonDeserializer.deserializeTimestamp(typeRoot, logicalTypeNode);
            }
            case ARRAY: 
            case MULTISET: {
                return LogicalTypeJsonDeserializer.deserializeCollection(typeRoot, logicalTypeNode, serdeContext);
            }
            case MAP: {
                return LogicalTypeJsonDeserializer.deserializeMap(logicalTypeNode, serdeContext);
            }
            case ROW: {
                return LogicalTypeJsonDeserializer.deserializeRow(logicalTypeNode, serdeContext);
            }
            case DISTINCT_TYPE: {
                return LogicalTypeJsonDeserializer.deserializeDistinctType(logicalTypeNode, serdeContext);
            }
            case STRUCTURED_TYPE: {
                return LogicalTypeJsonDeserializer.deserializeStructuredType(logicalTypeNode, serdeContext);
            }
            case SYMBOL: {
                return new SymbolType();
            }
            case RAW: {
                return LogicalTypeJsonDeserializer.deserializeSpecializedRaw(logicalTypeNode, serdeContext);
            }
        }
        throw new TableException("Unsupported type root: " + typeRoot);
    }

    private static LogicalType deserializeZeroLengthString(LogicalTypeRoot typeRoot, JsonNode logicalTypeNode) {
        int length = logicalTypeNode.get("length").asInt();
        if (length != 0) {
            throw new TableException("String length should be 0.");
        }
        switch (typeRoot) {
            case CHAR: {
                return CharType.ofEmptyLiteral();
            }
            case VARCHAR: {
                return VarCharType.ofEmptyLiteral();
            }
            case BINARY: {
                return BinaryType.ofEmptyLiteral();
            }
            case VARBINARY: {
                return VarBinaryType.ofEmptyLiteral();
            }
        }
        throw new TableException("String type root expected.");
    }

    private static LogicalType deserializeTimestamp(LogicalTypeRoot typeRoot, JsonNode logicalTypeNode) {
        int precision = logicalTypeNode.get("precision").asInt();
        TimestampKind kind = TimestampKind.valueOf((String)logicalTypeNode.get("kind").asText());
        switch (typeRoot) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return new TimestampType(true, kind, precision);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return new ZonedTimestampType(true, kind, precision);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new LocalZonedTimestampType(true, kind, precision);
            }
        }
        throw new TableException("Timestamp type root expected.");
    }

    private static LogicalType deserializeCollection(LogicalTypeRoot typeRoot, JsonNode logicalTypeNode, SerdeContext serdeContext) {
        JsonNode elementNode = logicalTypeNode.get("elementType");
        LogicalType elementType = LogicalTypeJsonDeserializer.deserialize(elementNode, serdeContext);
        switch (typeRoot) {
            case ARRAY: {
                return new ArrayType(elementType);
            }
            case MULTISET: {
                return new MultisetType(elementType);
            }
        }
        throw new TableException("Collection type root expected.");
    }

    private static LogicalType deserializeMap(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        JsonNode keyNode = logicalTypeNode.get("keyType");
        LogicalType keyType = LogicalTypeJsonDeserializer.deserialize(keyNode, serdeContext);
        JsonNode valueNode = logicalTypeNode.get("valueType");
        LogicalType valueType = LogicalTypeJsonDeserializer.deserialize(valueNode, serdeContext);
        return new MapType(keyType, valueType);
    }

    private static LogicalType deserializeRow(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        ArrayNode fieldNodes = (ArrayNode)logicalTypeNode.get("fields");
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        for (JsonNode fieldNode : fieldNodes) {
            String fieldName = fieldNode.get("name").asText();
            LogicalType fieldType = LogicalTypeJsonDeserializer.deserialize(fieldNode.get("fieldType"), serdeContext);
            String fieldDescription = fieldNode.has("description") ? fieldNode.get("description").asText() : null;
            fields.add(new RowType.RowField(fieldName, fieldType, fieldDescription));
        }
        return new RowType(fields);
    }

    private static LogicalType deserializeDistinctType(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        ObjectIdentifier identifier = ObjectIdentifierJsonDeserializer.deserialize(logicalTypeNode.get("objectIdentifier").asText(), serdeContext);
        TableConfigOptions.CatalogPlanRestore restoreStrategy = (TableConfigOptions.CatalogPlanRestore)serdeContext.getConfiguration().get(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS);
        switch (restoreStrategy) {
            case ALL: {
                if (logicalTypeNode.has("sourceType")) {
                    return LogicalTypeJsonDeserializer.deserializeDistinctTypeFromPlan(identifier, logicalTypeNode, serdeContext);
                }
                return LogicalTypeJsonDeserializer.deserializeUserDefinedTypeFromCatalog(identifier, serdeContext);
            }
            case ALL_ENFORCED: {
                return LogicalTypeJsonDeserializer.deserializeDistinctTypeFromPlan(identifier, logicalTypeNode, serdeContext);
            }
            case IDENTIFIER: {
                return LogicalTypeJsonDeserializer.deserializeUserDefinedTypeFromCatalog(identifier, serdeContext);
            }
        }
        throw new TableException("Unsupported catalog restore strategy.");
    }

    private static LogicalType deserializeDistinctTypeFromPlan(ObjectIdentifier identifier, JsonNode logicalTypeNode, SerdeContext serdeContext) {
        LogicalType sourceType = LogicalTypeJsonDeserializer.deserialize(logicalTypeNode.get("sourceType"), serdeContext);
        DistinctType.Builder builder = DistinctType.newBuilder((ObjectIdentifier)identifier, (LogicalType)sourceType);
        if (logicalTypeNode.has("description")) {
            builder.description(logicalTypeNode.get("description").asText());
        }
        return builder.build();
    }

    private static LogicalType deserializeStructuredType(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        if (!logicalTypeNode.has("objectIdentifier")) {
            return LogicalTypeJsonDeserializer.deserializeStructuredTypeFromPlan(logicalTypeNode, serdeContext);
        }
        ObjectIdentifier identifier = ObjectIdentifierJsonDeserializer.deserialize(logicalTypeNode.get("objectIdentifier").asText(), serdeContext);
        TableConfigOptions.CatalogPlanRestore restoreStrategy = (TableConfigOptions.CatalogPlanRestore)serdeContext.getConfiguration().get(TableConfigOptions.PLAN_RESTORE_CATALOG_OBJECTS);
        switch (restoreStrategy) {
            case ALL: {
                if (logicalTypeNode.has("attributes")) {
                    return LogicalTypeJsonDeserializer.deserializeStructuredTypeFromPlan(logicalTypeNode, serdeContext);
                }
                return LogicalTypeJsonDeserializer.deserializeUserDefinedTypeFromCatalog(identifier, serdeContext);
            }
            case ALL_ENFORCED: {
                return LogicalTypeJsonDeserializer.deserializeStructuredTypeFromPlan(logicalTypeNode, serdeContext);
            }
            case IDENTIFIER: {
                return LogicalTypeJsonDeserializer.deserializeUserDefinedTypeFromCatalog(identifier, serdeContext);
            }
        }
        throw new TableException("Unsupported catalog restore strategy.");
    }

    private static LogicalType deserializeUserDefinedTypeFromCatalog(ObjectIdentifier identifier, SerdeContext serdeContext) {
        DataTypeFactory dataTypeFactory = serdeContext.getFlinkContext().getCatalogManager().getDataTypeFactory();
        return dataTypeFactory.createLogicalType(UnresolvedIdentifier.of((ObjectIdentifier)identifier));
    }

    private static LogicalType deserializeStructuredTypeFromPlan(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        ObjectIdentifier identifier = logicalTypeNode.has("objectIdentifier") ? ObjectIdentifierJsonDeserializer.deserialize(logicalTypeNode.get("objectIdentifier").asText(), serdeContext) : null;
        Class<?> implementationClass = logicalTypeNode.has("implementationClass") ? JsonSerdeUtil.loadClass(logicalTypeNode.get("implementationClass").asText(), serdeContext, "structured type") : null;
        StructuredType.Builder builder = identifier != null && implementationClass != null ? StructuredType.newBuilder((ObjectIdentifier)identifier, implementationClass) : (identifier != null ? StructuredType.newBuilder((ObjectIdentifier)identifier) : StructuredType.newBuilder(implementationClass));
        if (logicalTypeNode.has("description")) {
            builder.description(logicalTypeNode.get("description").asText());
        }
        ArrayNode attributeNodes = (ArrayNode)logicalTypeNode.get("attributes");
        ArrayList<StructuredType.StructuredAttribute> attributes = new ArrayList<StructuredType.StructuredAttribute>();
        for (JsonNode attributeNode : attributeNodes) {
            String attributeName = attributeNode.get("name").asText();
            LogicalType attributeType = LogicalTypeJsonDeserializer.deserialize(attributeNode.get("attributeType"), serdeContext);
            String attributeDescription = attributeNode.has("description") ? attributeNode.get("description").asText() : null;
            attributes.add(new StructuredType.StructuredAttribute(attributeName, attributeType, attributeDescription));
        }
        builder.attributes(attributes);
        if (logicalTypeNode.has("final")) {
            builder.setFinal(logicalTypeNode.get("final").asBoolean());
        }
        if (logicalTypeNode.has("instantiable")) {
            builder.setInstantiable(logicalTypeNode.get("instantiable").asBoolean());
        }
        if (logicalTypeNode.has("comparison")) {
            builder.comparison(StructuredType.StructuredComparison.valueOf((String)logicalTypeNode.get("comparison").asText()));
        }
        if (logicalTypeNode.has("superType")) {
            StructuredType superType = (StructuredType)LogicalTypeJsonDeserializer.deserialize(logicalTypeNode.get("superType"), serdeContext);
            builder.superType(superType);
        }
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogicalType deserializeSpecializedRaw(JsonNode logicalTypeNode, SerdeContext serdeContext) {
        NullSerializer serializer;
        Class<?> clazz = JsonSerdeUtil.loadClass(logicalTypeNode.get("class").asText(), serdeContext, "RAW type");
        if (logicalTypeNode.has("specialSerializer")) {
            String specialSerializer = logicalTypeNode.get("specialSerializer").asText();
            if (!"NULL".equals(specialSerializer)) throw new TableException("Unknown external serializer: " + specialSerializer);
            serializer = NullSerializer.INSTANCE;
            return new RawType(clazz, (TypeSerializer)serializer);
        } else {
            if (!logicalTypeNode.has("externalDataType")) throw new TableException("Invalid RAW type.");
            DataType dataType = DataTypeJsonDeserializer.deserialize(logicalTypeNode.get("externalDataType"), serdeContext);
            serializer = ExternalSerializer.of((DataType)dataType);
        }
        return new RawType(clazz, (TypeSerializer)serializer);
    }
}

