/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;

@Internal
final class ResolvedCatalogTableJsonDeserializer
extends StdDeserializer<ResolvedCatalogTable> {
    private static final long serialVersionUID = 1L;

    ResolvedCatalogTableJsonDeserializer() {
        super(ResolvedCatalogTable.class);
    }

    public ResolvedCatalogTable deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        ObjectNode jsonNode = (ObjectNode)jsonParser.readValueAsTree();
        ResolvedSchema resolvedSchema = (ResolvedSchema)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("schema"), jsonParser.getCodec()), ResolvedSchema.class);
        List partitionKeys = (List)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("partitionKeys"), jsonParser.getCodec()), (JavaType)ctx.getTypeFactory().constructCollectionType(List.class, String.class));
        String comment = JsonSerdeUtil.deserializeOptionalField(jsonNode, "comment", String.class, jsonParser.getCodec(), ctx).orElse(null);
        Map options = JsonSerdeUtil.deserializeOptionalField(jsonNode, "options", (JavaType)ctx.getTypeFactory().constructMapType(Map.class, String.class, String.class), jsonParser.getCodec(), ctx).orElse(Collections.emptyMap());
        return new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)comment, (List)partitionKeys, options), resolvedSchema);
    }
}

