/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.logcollection.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.inlong.agent.plugin.utils.regex.DateUtils;
import org.apache.inlong.agent.plugin.utils.regex.NonRegexPatternPosition;
import org.apache.inlong.agent.plugin.utils.regex.PathDateExpression;
import org.apache.inlong.agent.plugin.utils.regex.PatternUtil;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchEntity {
    private static final Logger logger = LoggerFactory.getLogger(WatchEntity.class);
    public static final int CLEAN_WATCH_DIR_WATER_LVL = 8760;
    public static final long CHECK_WATCH_DIR_INTERVAL_MS = 300000L;
    private WatchService watchService;
    private final String basicStaticPath;
    private final String originPattern;
    private final String regexPattern;
    private final Pattern pattern;
    private final PathDateExpression dateExpression;
    private final String originPatternWithoutFileName;
    private final Pattern patternWithoutFileName;
    private final boolean containRegexPattern;
    private final Map<WatchKey, Path> keys = new ConcurrentHashMap<WatchKey, Path>();
    private final Map<String, WatchKey> pathToKeys = new ConcurrentHashMap<String, WatchKey>();
    private final String dirSeparator = System.getProperty("file.separator");
    private String cycleUnit;
    private long lastCheckTime;

    public WatchEntity(WatchService watchService, String originPattern, String cycleUnit) {
        this.watchService = watchService;
        this.originPattern = originPattern;
        ArrayList<String> directoryLayers = PatternUtil.cutDirectoryByWildcardAndDateExpression(originPattern);
        this.basicStaticPath = directoryLayers.get(0);
        this.regexPattern = DateUtils.replaceDateExpressionWithRegex(originPattern);
        this.pattern = Pattern.compile(this.regexPattern, 42);
        ArrayList<String> directories = PatternUtil.cutDirectoryByWildcard(originPattern);
        this.originPatternWithoutFileName = directories.get(0);
        this.patternWithoutFileName = Pattern.compile(DateUtils.replaceDateExpressionWithRegex(this.originPatternWithoutFileName), 42);
        this.dateExpression = DateUtils.extractLongestTimeRegexWithPrefixOrSuffix(originPattern);
        this.containRegexPattern = this.isPathContainRegexPattern();
        this.cycleUnit = cycleUnit;
        logger.info("add a new watchEntity {}", (Object)this);
    }

    public String toString() {
        return "WatchEntity [parentPathName=" + this.basicStaticPath + ", pattern=" + this.pattern + ", readFilePattern=" + this.regexPattern + ", dateExpression=" + this.dateExpression + ", originPatternWithoutFileName=" + this.originPatternWithoutFileName + ", containRegexPattern=" + this.containRegexPattern + ", totalDirRegexPattern=" + this.patternWithoutFileName + ", keys=" + this.keys + ", pathToKeys=" + this.pathToKeys + ", watchService=" + this.watchService + "]";
    }

    private boolean isPathContainRegexPattern() {
        return this.originPatternWithoutFileName.contains("YYYY") || this.originPatternWithoutFileName.contains("MM") || this.originPatternWithoutFileName.contains("DD") || this.originPatternWithoutFileName.contains("hh") || this.originPatternWithoutFileName.contains("mm");
    }

    public boolean isContainRegexPattern() {
        return this.containRegexPattern;
    }

    private int calcPathDepth(String rootDir, String dirName) {
        return 0;
    }

    private void register(Path dir) throws IOException {
        if (dir == null) {
            return;
        }
        String dirName = dir.toAbsolutePath().toString();
        logger.info(dirName);
        Matcher matcher = this.patternWithoutFileName.matcher(dirName);
        String rootDir = Paths.get(this.basicStaticPath, new String[0]).toAbsolutePath().toString();
        Paths.get(this.basicStaticPath, new String[0]).toAbsolutePath().getNameCount();
        if (!this.pathToKeys.containsKey(dirName) && (matcher.matches() || rootDir.equals(dirName))) {
            WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
            this.keys.put(key, dir);
            this.pathToKeys.put(dirName, key);
            logger.info("Register a new directory: " + dir.toAbsolutePath().toString());
        }
    }

    public void registerRecursively() throws IOException {
        Path rootPath = Paths.get(this.basicStaticPath, new String[0]);
        String rootDirName = rootPath.toAbsolutePath().toString();
        if (!this.pathToKeys.containsKey(rootDirName)) {
            WatchKey key = rootPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
            this.keys.put(key, rootPath);
            this.pathToKeys.put(rootDirName, key);
            logger.info("Register a new directory: " + rootDirName);
        }
        this.registerRecursively(rootPath.toFile(), rootPath.toAbsolutePath().toString().length() + 1);
    }

    public void registerRecursively(Path dir) throws IOException {
        Path rootPath = dir;
        String rootDirName = rootPath.toAbsolutePath().toString();
        int beginIndex = rootDirName.lastIndexOf(this.dirSeparator) + 1;
        if (beginIndex == 0) {
            return;
        }
        int index = this.originPatternWithoutFileName.indexOf(this.dirSeparator, beginIndex + 1);
        Pattern pattern = this.getPattern(index);
        logger.info("beginIndex {} ,index {} ,dirPattern {}", new Object[]{beginIndex, index, pattern.pattern()});
        if (this.pathToKeys.containsKey(rootDirName) || !this.match(pattern, rootDirName)) {
            return;
        }
        WatchKey key = rootPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
        this.keys.put(key, rootPath);
        this.pathToKeys.put(rootDirName, key);
        logger.info("Register a new directory: " + rootDirName);
        logger.info("rootPath len {}", (Object)rootPath.toAbsolutePath().toString().length());
        this.registerRecursively(rootPath.toFile(), rootPath.toAbsolutePath().toString().length() + 1);
    }

    public void registerRecursively(File dir, int beginIndex) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int index = this.originPatternWithoutFileName.indexOf(this.dirSeparator, beginIndex);
        Pattern pattern = this.getPattern(index);
        logger.info("beginIndex {} ,index {} ,dirPattern {}", new Object[]{beginIndex, index, pattern.pattern()});
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            String dirName = files[i].toString();
            Path dirPath = Paths.get(dirName, new String[0]);
            if (this.pathToKeys.containsKey(dirName) || !this.match(pattern, dirName)) continue;
            try {
                WatchKey key = dirPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
                this.keys.put(key, dirPath);
                this.pathToKeys.put(dirName, key);
                logger.info("Register a new directory: " + dirName);
            }
            catch (IOException e) {
                logger.error("Register directory {} error, skip it. ", (Object)dirName, (Object)e);
                continue;
            }
            this.registerRecursively(files[i].getAbsoluteFile(), files[i].getAbsolutePath().length() + 1);
        }
    }

    private Pattern getPattern(int index) {
        String dirPattern = "";
        dirPattern = index == -1 ? this.originPatternWithoutFileName : this.originPatternWithoutFileName.substring(0, index);
        Pattern pattern = Pattern.compile(DateUtils.replaceDateExpressionWithRegex(dirPattern), 42);
        return pattern;
    }

    private boolean match(Pattern pattern, String dirName) {
        Matcher matcher = pattern.matcher(dirName);
        return matcher.matches() || matcher.lookingAt();
    }

    public Path getPath(WatchKey key) {
        return this.keys.get(key);
    }

    public int getTotalPathSize() {
        return this.keys.size();
    }

    public String getWatchPath() {
        return this.basicStaticPath;
    }

    public WatchService getWatchService() {
        return this.watchService;
    }

    public void setWatchService(WatchService watchService) {
        this.watchService = watchService;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public PathDateExpression getDateExpression() {
        return this.dateExpression;
    }

    public String getLongestDatePattern() {
        return this.dateExpression.getLongestDatePattern();
    }

    public NonRegexPatternPosition getPatternPosition() {
        return this.dateExpression.getPatternPosition();
    }

    public void removeDeletedWatchDir() {
        long now = AgentUtils.getCurrentTime();
        if (now - this.lastCheckTime < 300000L) {
            return;
        }
        this.lastCheckTime = now;
        if (this.pathToKeys.size() < 8760) {
            logger.info("originPattern {} watch dir size {}", (Object)this.originPattern, (Object)this.pathToKeys.size());
            return;
        }
        logger.info("originPattern {} watch dir size {} > {} try to remove the deleted watch dir", new Object[]{this.originPattern, this.pathToKeys.size(), 8760});
        Set<String> keys = this.pathToKeys.keySet();
        HashSet<String> tmpKeys = new HashSet<String>();
        tmpKeys.addAll(keys);
        for (String path : tmpKeys) {
            File folder = new File(path);
            if (folder.isDirectory()) continue;
            WatchKey key = this.pathToKeys.get(path);
            key.cancel();
            this.pathToKeys.remove(path);
            logger.info("path: {} is deleted we should remove the watch", (Object)path);
        }
        logger.info("pathToKeys size {} after remove", (Object)this.pathToKeys.size());
    }

    public void clearPathToKeys() {
        this.pathToKeys.clear();
    }

    public void clearKeys() {
        this.keys.clear();
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public String getOriginPattern() {
        return this.originPattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

