/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.audit.entity.AuditProxy;
import org.apache.inlong.common.pojo.audit.AuditConfig;
import org.apache.inlong.common.pojo.audit.AuditConfigRequest;
import org.apache.inlong.manager.pojo.audit.AuditRequest;
import org.apache.inlong.manager.pojo.audit.AuditVO;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.core.AuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="OpenAuditController")
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-Audit-API"})
public class AuditController {
    @Autowired
    private InlongClusterService clusterService;
    @Autowired
    private AuditService auditService;

    @PostMapping(value={"/audit/getConfig"})
    @ApiOperation(value="Get mq config list")
    public Response<AuditConfig> getConfig(@RequestBody AuditConfigRequest request) {
        AuditConfig auditConfig = this.clusterService.getAuditConfig(request.getClusterTag());
        if (CollectionUtils.isEmpty((Collection)auditConfig.getMqInfoList())) {
            return Response.fail((String)("Failed to get MQ config of cluster tag: " + request.getClusterTag()));
        }
        return Response.success((Object)auditConfig);
    }

    @PostMapping(value={"/audit/list"})
    @ApiOperation(value="Query audit list according to conditions")
    public Response<List<AuditVO>> listByCondition(@Valid @RequestBody AuditRequest request) throws Exception {
        return Response.success((Object)this.auditService.listByCondition(request));
    }

    @PostMapping(value={"/audit/listAll"})
    @ApiOperation(value="Query all audit list according to conditions")
    public Response<List<AuditVO>> listAll(@Valid @RequestBody AuditRequest request) throws Exception {
        return Response.success((Object)this.auditService.listAll(request));
    }

    @GetMapping(value={"/audit/getAuditProxy"})
    @ApiOperation(value="Get audit proxy url")
    @ApiImplicitParam(name="component", dataTypeClass=String.class, required=true)
    public Response<List<AuditProxy>> getAuditProxy(@RequestParam String component) throws Exception {
        return Response.success((Object)this.auditService.getAuditProxy(component));
    }
}

