/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.web.utils.InlongRequestWrapper;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantInsertionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TenantInsertionFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        InlongRequestWrapper inlongWrapper;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String tenant = request.getHeader("tenant");
        if (StringUtils.isBlank((CharSequence)tenant)) {
            String errMsg = "tenant should not be blank";
            log.error(errMsg);
            ((HttpServletResponse)servletResponse).sendError(400, errMsg);
            return;
        }
        if (request instanceof ShiroHttpServletRequest) {
            ShiroHttpServletRequest shiroWrapper = (ShiroHttpServletRequest)request;
            inlongWrapper = (InlongRequestWrapper)shiroWrapper.getRequest();
        } else if (request instanceof InlongRequestWrapper) {
            inlongWrapper = (InlongRequestWrapper)request;
        } else {
            String errMsg = "request should be one of ShiroHttpServletRequest or InlongRequestWrapper type";
            log.error(errMsg);
            ((HttpServletResponse)servletResponse).sendError(500, errMsg);
            return;
        }
        inlongWrapper.addParameter("tenant", tenant);
        filterChain.doFilter((ServletRequest)inlongWrapper, servletResponse);
    }
}

