/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.Node;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.StatementListener;
import net.sf.jsqlparser.parser.StreamProvider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;

public final class CCJSqlParserUtil {
    public static final int ALLOWED_NESTING_DEPTH = 10;

    private CCJSqlParserUtil() {
    }

    public static Statement parse(Reader statementReader) throws JSQLParserException {
        CCJSqlParser parser = new CCJSqlParser(new StreamProvider(statementReader));
        return CCJSqlParserUtil.parseStatement(parser);
    }

    public static Statement parse(String sql) throws JSQLParserException {
        return CCJSqlParserUtil.parse(sql, null);
    }

    public static Statement parse(String sql, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Statement statement;
        block4: {
            statement = null;
            try {
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(sql).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                statement = CCJSqlParserUtil.parseStatement(parser);
            }
            catch (JSQLParserException ex) {
                if (CCJSqlParserUtil.getNestingDepth(sql) > 10) break block4;
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(sql).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                statement = CCJSqlParserUtil.parseStatement(parser);
            }
        }
        return statement;
    }

    public static CCJSqlParser newParser(String sql) {
        return new CCJSqlParser(new StringProvider(sql));
    }

    public static CCJSqlParser newParser(InputStream is) throws IOException {
        return new CCJSqlParser(new StreamProvider(is));
    }

    public static CCJSqlParser newParser(InputStream is, String encoding) throws IOException {
        return new CCJSqlParser(new StreamProvider(is, encoding));
    }

    public static Node parseAST(String sql) throws JSQLParserException {
        CCJSqlParser parser = CCJSqlParserUtil.newParser(sql);
        try {
            parser.Statement();
            return parser.jjtree.rootNode();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is);
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is, encoding);
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Expression parseExpression(String expression) throws JSQLParserException {
        return CCJSqlParserUtil.parseExpression(expression, true);
    }

    public static Expression parseExpression(String expression, boolean allowPartialParse) throws JSQLParserException {
        return CCJSqlParserUtil.parseExpression(expression, allowPartialParse, p -> {});
    }

    public static Expression parseExpression(String expressionStr, boolean allowPartialParse, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Expression expression;
        block11: {
            expression = null;
            try {
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(expressionStr).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
            catch (JSQLParserException ex1) {
                if (CCJSqlParserUtil.getNestingDepth(expressionStr) > 10) break block11;
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(expressionStr).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (!allowPartialParse && parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (JSQLParserException ex) {
                    throw ex;
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
        }
        return expression;
    }

    public static Expression parseCondExpression(String condExpr) throws JSQLParserException {
        return CCJSqlParserUtil.parseCondExpression(condExpr, true);
    }

    public static Expression parseCondExpression(String condExpr, boolean allowPartialParse) throws JSQLParserException {
        return CCJSqlParserUtil.parseCondExpression(condExpr, allowPartialParse, p -> {});
    }

    public static Expression parseCondExpression(String conditionalExpressionStr, boolean allowPartialParse, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Expression expression;
        block11: {
            expression = null;
            try {
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(conditionalExpressionStr).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
            catch (JSQLParserException ex1) {
                if (CCJSqlParserUtil.getNestingDepth(conditionalExpressionStr) > 10) break block11;
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(conditionalExpressionStr).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (!allowPartialParse && parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (JSQLParserException ex) {
                    throw ex;
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
        }
        return expression;
    }

    public static Statement parseStatement(final CCJSqlParser parser) throws JSQLParserException {
        Statement statement = null;
        try {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Statement> future = executorService.submit(new Callable<Statement>(){

                @Override
                public Statement call() throws Exception {
                    return parser.Statement();
                }
            });
            executorService.shutdown();
            statement = future.get(parser.getConfiguration().getAsInteger(Feature.timeOut).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            parser.interrupted = true;
            throw new JSQLParserException("Time out occurred.", ex);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
        return statement;
    }

    public static Statements parseStatements(String sqls) throws JSQLParserException {
        return CCJSqlParserUtil.parseStatements(sqls, null);
    }

    public static Statements parseStatements(String sqls, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Statements statements;
        block4: {
            statements = null;
            try {
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(sqls).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                statements = CCJSqlParserUtil.parseStatements(parser);
            }
            catch (JSQLParserException ex) {
                if (CCJSqlParserUtil.getNestingDepth(sqls) > 10) break block4;
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(sqls).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                statements = CCJSqlParserUtil.parseStatements(parser);
            }
        }
        return statements;
    }

    public static Statements parseStatements(final CCJSqlParser parser) throws JSQLParserException {
        Statements statements = null;
        try {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Statements> future = executorService.submit(new Callable<Statements>(){

                @Override
                public Statements call() throws Exception {
                    return parser.Statements();
                }
            });
            executorService.shutdown();
            statements = future.get(parser.getConfiguration().getAsInteger(Feature.timeOut).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            parser.interrupted = true;
            throw new JSQLParserException("Time out occurred.", ex);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
        return statements;
    }

    public static void streamStatements(StatementListener listener, InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is, encoding);
            do {
                Statement stmt = parser.SingleStatement();
                listener.accept(stmt);
                if (parser.getToken((int)1).kind != 318) continue;
                parser.getNextToken();
            } while (parser.getToken((int)1).kind != 0);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static int getNestingDepth(String sql) {
        char[] chars;
        int maxlevel = 0;
        int level = 0;
        block4: for (char c : chars = sql.toCharArray()) {
            switch (c) {
                case '(': {
                    ++level;
                    continue block4;
                }
                case ')': {
                    if (maxlevel < level) {
                        maxlevel = level;
                    }
                    --level;
                    continue block4;
                }
            }
        }
        return maxlevel;
    }
}

