/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_KEY = 2;
    private static final int STATE_VALUE = 4;
    private static final int STATE_ESCAPING = 8;
    private static final int STATE_QUOTING = 16;

    public static Map<String, String> splitKv(@Nonnull String text, @Nonnull Character entryDelimiter, @Nonnull Character kvDelimiter, @Nullable Character escapeChar, @Nullable Character quoteChar) {
        String value;
        HashMap<String, String> fields = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        String key = "";
        int state = 2;
        int kvState = 2;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == kvDelimiter.charValue()) {
                switch (state) {
                    case 2: {
                        key = stringBuilder.toString();
                        stringBuilder.setLength(0);
                        state = 4;
                        break;
                    }
                    case 4: {
                        throw new IllegalArgumentException("Unexpected token " + ch + " at position " + i + ".");
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (ch == entryDelimiter.charValue()) {
                switch (state) {
                    case 2: {
                        throw new IllegalArgumentException("Unexpected token " + ch + " at position " + i + ".");
                    }
                    case 4: {
                        value = stringBuilder.toString();
                        fields.put(key, value);
                        stringBuilder.setLength(0);
                        state = 2;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (escapeChar != null && ch == escapeChar.charValue()) {
                switch (state) {
                    case 2: 
                    case 4: {
                        kvState = state;
                        state = 8;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        stringBuilder.append(ch);
                    }
                }
                continue;
            }
            if (quoteChar != null && ch == quoteChar.charValue()) {
                switch (state) {
                    case 2: 
                    case 4: {
                        kvState = state;
                        state = 16;
                        break;
                    }
                    case 8: {
                        stringBuilder.append(ch);
                        state = kvState;
                        break;
                    }
                    case 16: {
                        state = kvState;
                    }
                }
                continue;
            }
            stringBuilder.append(ch);
        }
        switch (state) {
            case 2: {
                throw new IllegalArgumentException("Dangling key.");
            }
            case 4: {
                value = stringBuilder.toString();
                fields.put(key, value);
                return fields;
            }
            case 8: {
                throw new IllegalArgumentException("Not closed escaping.");
            }
            case 16: {
                throw new IllegalArgumentException("Not closed quoting.");
            }
        }
        throw new IllegalStateException();
    }

    public static String formatDate(String dateStr, String inputFormat, String format) {
        String resultStr = dateStr;
        try {
            Date date = new SimpleDateFormat(inputFormat).parse(dateStr);
            resultStr = StringUtil.formatDate(date, format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return resultStr;
    }

    public static String formatDate(String dateStr, String format) {
        String inputFormat = "yyyy-MM-dd HH:mm:ss";
        if (dateStr == null) {
            return "";
        }
        if (dateStr.matches("\\d{1,4}\\-\\d{1,2}\\-\\d{1,2}\\s+\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}")) {
            inputFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        } else if (dateStr.matches("\\d{4}\\-\\d{1,2}\\-\\d{1,2} +\\d{1,2}:\\d{1,2}")) {
            inputFormat = "yyyy-MM-dd HH:mm:ss";
        } else if (dateStr.matches("\\d{4}\\-\\d{1,2}\\-\\d{1,2} +\\d{1,2}:\\d{1,2}")) {
            inputFormat = "yyyy-MM-dd HH:mm";
        } else if (dateStr.matches("\\d{4}\\-\\d{1,2}\\-\\d{1,2} +\\d{1,2}")) {
            inputFormat = "yyyy-MM-dd HH";
        } else if (dateStr.matches("\\d{4}\\-\\d{1,2}\\-\\d{1,2} +\\d{1,2}")) {
            inputFormat = "yyyy-MM-dd";
        } else if (dateStr.matches("\\d{1,4}/\\d{1,2}/\\d{1,2}\\s+\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1,3}")) {
            inputFormat = "yyyy/MM/dd HH:mm:ss.SSS";
        } else if (dateStr.matches("\\d{4}/\\d{1,2}/\\d{1,2} +\\d{1,2}:\\d{1,2}")) {
            inputFormat = "yyyy/MM/dd HH:mm:ss";
        } else if (dateStr.matches("\\d{4}/\\d{1,2}/\\d{1,2} +\\d{1,2}:\\d{1,2}")) {
            inputFormat = "yyyy/MM/dd HH:mm";
        } else if (dateStr.matches("\\d{4}/\\d{1,2}/\\d{1,2} +\\d{1,2}")) {
            inputFormat = "yyyy/MM/dd HH";
        } else if (dateStr.matches("\\d{4}/\\d{1,2}/\\d{1,2} +\\d{1,2}")) {
            inputFormat = "yyyy/MM/dd";
        }
        String resultStr = StringUtil.formatDate(dateStr, inputFormat, format);
        return resultStr;
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static long parseDateTime(String value) {
        try {
            if (value.length() < 8) {
                return -1L;
            }
            if (value.length() <= 9) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                Date date = simpleDateFormat.parse(value.substring(0, 8));
                return new Timestamp(date.getTime()).getTime();
            }
            if (value.length() <= 11) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHH");
                Date date = simpleDateFormat.parse(value.substring(0, 10));
                return new Timestamp(date.getTime()).getTime();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
            Date date = simpleDateFormat.parse(value.substring(0, 12));
            return new Timestamp(date.getTime()).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unexpected time format : " + value);
        }
    }

    public static String parseChar(String charStr) {
        if (StringUtils.isNumeric(charStr)) {
            char numberChar = (char)Integer.parseInt(charStr);
            charStr = Character.toString(numberChar);
        }
        return charStr;
    }

    public static boolean isEmpty(Object str) {
        return str == null || str.toString().isEmpty();
    }
}

