/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.inlongmsgkv;

import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.types.Row;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.RowFormatInfo;
import org.apache.inlong.sort.formats.base.TableFormatUtils;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgBody;
import org.apache.inlong.sort.formats.inlongmsg.InLongMsgHead;
import org.apache.inlong.sort.formats.inlongmsg.row.InLongMsgUtils;
import org.apache.inlong.sort.formats.util.StringUtils;

public class InLongMsgKvUtils {
    public static final String DEFAULT_INLONGMSGKV_CHARSET = "ISO_8859_1";

    public static InLongMsgHead parseHead(String attr) {
        Timestamp time;
        String streamId;
        Map<String, String> attributes = InLongMsgUtils.parseAttr(attr);
        if (attributes.containsKey("streamId")) {
            streamId = attributes.get("streamId");
        } else if (attributes.containsKey("iname")) {
            streamId = attributes.get("iname");
        } else if (attributes.containsKey("tid")) {
            streamId = attributes.get("tid");
        } else {
            throw new IllegalArgumentException("Could not find streamId or tid in attributes!");
        }
        if (attributes.containsKey("dt")) {
            String epoch = attributes.get("dt").trim();
            time = InLongMsgUtils.parseEpochTime(epoch);
        } else if (attributes.containsKey("t")) {
            String date = attributes.get("t").trim();
            time = InLongMsgUtils.parseDateTime(date);
        } else {
            throw new IllegalArgumentException("Could not find t or t in attributes!");
        }
        List<String> predefinedFields = InLongMsgUtils.getPredefinedFields(attributes);
        return new InLongMsgHead(attributes, streamId, time, predefinedFields);
    }

    public static List<InLongMsgBody> parseBodyList(byte[] bytes, String charset, char entryDelimiter, char kvDelimiter, Character lineDelimiter, Character escapeChar, Character quoteChar) {
        String text = new String(bytes, Charset.forName(charset));
        List<Map<String, String>> list = StringUtils.splitKv(text, Character.valueOf(entryDelimiter), Character.valueOf(kvDelimiter), escapeChar, quoteChar, lineDelimiter, true);
        return list.stream().map(line -> new InLongMsgBody(bytes, null, Collections.emptyList(), (Map<String, String>)line)).collect(Collectors.toList());
    }

    public static Row deserializeRow(RowFormatInfo rowFormatInfo, String nullLiteral, List<String> predefinedFields, Map<String, String> entries) throws Exception {
        Object field;
        String fieldText;
        FormatInfo fieldFormatInfo;
        String fieldName;
        int i;
        String[] fieldNames = rowFormatInfo.getFieldNames();
        FormatInfo[] fieldFormatInfos = rowFormatInfo.getFieldFormatInfos();
        Row row = new Row(fieldNames.length);
        for (i = 0; i < predefinedFields.size() && i < fieldNames.length; ++i) {
            fieldName = fieldNames[i];
            fieldFormatInfo = fieldFormatInfos[i];
            fieldText = predefinedFields.get(i);
            field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, nullLiteral, null);
            row.setField(i, field);
        }
        for (i = predefinedFields.size(); i < fieldNames.length; ++i) {
            fieldName = fieldNames[i];
            fieldFormatInfo = fieldFormatInfos[i];
            fieldText = entries.get(fieldName);
            field = TableFormatUtils.deserializeBasicField(fieldName, fieldFormatInfo, fieldText, nullLiteral, null);
            row.setField(i, field);
        }
        return row;
    }
}

