/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.util;

public class ValidateUtils {
    public static void validateString(String key, String value, boolean isOptional) {
        ValidateUtils.validateString(key, value, isOptional, 0, Integer.MAX_VALUE);
    }

    public static void validateString(String key, String value, boolean isOptional, int minLen) {
        ValidateUtils.validateString(key, value, isOptional, minLen, Integer.MAX_VALUE);
    }

    public static void validateString(String key, String value, boolean isOptional, int minLen, int maxLen) {
        if (value == null) {
            if (!isOptional) {
                throw new IllegalArgumentException(String.format("Value of key %s must not be null!", key));
            }
        } else {
            if (value.length() < minLen) {
                throw new IllegalArgumentException(String.format("Value's length of key %s should be shorter than %d!", key, minLen));
            }
            if (value.length() > maxLen) {
                throw new IllegalArgumentException(String.format("Value's length of key %s should be longer than %d!", key, minLen));
            }
        }
    }
}

