/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.function.embedding;

import com.google.common.base.Strings;

public enum LanguageModel {
    BBAI_ZH("BAAI/bge-large-zh-v1.5"),
    BBAI_EN("BAAI/bge-large-en"),
    INTFLOAT_MULTI("intfloat/multilingual-e5-large");

    String model;

    private LanguageModel(String s2) {
        this.model = s2;
    }

    public String getModel() {
        return this.model;
    }

    public static boolean isLanguageModelSupported(String s2) {
        if (Strings.isNullOrEmpty(s2)) {
            return false;
        }
        for (LanguageModel lm : LanguageModel.values()) {
            if (!s2.equalsIgnoreCase(lm.getModel())) continue;
            return true;
        }
        return false;
    }

    public static String getAllSupportedLanguageModels() {
        if (LanguageModel.values().length == 0) {
            return null;
        }
        StringBuilder supportedLMBuilder = new StringBuilder();
        for (LanguageModel lm : LanguageModel.values()) {
            supportedLMBuilder.append(lm.getModel()).append(",");
        }
        return supportedLMBuilder.substring(0, supportedLMBuilder.length() - 1);
    }
}

