/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.load;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.enums.FilterStrategy;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;

@JsonTypeName(value="clickHouseLoad")
public class ClickHouseLoadNode
extends LoadNode
implements InlongMetric,
Serializable {
    private static final long serialVersionUID = -1L;
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="url")
    @Nonnull
    private String url;
    @JsonProperty(value="userName")
    @Nonnull
    private String userName;
    @JsonProperty(value="passWord")
    @Nonnull
    private String password;
    @JsonProperty(value="primaryKey")
    private String primaryKey;

    @JsonCreator
    public ClickHouseLoadNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @JsonProperty(value="fieldRelations") List<FieldRelation> fieldRelations, @JsonProperty(value="filters") List<FilterFunction> filters, @JsonProperty(value="filterStrategy") FilterStrategy filterStrategy, @Nullable @JsonProperty(value="sinkParallelism") Integer sinkParallelism, @JsonProperty(value="properties") Map<String, String> properties, @Nonnull @JsonProperty(value="tableName") String tableName, @Nonnull @JsonProperty(value="url") String url, @Nonnull @JsonProperty(value="userName") String userName, @Nonnull @JsonProperty(value="passWord") String password, @JsonProperty(value="primaryKey") String primaryKey) {
        super(id, name, fields, fieldRelations, filters, filterStrategy, sinkParallelism, properties);
        this.tableName = Preconditions.checkNotNull(tableName, "table name is null");
        this.url = Preconditions.checkNotNull(url, "url is null");
        this.userName = Preconditions.checkNotNull(userName, "userName is null");
        this.password = Preconditions.checkNotNull(password, "password is null");
        this.primaryKey = primaryKey;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "jdbc-inlong");
        options.put("dialect-impl", "org.apache.inlong.sort.jdbc.dialect.ClickHouseDialect");
        options.put("url", this.url);
        options.put("table-name", this.tableName);
        options.put("username", this.userName);
        options.put("password", this.password);
        return options;
    }

    @Override
    public String genTableName() {
        return this.tableName;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickHouseLoadNode)) {
            return false;
        }
        ClickHouseLoadNode other = (ClickHouseLoadNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClickHouseLoadNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public String getUserName() {
        return this.userName;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setUrl(@Nonnull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public void setUserName(@Nonnull String userName) {
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        this.userName = userName;
    }

    public void setPassword(@Nonnull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.password = password;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "ClickHouseLoadNode(tableName=" + this.getTableName() + ", url=" + this.getUrl() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public ClickHouseLoadNode() {
    }
}

