/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.sort.dataflow.field.format;

import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.BasicFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.TimeTypeInfo;

public class TimeFormatInfo
implements BasicFormatInfo<Time> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FORMAT = "format";
    private static final int DEFAULT_PRECISION_FOR_TIMESTAMP = 2;
    @JsonProperty(value="format")
    @Nonnull
    private final String format;
    @JsonProperty(value="precision")
    private int precision;

    @JsonCreator
    public TimeFormatInfo(@JsonProperty(value="format") @Nonnull String format, @JsonProperty(value="precision") int precision) {
        this.format = format;
        this.precision = precision;
        if (!(format.equals("SECONDS") || format.equals("MILLIS") || format.equals("MICROS") || "SQL".equals(format) || "ISO_8601".equals(format))) {
            FastDateFormat.getInstance((String)format);
        }
    }

    public TimeFormatInfo(@JsonProperty(value="format") @Nonnull String format) {
        this(format, 2);
    }

    public TimeFormatInfo() {
        this("HH:mm:ss", 2);
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Override
    public TimeTypeInfo getTypeInfo() {
        return TimeTypeInfo.INSTANCE;
    }

    @Override
    public String serialize(Time time) {
        switch (this.format) {
            case "MICROS": {
                long millis = time.getTime();
                long micros = TimeUnit.MILLISECONDS.toMicros(millis);
                return Long.toString(micros);
            }
            case "MILLIS": {
                long millis = time.getTime();
                return Long.toString(millis);
            }
            case "SECONDS": {
                long millis = time.getTime();
                long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
                return Long.toString(seconds);
            }
        }
        return FastDateFormat.getInstance((String)this.format).format(time.getTime());
    }

    @Override
    public Time deserialize(String text) throws ParseException {
        switch (this.format) {
            case "MICROS": {
                long micros = Long.parseLong(text);
                long millis = TimeUnit.MICROSECONDS.toMillis(micros);
                return new Time(millis);
            }
            case "MILLIS": {
                long millis = Long.parseLong(text);
                return new Time(millis);
            }
            case "SECONDS": {
                long seconds = Long.parseLong(text);
                long millis = TimeUnit.SECONDS.toMillis(seconds);
                return new Time(millis);
            }
        }
        Date date = FastDateFormat.getInstance((String)this.format).parse(text);
        return new Time(date.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeFormatInfo that = (TimeFormatInfo)o;
        return this.format.equals(that.format);
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public String toString() {
        return "TimeFormatInfo{format='" + this.format + '\'' + '}';
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

