/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.schema.DataCollectionId;

@Immutable
public final class CollectionId
implements DataCollectionId {
    private final String replicaSetName;
    private final String dbName;
    private final String name;

    public static CollectionId parse(String str) {
        int rsDotPosition = str.indexOf(46);
        if (rsDotPosition == -1 || rsDotPosition + 1 == str.length() || rsDotPosition == 0) {
            return null;
        }
        int dbDotPosition = str.indexOf(46, rsDotPosition + 1);
        if (dbDotPosition == -1 || dbDotPosition + 1 == str.length() || dbDotPosition == rsDotPosition + 1) {
            return null;
        }
        return new CollectionId(str.substring(0, rsDotPosition), str.substring(rsDotPosition + 1, dbDotPosition), str.substring(dbDotPosition + 1));
    }

    public static CollectionId parse(String replicaSetName, String str) {
        int dotPosition = str.indexOf(46);
        if (dotPosition == -1 || dotPosition + 1 == str.length() || dotPosition == 0) {
            return null;
        }
        return new CollectionId(replicaSetName, str.substring(0, dotPosition), str.substring(dotPosition + 1));
    }

    public CollectionId(String replicaSetName, String dbName, String collectionName) {
        this.replicaSetName = replicaSetName;
        this.dbName = dbName;
        this.name = collectionName;
        assert (this.replicaSetName != null);
        assert (this.dbName != null);
        assert (this.name != null);
    }

    public String name() {
        return this.name;
    }

    public String dbName() {
        return this.dbName;
    }

    public String replicaSetName() {
        return this.replicaSetName;
    }

    public String identifier() {
        return this.replicaSetName + "." + this.dbName + "." + this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CollectionId) {
            CollectionId that = (CollectionId)obj;
            return this.replicaSetName.equals(that.replicaSetName) && this.dbName.equals(that.dbName) && this.name.equals(that.name);
        }
        return false;
    }

    public String namespace() {
        return this.dbName + "." + this.name;
    }

    public String toString() {
        return this.identifier();
    }
}

