/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node.net;

import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.flume.node.net.AuthorizationProvider;

public class BasicAuthorizationProvider
implements AuthorizationProvider {
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private String authString = null;

    public BasicAuthorizationProvider(String userName, String password) {
        if (userName != null && password != null) {
            String toEncode = userName + ":" + password;
            this.authString = "Basic " + encoder.encodeToString(toEncode.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public void addAuthorization(URLConnection urlConnection) {
        if (this.authString != null) {
            urlConnection.setRequestProperty("Authorization", this.authString);
        }
    }
}

