/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.net.ssl.HttpsURLConnection;
import org.apache.flume.node.net.AuthorizationProvider;
import org.apache.flume.node.net.LaxHostnameVerifier;

public class UrlConnectionFactory {
    private static int DEFAULT_TIMEOUT;
    private static int connectTimeoutMillis;
    private static int readTimeoutMillis;
    private static final String XML = "application/xml";
    private static final String YAML = "application/yaml";
    private static final String JSON = "application/json";
    private static final String PROPERTIES = "text/x-java-properties";
    private static final String TEXT = "text/plain";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";

    public static HttpURLConnection createConnection(URL url, AuthorizationProvider authorizationProvider, long lastModifiedMillis, boolean verifyHost) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (HTTPS.equals(url.getProtocol()) && !verifyHost) {
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
        }
        if (authorizationProvider != null) {
            authorizationProvider.addAuthorization(urlConnection);
        }
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setRequestMethod("GET");
        if (connectTimeoutMillis > 0) {
            urlConnection.setConnectTimeout(connectTimeoutMillis);
        }
        if (readTimeoutMillis > 0) {
            urlConnection.setReadTimeout(readTimeoutMillis);
        }
        urlConnection.setRequestProperty("Content-Type", UrlConnectionFactory.getContentType(url));
        if (lastModifiedMillis > 0L) {
            ZonedDateTime zdt = Instant.ofEpochMilli(lastModifiedMillis).atZone(ZoneOffset.UTC);
            String lastModified = DateTimeFormatter.RFC_1123_DATE_TIME.format(zdt);
            urlConnection.setRequestProperty("If-Modified-Since", lastModified);
        }
        return urlConnection;
    }

    public static URLConnection createConnection(URL url) throws IOException {
        return UrlConnectionFactory.createConnection(url, null, 0L, true);
    }

    public static URLConnection createConnection(URL url, AuthorizationProvider authorizationProvider) throws IOException {
        URLConnection urlConnection = null;
        urlConnection = url.getProtocol().equals(HTTPS) || url.getProtocol().equals(HTTP) ? UrlConnectionFactory.createConnection(url, authorizationProvider, 0L, true) : url.openConnection();
        return urlConnection;
    }

    private static String getContentType(URL url) {
        String type;
        String[] fileParts = url.getFile().split("\\.");
        switch (type = fileParts[fileParts.length - 1].trim()) {
            case "properties": {
                return PROPERTIES;
            }
            case "json": {
                return JSON;
            }
            case "yaml": 
            case "yml": {
                return YAML;
            }
            case "xml": {
                return XML;
            }
        }
        return TEXT;
    }

    static {
        connectTimeoutMillis = DEFAULT_TIMEOUT = 60000;
        readTimeoutMillis = DEFAULT_TIMEOUT;
    }
}

