/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.EOFException;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.DataInput2;
import org.mapdb.SerializerPojo;

public abstract class Volume {
    public static final int CHUNK_SHIFT = 30;
    public static final int CHUNK_SIZE = 0x40000000;
    public static final int CHUNK_SIZE_MOD_MASK = 0x3FFFFFFF;

    public void ensureAvailable(long offset) {
        if (!this.tryAvailable(offset)) {
            throw new IOError(new IOException("no free space to expand Volume"));
        }
    }

    public abstract boolean tryAvailable(long var1);

    public abstract void putLong(long var1, long var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putByte(long var1, byte var3);

    public abstract void putData(long var1, byte[] var3, int var4, int var5);

    public abstract void putData(long var1, ByteBuffer var3);

    public abstract long getLong(long var1);

    public abstract int getInt(long var1);

    public abstract byte getByte(long var1);

    public abstract DataInput2 getDataInput(long var1, int var3);

    public abstract void close();

    public abstract void sync();

    public abstract boolean isEmpty();

    public abstract void deleteFile();

    public abstract boolean isSliced();

    public final void putUnsignedShort(long offset, int value) {
        this.putByte(offset, (byte)(value >> 8));
        this.putByte(offset + 1L, (byte)value);
    }

    public final int getUnsignedShort(long offset) {
        return (this.getByte(offset) & 0xFF) << 8 | this.getByte(offset + 1L) & 0xFF;
    }

    public int getUnsignedByte(long offset) {
        return this.getByte(offset) & 0xFF;
    }

    public void putUnsignedByte(long offset, int b) {
        this.putByte(offset, (byte)(b & 0xFF));
    }

    public long getSixLong(long pos) {
        return (long)(this.getByte(pos + 0L) & 0xFF) << 40 | (long)(this.getByte(pos + 1L) & 0xFF) << 32 | (long)(this.getByte(pos + 2L) & 0xFF) << 24 | (long)(this.getByte(pos + 3L) & 0xFF) << 16 | (long)(this.getByte(pos + 4L) & 0xFF) << 8 | (long)(this.getByte(pos + 5L) & 0xFF) << 0;
    }

    public void putSixLong(long pos, long value) {
        assert (value >= 0L && value >>> 48 == 0L) : "value does not fit";
        this.putByte(pos + 0L, (byte)(0xFFL & value >> 40));
        this.putByte(pos + 1L, (byte)(0xFFL & value >> 32));
        this.putByte(pos + 2L, (byte)(0xFFL & value >> 24));
        this.putByte(pos + 3L, (byte)(0xFFL & value >> 16));
        this.putByte(pos + 4L, (byte)(0xFFL & value >> 8));
        this.putByte(pos + 5L, (byte)(0xFFL & value >> 0));
    }

    public int putPackedLong(long pos, long value) {
        assert (value >= 0L) : "negative value";
        int ret = 0;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.putUnsignedByte(pos + (long)ret++, (int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.putUnsignedByte(pos + (long)ret++, (byte)value);
        return ret;
    }

    public abstract File getFile();

    public long getPackedLong(long pos) {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            long b = this.getUnsignedByte(pos++);
            result |= (b & 0x7FL) << offset;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new AssertionError((Object)"Malformed long.");
    }

    public static Volume volumeForFile(File f, boolean useRandomAccessFile, boolean readOnly, long sizeLimit, boolean fullChunkAllocation) {
        return useRandomAccessFile ? new FileChannelVol(f, readOnly, sizeLimit, fullChunkAllocation) : new MappedFileVol(f, readOnly, sizeLimit, fullChunkAllocation);
    }

    public static Factory fileFactory(boolean readOnly, int rafMode, File indexFile, long sizeLimit, boolean fullChunkAllocation) {
        return Volume.fileFactory(readOnly, rafMode, sizeLimit, fullChunkAllocation, indexFile, new File(indexFile.getPath() + ".p"), new File(indexFile.getPath() + ".t"));
    }

    public static Factory fileFactory(final boolean readOnly, final int rafMode, final long sizeLimit, final boolean fullChunkAllocation, final File indexFile, final File physFile, final File transLogFile) {
        return new Factory(){

            @Override
            public Volume createIndexVolume() {
                return Volume.volumeForFile(indexFile, rafMode > 1, readOnly, sizeLimit, fullChunkAllocation);
            }

            @Override
            public Volume createPhysVolume() {
                return Volume.volumeForFile(physFile, rafMode > 0, readOnly, sizeLimit, fullChunkAllocation);
            }

            @Override
            public Volume createTransLogVolume() {
                if (readOnly && !transLogFile.exists()) {
                    return null;
                }
                return Volume.volumeForFile(transLogFile, rafMode > 0, readOnly, sizeLimit, fullChunkAllocation);
            }
        };
    }

    public static Factory memoryFactory(final boolean useDirectBuffer, final long sizeLimit, final boolean fullChunkAllocation) {
        return new Factory(){

            @Override
            public synchronized Volume createIndexVolume() {
                return new MemoryVol(useDirectBuffer, sizeLimit, fullChunkAllocation);
            }

            @Override
            public synchronized Volume createPhysVolume() {
                return new MemoryVol(useDirectBuffer, sizeLimit, fullChunkAllocation);
            }

            @Override
            public synchronized Volume createTransLogVolume() {
                return new MemoryVol(useDirectBuffer, sizeLimit, fullChunkAllocation);
            }
        };
    }

    public static void volumeTransfer(long size, Volume from, Volume to) {
        int bufSize = 65536;
        for (long offset = 0L; offset < size; offset += (long)bufSize) {
            int bb = (int)Math.min((long)bufSize, size - offset);
            DataInput2 input = from.getDataInput(offset, bb);
            ByteBuffer buf = input.buf.duplicate();
            buf.position(input.pos);
            buf.limit(input.pos + bb);
            to.ensureAvailable(offset + (long)bb);
            to.putData(offset, buf);
        }
    }

    public static final class FileChannelVol
    extends Volume {
        protected final File file;
        protected FileChannel channel;
        protected final boolean readOnly;
        protected final long sizeLimit;
        protected final boolean hasLimit;
        protected final boolean fullChunkAllocation;
        protected volatile long size;
        protected Object growLock = new Object();

        public FileChannelVol(File file, boolean readOnly, long sizeLimit, boolean fullChunkAllocation) {
            this.file = file;
            this.readOnly = readOnly;
            this.sizeLimit = sizeLimit;
            this.fullChunkAllocation = fullChunkAllocation;
            this.hasLimit = sizeLimit > 0L;
            try {
                this.channel = new RandomAccessFile(file, readOnly ? "r" : "rw").getChannel();
                this.size = this.channel.size();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAvailable(long offset) {
            if (this.hasLimit && offset > this.sizeLimit) {
                return false;
            }
            if (this.fullChunkAllocation && offset % 0x40000000L != 0L) {
                offset += 0x40000000L - offset % 0x40000000L;
            }
            if (offset > this.size) {
                Object object = this.growLock;
                synchronized (object) {
                    try {
                        this.channel.truncate(offset);
                        this.size = offset;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }
            }
            return true;
        }

        protected void writeFully(long offset, ByteBuffer buf) throws IOException {
            int write;
            for (int remaining = buf.limit() - buf.position(); remaining > 0; remaining -= write) {
                write = this.channel.write(buf, offset);
                if (write >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public final void putSixLong(long offset, long value) {
            assert (value >= 0L && value >>> 48 == 0L) : "value does not fit";
            try {
                ByteBuffer buf = ByteBuffer.allocate(6);
                buf.put(0, (byte)(0xFFL & value >> 40));
                buf.put(1, (byte)(0xFFL & value >> 32));
                buf.put(2, (byte)(0xFFL & value >> 24));
                buf.put(3, (byte)(0xFFL & value >> 16));
                buf.put(4, (byte)(0xFFL & value >> 8));
                buf.put(5, (byte)(0xFFL & value >> 0));
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putLong(long offset, long value) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(8);
                buf.putLong(0, value);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putInt(long offset, int value) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(4);
                buf.putInt(0, value);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putByte(long offset, byte value) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(1);
                buf.put(0, value);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            try {
                ByteBuffer buf = ByteBuffer.wrap(src, srcPos, srcSize);
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void putData(long offset, ByteBuffer buf) {
            try {
                this.writeFully(offset, buf);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        protected void readFully(long offset, ByteBuffer buf) throws IOException {
            int read;
            for (int remaining = buf.limit() - buf.position(); remaining > 0; remaining -= read) {
                read = this.channel.read(buf, offset);
                if (read >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public final long getSixLong(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(6);
                this.readFully(offset, buf);
                return (long)(buf.get(0) & 0xFF) << 40 | (long)(buf.get(1) & 0xFF) << 32 | (long)(buf.get(2) & 0xFF) << 24 | (long)(buf.get(3) & 0xFF) << 16 | (long)(buf.get(4) & 0xFF) << 8 | (long)(buf.get(5) & 0xFF) << 0;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public long getLong(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(8);
                this.readFully(offset, buf);
                return buf.getLong(0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public int getInt(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(4);
                this.readFully(offset, buf);
                return buf.getInt(0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public byte getByte(long offset) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(1);
                this.readFully(offset, buf);
                return buf.get(0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public DataInput2 getDataInput(long offset, int size) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(size);
                this.readFully(offset, buf);
                return new DataInput2(buf, 0);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void sync() {
            try {
                this.channel.force(true);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public boolean isEmpty() {
            try {
                return this.channel == null || this.channel.size() == 0L;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void deleteFile() {
            this.file.delete();
        }

        @Override
        public boolean isSliced() {
            return false;
        }

        @Override
        public File getFile() {
            return this.file;
        }
    }

    public static final class MemoryVol
    extends ByteBufferVol {
        protected final boolean useDirectBuffer;

        public String toString() {
            return super.toString() + ",direct=" + this.useDirectBuffer;
        }

        public MemoryVol(boolean useDirectBuffer, long sizeLimit, boolean fullChunkAllocation) {
            super(false, sizeLimit, fullChunkAllocation);
            this.useDirectBuffer = useDirectBuffer;
            this.chunks = new ByteBuffer[1];
        }

        @Override
        protected ByteBuffer makeNewBuffer(long offset, ByteBuffer[] buffers2) {
            int curSize = (int)(offset & 0x3FFFFFFFL);
            int newBufSize = 1 << 32 - Integer.numberOfLeadingZeros(curSize - 1);
            if (this.fullChunkAllocation && newBufSize % 0x40000000 != 0) {
                newBufSize += 0x40000000 - newBufSize % 0x40000000;
            }
            ByteBuffer newBuf = this.useDirectBuffer ? ByteBuffer.allocateDirect(newBufSize) : ByteBuffer.allocate(newBufSize);
            int buffersPos = (int)(offset >>> 30);
            ByteBuffer oldBuffer = buffers2[buffersPos];
            if (oldBuffer != null) {
                oldBuffer = oldBuffer.duplicate();
                oldBuffer.rewind();
                newBuf.put(oldBuffer);
            }
            return newBuf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.growLock.lock();
            try {
                for (ByteBuffer b : this.chunks) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    this.unmap((MappedByteBuffer)b);
                }
                this.chunks = null;
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public void sync() {
        }

        @Override
        public void deleteFile() {
        }

        @Override
        public File getFile() {
            return null;
        }
    }

    public static final class MappedFileVol
    extends ByteBufferVol {
        protected final File file;
        protected final FileChannel fileChannel;
        protected final FileChannel.MapMode mapMode;
        protected final RandomAccessFile raf;
        protected ReferenceQueue<MappedByteBuffer> unreleasedQueue = new ReferenceQueue();
        protected Set<Reference<MappedByteBuffer>> unreleasedChunks = new LinkedHashSet<Reference<MappedByteBuffer>>();
        static final int BUF_SIZE_INC = 0x100000;

        public MappedFileVol(File file, boolean readOnly, long sizeLimit, boolean fullChunkAllocation) {
            super(readOnly, sizeLimit, fullChunkAllocation);
            this.file = file;
            this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            try {
                this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                this.fileChannel = this.raf.getChannel();
                long fileSize = this.fileChannel.size();
                if (fileSize > 0L) {
                    this.chunks = new ByteBuffer[(int)(1L + (fileSize >>> 30))];
                    int i = 0;
                    while ((long)i <= fileSize >>> 30) {
                        long offset = 0x40000000L * (long)i;
                        this.chunks[i] = this.fileChannel.map(this.mapMode, offset, Math.min(0x40000000L, fileSize - offset));
                        if (this.mapMode == FileChannel.MapMode.READ_ONLY) {
                            this.chunks[i] = this.chunks[i].asReadOnlyBuffer();
                        }
                        ++i;
                    }
                } else {
                    this.chunks = new ByteBuffer[1];
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public void close() {
            this.growLock.lock();
            try {
                this.fileChannel.close();
                this.raf.close();
                if (!this.readOnly) {
                    this.sync();
                }
                for (Reference<MappedByteBuffer> rb : this.unreleasedChunks) {
                    MappedByteBuffer b = rb.get();
                    if (b == null) continue;
                    this.unmap(b);
                }
                for (ByteBuffer b : this.chunks) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    this.unmap((MappedByteBuffer)b);
                }
                this.unreleasedChunks = null;
                this.unreleasedQueue = null;
                this.chunks = null;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                this.growLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sync() {
            if (this.readOnly) {
                return;
            }
            this.growLock.lock();
            try {
                Reference<MappedByteBuffer> ref = this.unreleasedQueue.poll();
                while (ref != null) {
                    this.unreleasedChunks.remove(ref);
                    ref = this.unreleasedQueue.poll();
                }
                for (Reference<MappedByteBuffer> rb : this.unreleasedChunks) {
                    MappedByteBuffer b = rb.get();
                    if (b == null) continue;
                    b.force();
                }
                for (ByteBuffer b : this.chunks) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    ((MappedByteBuffer)b).force();
                }
            }
            finally {
                this.growLock.unlock();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.chunks[0] == null || this.chunks[0].capacity() == 0;
        }

        @Override
        public void deleteFile() {
            this.file.delete();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        protected ByteBuffer makeNewBuffer(long offset, ByteBuffer[] buffers2) {
            assert (this.growLock.isHeldByCurrentThread());
            try {
                long rest;
                int round;
                long newChunkSize = offset & 0x3FFFFFFFL;
                int n = round = offset < 0x100000L ? 65536 : 0x100000;
                if (this.fullChunkAllocation) {
                    round = 0x40000000;
                }
                if ((rest = newChunkSize % (long)round) != 0L) {
                    newChunkSize += (long)round - rest;
                }
                MappedByteBuffer buf = this.fileChannel.map(this.mapMode, offset - (offset & 0x3FFFFFFFL), newChunkSize);
                this.unreleasedChunks.add(new WeakReference<MappedByteBuffer>(buf, this.unreleasedQueue));
                Reference<MappedByteBuffer> ref = this.unreleasedQueue.poll();
                while (ref != null) {
                    this.unreleasedChunks.remove(ref);
                    ref = this.unreleasedQueue.poll();
                }
                return buf;
            }
            catch (IOException e) {
                if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                    throw new RuntimeException("File could not be mapped to memory, common problem on 32bit JVM. Use `DBMaker.newRandomAccessFileDB()` as workaround", e);
                }
                throw new IOError(e);
            }
        }
    }

    public static abstract class ByteBufferVol
    extends Volume {
        protected final ReentrantLock growLock = new ReentrantLock(false);
        protected final long sizeLimit;
        protected final boolean hasLimit;
        protected final boolean fullChunkAllocation;
        protected volatile ByteBuffer[] chunks;
        protected final boolean readOnly;
        private static boolean unmapHackSupported = true;

        protected ByteBufferVol(boolean readOnly, long sizeLimit, boolean fullChunkAllocation) {
            this.readOnly = readOnly;
            this.sizeLimit = sizeLimit;
            this.fullChunkAllocation = fullChunkAllocation;
            this.hasLimit = sizeLimit > 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean tryAvailable(long offset) {
            if (this.hasLimit && offset > this.sizeLimit) {
                return false;
            }
            int chunkPos = (int)(offset >>> 30);
            if (chunkPos < this.chunks.length && this.chunks[chunkPos] != null && (long)this.chunks[chunkPos].capacity() >= (offset & 0x3FFFFFFFL)) {
                return true;
            }
            this.growLock.lock();
            try {
                ByteBuffer oldPrev;
                if (chunkPos < this.chunks.length && this.chunks[chunkPos] != null && (long)this.chunks[chunkPos].capacity() >= (offset & 0x3FFFFFFFL)) {
                    boolean bl = true;
                    return bl;
                }
                ByteBuffer[] chunks2 = this.chunks;
                if (chunkPos >= chunks2.length) {
                    chunks2 = Arrays.copyOf(chunks2, Math.max(chunkPos + 1, chunks2.length * 2));
                }
                if (chunks2[chunkPos] == null && chunkPos > 0 && ((oldPrev = chunks2[chunkPos - 1]) == null || oldPrev.capacity() != 0x40000000)) {
                    chunks2[chunkPos - 1] = this.makeNewBuffer(1L * (long)chunkPos * 0x40000000L - 1L, chunks2);
                }
                ByteBuffer newChunk = this.makeNewBuffer(offset, chunks2);
                if (this.readOnly) {
                    newChunk = newChunk.asReadOnlyBuffer();
                }
                chunks2[chunkPos] = newChunk;
                this.chunks = chunks2;
            }
            finally {
                this.growLock.unlock();
            }
            return true;
        }

        protected abstract ByteBuffer makeNewBuffer(long var1, ByteBuffer[] var3);

        @Override
        public final void putLong(long offset, long value) {
            this.chunks[(int)(offset >>> 30)].putLong((int)(offset & 0x3FFFFFFFL), value);
        }

        @Override
        public final void putInt(long offset, int value) {
            this.chunks[(int)(offset >>> 30)].putInt((int)(offset & 0x3FFFFFFFL), value);
        }

        @Override
        public final void putByte(long offset, byte value) {
            this.chunks[(int)(offset >>> 30)].put((int)(offset & 0x3FFFFFFFL), value);
        }

        @Override
        public void putData(long offset, byte[] src, int srcPos, int srcSize) {
            ByteBuffer b1 = this.chunks[(int)(offset >>> 30)].duplicate();
            int bufPos = (int)(offset & 0x3FFFFFFFL);
            b1.position(bufPos);
            b1.put(src, srcPos, srcSize);
        }

        @Override
        public final void putData(long offset, ByteBuffer buf) {
            ByteBuffer b1 = this.chunks[(int)(offset >>> 30)].duplicate();
            int bufPos = (int)(offset & 0x3FFFFFFFL);
            b1.position(bufPos);
            b1.put(buf);
        }

        @Override
        public final long getLong(long offset) {
            return this.chunks[(int)(offset >>> 30)].getLong((int)(offset & 0x3FFFFFFFL));
        }

        @Override
        public final int getInt(long offset) {
            return this.chunks[(int)(offset >>> 30)].getInt((int)(offset & 0x3FFFFFFFL));
        }

        @Override
        public final byte getByte(long offset) {
            return this.chunks[(int)(offset >>> 30)].get((int)(offset & 0x3FFFFFFFL));
        }

        @Override
        public final DataInput2 getDataInput(long offset, int size) {
            return new DataInput2(this.chunks[(int)(offset >>> 30)], (int)(offset & 0x3FFFFFFFL));
        }

        @Override
        public boolean isEmpty() {
            return this.chunks[0] == null || this.chunks[0].capacity() == 0;
        }

        @Override
        public boolean isSliced() {
            return true;
        }

        protected void unmap(MappedByteBuffer b) {
            try {
                Method cleanerMethod;
                if (unmapHackSupported && (cleanerMethod = b.getClass().getMethod("cleaner", new Class[0])) != null) {
                    cleanerMethod.setAccessible(true);
                    Object cleaner = cleanerMethod.invoke((Object)b, new Object[0]);
                    if (cleaner != null) {
                        Method clearMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                        if (cleanerMethod != null) {
                            clearMethod.invoke(cleaner, new Object[0]);
                        }
                    }
                }
            }
            catch (Exception e) {
                unmapHackSupported = false;
            }
        }

        static {
            try {
                unmapHackSupported = SerializerPojo.classForName("sun.nio.ch.DirectBuffer") != null;
            }
            catch (Exception e) {
                unmapHackSupported = false;
            }
        }
    }

    public static interface Factory {
        public Volume createIndexVolume();

        public Volume createPhysVolume();

        public Volume createTransLogVolume();
    }
}

