/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset;

import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.tubemq.server.broker.offset.OffsetCsmItem;

public class OffsetCsmRecord {
    protected int storeId;
    protected long offsetMin = 0L;
    protected long offsetMax = 0L;
    protected long dataMin = 0L;
    protected long dataMax = 0L;
    protected final Map<Integer, OffsetCsmItem> partitionCsmMap = new HashMap<Integer, OffsetCsmItem>();

    public OffsetCsmRecord(int storeId) {
        this.storeId = storeId;
    }

    public void addCsmOffsets(int partitionId, long offsetCfm, long tmpOffset) {
        OffsetCsmItem offsetCsmItem = this.partitionCsmMap.get(partitionId);
        if (offsetCsmItem == null) {
            OffsetCsmItem tmpItem = new OffsetCsmItem(partitionId);
            offsetCsmItem = this.partitionCsmMap.putIfAbsent(partitionId, tmpItem);
            if (offsetCsmItem == null) {
                offsetCsmItem = tmpItem;
            }
        }
        offsetCsmItem.addCsmOffsets(offsetCfm, tmpOffset);
    }

    public void addClientRecId(int partitionId, int clientRecId) {
        OffsetCsmItem offsetCsmItem = this.partitionCsmMap.get(partitionId);
        if (offsetCsmItem == null) {
            OffsetCsmItem tmpItem = new OffsetCsmItem(partitionId);
            offsetCsmItem = this.partitionCsmMap.putIfAbsent(partitionId, tmpItem);
            if (offsetCsmItem == null) {
                offsetCsmItem = tmpItem;
            }
        }
        offsetCsmItem.addClientRecId(clientRecId);
    }

    public void addStoreInfo(long offsetMin, long offsetMax, long dataMin, long dataMax) {
        this.offsetMin = offsetMin;
        this.offsetMax = offsetMax;
        this.dataMin = dataMin;
        this.dataMax = dataMax;
    }

    public int getStoreId() {
        return this.storeId;
    }
}

