/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset;

import java.util.Map;
import org.apache.inlong.tubemq.corebase.daemon.AbstractDaemonService;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.server.broker.BrokerServiceServer;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.broker.metadata.TopicMetadata;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStoreManager;
import org.apache.inlong.tubemq.server.broker.nodeinfo.ConsumerNodeInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetCsmRecord;
import org.apache.inlong.tubemq.server.broker.offset.OffsetHistoryInfo;
import org.apache.inlong.tubemq.server.broker.offset.OffsetService;
import org.apache.inlong.tubemq.server.broker.offset.topicpub.OffsetPubItem;
import org.apache.inlong.tubemq.server.broker.offset.topicpub.TopicPubInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetRecordService
extends AbstractDaemonService {
    private static final Logger logger = LoggerFactory.getLogger(OffsetRecordService.class);
    private final TubeBroker broker;
    private final MessageStoreManager storeManager;
    private final OffsetService offsetManager;
    private final int brokerAddrId;

    public OffsetRecordService(TubeBroker broker, long scanIntervalMs) {
        super("History-Offset", scanIntervalMs);
        this.broker = broker;
        this.storeManager = this.broker.getStoreManager();
        this.offsetManager = this.broker.getOffsetManager();
        this.brokerAddrId = AddressUtils.ipToInt((String)broker.getTubeConfig().getHostName());
        super.start();
    }

    protected void loopProcess(StringBuilder strBuff) {
        try {
            this.storeRecord2LocalTopic(strBuff);
        }
        catch (Throwable throwable) {
            logger.error("[Offset Record] Daemon commit thread throw error ", throwable);
        }
    }

    public void close() {
        if (super.stop()) {
            return;
        }
        StringBuilder strBuff = new StringBuilder(2048);
        this.storeRecord2LocalTopic(strBuff);
        logger.info("[Offset-Record Service] offset-record service stopped!");
    }

    private void storeRecord2LocalTopic(StringBuilder strBuff) {
        if (ServiceStatusHolder.isWriteServiceStop()) {
            return;
        }
        TopicMetadata csmHistoryMeta = this.storeManager.getMetadataManager().getTopicMetadata("__offset_history__");
        if (csmHistoryMeta == null || !csmHistoryMeta.isAcceptPublish()) {
            return;
        }
        BrokerServiceServer brokerService = this.broker.getBrokerServiceServer();
        Map<String, TopicPubInfo> topicPubInfoMap = this.storeManager.getTopicPublishInfos();
        Map<String, OffsetHistoryInfo> onlineGroupOffsetMap = this.offsetManager.getOnlineGroupOffsetInfo();
        if (!onlineGroupOffsetMap.isEmpty()) {
            this.addGroupOnlineInfo(brokerService, onlineGroupOffsetMap);
        }
        Map<String, OffsetHistoryInfo> offlineGroupOffsetMap = this.offsetManager.getOfflineGroupOffsetInfo();
        this.appendTopicProduceOffsets(topicPubInfoMap, onlineGroupOffsetMap);
        this.appendTopicProduceOffsets(topicPubInfoMap, offlineGroupOffsetMap);
        long currTime = System.currentTimeMillis();
        brokerService.appendGroupOffsetInfo(onlineGroupOffsetMap, this.brokerAddrId, currTime, 20, 5L, strBuff);
        brokerService.appendGroupOffsetInfo(offlineGroupOffsetMap, this.brokerAddrId, currTime, 20, 5L, strBuff);
    }

    private void appendTopicProduceOffsets(Map<String, TopicPubInfo> topicPubInfoMap, Map<String, OffsetHistoryInfo> groupOffsetMap) {
        for (Map.Entry<String, OffsetHistoryInfo> entry : groupOffsetMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            Map<String, Map<Integer, OffsetCsmRecord>> topicOffsetMap = entry.getValue().getOffsetMap();
            for (Map.Entry<String, Map<Integer, OffsetCsmRecord>> entryTopic : topicOffsetMap.entrySet()) {
                TopicPubInfo topicPubInfo;
                if (entryTopic == null || entryTopic.getKey() == null || entryTopic.getValue() == null || (topicPubInfo = topicPubInfoMap.get(entryTopic.getKey())) == null) continue;
                for (Map.Entry<Integer, OffsetCsmRecord> entryRcd : entryTopic.getValue().entrySet()) {
                    OffsetPubItem offsetPub = topicPubInfo.getTopicStorePubInfo(entryRcd.getValue().getStoreId());
                    if (offsetPub == null) continue;
                    entryRcd.getValue().addStoreInfo(offsetPub.getIndexMin(), offsetPub.getIndexMax(), offsetPub.getDataMin(), offsetPub.getDataMax());
                }
            }
        }
    }

    private void addGroupOnlineInfo(BrokerServiceServer brokerService, Map<String, OffsetHistoryInfo> groupOffsetMap) {
        Map<String, ConsumerNodeInfo> regMap = brokerService.getConsumerRegisterMap();
        for (Map.Entry<String, ConsumerNodeInfo> entry : regMap.entrySet()) {
            String[] partitionIdArr;
            String groupName;
            OffsetHistoryInfo historyInfo;
            if (entry == null || entry.getKey() == null || entry.getValue() == null || (historyInfo = groupOffsetMap.get(groupName = (partitionIdArr = entry.getKey().split(":"))[0])) == null) continue;
            historyInfo.addGroupOnlineInfo(true, entry.getValue().isFilterConsume(), entry.getValue().getConsumerId(), brokerService.getConsumerRegisterTime(entry.getValue().getConsumerId(), entry.getKey()), partitionIdArr[1], Integer.parseInt(partitionIdArr[2]));
        }
    }
}

