/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlItem;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlRuleHandler;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbBrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;

public class WebParameterUtils {
    private static final List<String> allowedDelUnits = Arrays.asList("s", "m", "h");
    private static final List<Integer> allowedPriorityVal = Arrays.asList(1, 2, 3);

    public static void buildFailResult(StringBuilder sBuffer, String errMsg) {
        sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"").append(errMsg).append("\"}");
    }

    public static void buildFailResultWithBlankData(int errcode, String errMsg, StringBuilder sBuffer) {
        sBuffer.append("{\"result\":false,\"errCode\":").append(errcode).append(",\"errMsg\":\"").append(errMsg).append("\",\"data\":[]}");
    }

    public static void buildSuccessResult(StringBuilder sBuffer) {
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"OK\",\"data\":[]}");
    }

    public static void buildSuccessResult(StringBuilder sBuffer, String appendInfo) {
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"").append(appendInfo).append("\",\"data\":[]}");
    }

    public static void buildSuccessWithDataRetBegin(StringBuilder sBuffer) {
        sBuffer.append("{\"result\":true,\"errCode\":0,\"errMsg\":\"OK\",\"data\":[");
    }

    public static void buildSuccessWithDataRetEnd(StringBuilder sBuffer, int totalCnt) {
        sBuffer.append("],\"count\":").append(totalCnt).append("}");
    }

    public static <T> boolean getAUDBaseInfo(T paramCntr, boolean isAdd, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getLongParamValue(paramCntr, WebFieldDef.DATAVERSIONID, false, defOpEntity == null ? -2L : defOpEntity.getDataVerId(), sBuffer, result)) {
            return result.isSuccess();
        }
        long dataVerId = (Long)result.getRetData();
        String createUsr = null;
        Date createDate = new Date();
        if (isAdd) {
            if (!WebParameterUtils.getStringParamValue(paramCntr, WebFieldDef.CREATEUSER, defOpEntity == null, defOpEntity == null ? createUsr : defOpEntity.getCreateUser(), sBuffer, result)) {
                return result.isSuccess();
            }
            createUsr = (String)result.getRetData();
            if (!WebParameterUtils.getDateParameter(paramCntr, WebFieldDef.CREATEDATE, false, defOpEntity == null || defOpEntity.getCreateDate() == null ? createDate : defOpEntity.getCreateDate(), sBuffer, result)) {
                return result.isSuccess();
            }
            createDate = (Date)result.getRetData();
        }
        if (!WebParameterUtils.getStringParamValue(paramCntr, WebFieldDef.MODIFYUSER, defOpEntity == null && !isAdd, defOpEntity == null ? createUsr : defOpEntity.getModifyUser(), sBuffer, result)) {
            return result.isSuccess();
        }
        String modifyUser = (String)result.getRetData();
        if (!WebParameterUtils.getDateParameter(paramCntr, WebFieldDef.MODIFYDATE, false, defOpEntity == null || defOpEntity.getModifyDate() == null ? createDate : defOpEntity.getModifyDate(), sBuffer, result)) {
            return result.isSuccess();
        }
        Date modifyDate = (Date)result.getRetData();
        result.setSuccResult((Object)new BaseEntity(dataVerId, createUsr, createDate, modifyUser, modifyDate));
        return result.isSuccess();
    }

    public static boolean getQueriedOperateInfo(HttpServletRequest req, BaseEntity qryEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getLongParamValue(req, WebFieldDef.DATAVERSIONID, false, -2L, sBuffer, result)) {
            return result.isSuccess();
        }
        long dataVerId = (Long)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.CREATEUSER, false, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String createUser = (String)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.MODIFYUSER, false, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String modifyUser = (String)result.getRetData();
        qryEntity.updQueryKeyInfo(dataVerId, createUser, modifyUser);
        result.setSuccResult((Object)qryEntity);
        return result.isSuccess();
    }

    public static <T> boolean getQryPriorityIdParameter(T paramCntr, boolean required, int defValue, int minValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.QRYPRIORITYID, required, defValue, minValue, sBuffer, result)) {
            return result.isSuccess();
        }
        int qryPriorityId = (Integer)result.getRetData();
        if (qryPriorityId == defValue) {
            return result.isSuccess();
        }
        if (qryPriorityId > 303 || qryPriorityId < 101) {
            result.setFailResult(sBuffer.append("Illegal value in ").append(WebFieldDef.QRYPRIORITYID.name).append(" parameter: ").append(WebFieldDef.QRYPRIORITYID.name).append(" value must be greater than or equal").append(" to 101 and less than or equal to 303!").toString());
            sBuffer.delete(0, sBuffer.length());
            return false;
        }
        if (!allowedPriorityVal.contains(qryPriorityId % 100)) {
            result.setFailResult(sBuffer.append("Illegal value in ").append(WebFieldDef.QRYPRIORITYID.name).append(" parameter: the units of ").append(WebFieldDef.QRYPRIORITYID.name).append(" must in ").append(allowedPriorityVal).toString());
            sBuffer.delete(0, sBuffer.length());
            return false;
        }
        if (!allowedPriorityVal.contains(qryPriorityId / 100)) {
            result.setFailResult(sBuffer.append("Illegal value in ").append(WebFieldDef.QRYPRIORITYID.name).append(" parameter: the hundreds of ").append(WebFieldDef.QRYPRIORITYID.name).append(" must in ").append(allowedPriorityVal).toString());
            sBuffer.delete(0, sBuffer.length());
            return false;
        }
        result.setSuccResult((Object)qryPriorityId);
        return result.isSuccess();
    }

    public static <T> boolean getEnableStatusValue(T paramCntr, WebFieldDef fieldDef, boolean required, EnableStatus defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getBooleanParamValue(paramCntr, fieldDef, required, null, sBuffer, result)) {
            return result.isSuccess();
        }
        Boolean enableValue = (Boolean)result.getRetData();
        if (enableValue == null) {
            result.setSuccResult((Object)defValue);
        } else if (enableValue.booleanValue()) {
            result.setSuccResult((Object)EnableStatus.STATUS_ENABLE);
        } else {
            result.setSuccResult((Object)EnableStatus.STATUS_DISABLE);
        }
        return result.isSuccess();
    }

    public static <T> boolean getDeletePolicyParameter(T paramCntr, boolean required, String defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(paramCntr, WebFieldDef.DELETEPOLICY, required, defValue, sBuffer, result)) {
            return result.isSuccess();
        }
        String delPolicy = (String)result.getRetData();
        if (TStringUtils.isBlank((String)delPolicy)) {
            return result.isSuccess();
        }
        String[] tmpStrs = delPolicy.split(",");
        if (tmpStrs.length != 2) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("Value must include one and only one comma character,").append(" the format of ").append(WebFieldDef.DELETEPOLICY.name()).append(" must like {method},{digital}[m|s|h]").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (TStringUtils.isBlank((String)tmpStrs[0])) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("Method value must not be blank, the format of ").append(WebFieldDef.DELETEPOLICY.name()).append(" must like {method},{digital}[m|s|h]").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (!"delete".equalsIgnoreCase(tmpStrs[0].trim())) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("Field ").append(WebFieldDef.DELETEPOLICY.name()).append(" only support delete method now!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        String validValStr = tmpStrs[1];
        String timeUnit = validValStr.substring(validValStr.length() - 1).toLowerCase();
        if (Character.isLetter(timeUnit.charAt(0)) && !allowedDelUnits.contains(timeUnit)) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("Field ").append(WebFieldDef.DELETEPOLICY.name()).append(" only support [s|m|h] unit!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        long validDuration = 0L;
        try {
            validDuration = timeUnit.endsWith("s") ? Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 1000L : (timeUnit.endsWith("m") ? Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 60000L : (timeUnit.endsWith("h") ? Long.parseLong(validValStr.substring(0, validValStr.length() - 1)) * 3600000L : Long.parseLong(validValStr) * 3600000L));
        }
        catch (Throwable e) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("The value of field ").append(WebFieldDef.DELETEPOLICY.name()).append("'s valid duration must digits!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (validDuration <= 0L || validDuration > 604800000L) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("The value of field ").append(WebFieldDef.DELETEPOLICY.name()).append(" must be greater than 0 and  less than or equal to").append(604800000L).append(" seconds!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (Character.isLetter(timeUnit.charAt(0))) {
            result.setSuccResult((Object)sBuffer.append("delete,").append(validValStr.substring(0, validValStr.length() - 1)).append(timeUnit).toString());
        } else {
            result.setSuccResult((Object)sBuffer.append("delete,").append(validValStr).append("h").toString());
        }
        sBuffer.delete(0, sBuffer.length());
        return result.isSuccess();
    }

    public static boolean getTopicStatusParamValue(HttpServletRequest req, boolean isRequired, TopicStatus defVal, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.TOPICSTATUSID, isRequired, defVal.getCode(), TopicStatus.STATUS_TOPIC_UNDEFINED.getCode(), sBuffer, result)) {
            return result.isSuccess();
        }
        int paramValue = (Integer)result.getRetData();
        try {
            TopicStatus topicStatus = TopicStatus.valueOf(paramValue);
            result.setSuccResult((Object)topicStatus);
        }
        catch (Throwable e) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), sBuffer.append("The value of field ").append(WebFieldDef.TOPICSTATUSID.name).append(" invalid:").append(e.getMessage()).toString());
            sBuffer.delete(0, sBuffer.length());
        }
        return result.isSuccess();
    }

    public static boolean isValidPortsSet(int brokerPort, int brokerTlsPort, int brokerWebPort, StringBuilder strBuff, ProcessResult result) {
        if (brokerPort == brokerWebPort || brokerTlsPort == brokerWebPort) {
            result.setFailResult(DataOpErrCode.DERR_ILLEGAL_VALUE.getCode(), strBuff.append(DataOpErrCode.DERR_CONFLICT_VALUE.getDescription()).append(", the value of ").append(WebFieldDef.BROKERPORT.name).append(" or ").append(WebFieldDef.BROKERTLSPORT.name).append(" cannot be the same as the value of ").append(WebFieldDef.BROKERWEBPORT.name).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        return true;
    }

    public static <T> boolean getTopicPropInfo(T paramCntr, TopicPropGroup defVal, StringBuilder sBuffer, ProcessResult result) {
        TopicPropGroup newConf = new TopicPropGroup();
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.NUMTOPICSTORES, false, defVal == null ? -2 : defVal.getNumTopicStores(), 1, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setNumTopicStores((Integer)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.NUMPARTITIONS, false, defVal == null ? -2 : defVal.getNumPartitions(), 1, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setNumPartitions((Integer)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.UNFLUSHTHRESHOLD, false, defVal == null ? -2 : defVal.getUnflushThreshold(), 0, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setUnflushThreshold((Integer)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.UNFLUSHINTERVAL, false, defVal == null ? -2 : defVal.getUnflushInterval(), 1, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setUnflushInterval((Integer)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.UNFLUSHDATAHOLD, false, defVal == null ? -2 : defVal.getUnflushDataHold(), 0, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setUnflushDataHold((Integer)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.MCACHESIZEINMB, false, defVal == null ? -2 : defVal.getMemCacheMsgSizeInMB(), 2, 2048, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setMemCacheMsgSizeInMB((Integer)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.UNFMCACHEINTERVAL, false, defVal == null ? -2 : defVal.getMemCacheFlushIntvl(), 4000, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setMemCacheFlushIntvl((Integer)result.getRetData());
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.UNFMCACHECNTINK, false, defVal == null ? -2 : defVal.getMemCacheMsgCntInK(), 1, sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setMemCacheMsgCntInK((Integer)result.getRetData());
        if (!WebParameterUtils.getDeletePolicyParameter(paramCntr, false, defVal == null ? null : defVal.getDeletePolicy(), sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setDeletePolicy((String)result.getRetData());
        if (!WebParameterUtils.getBooleanParamValue(paramCntr, WebFieldDef.ACCEPTPUBLISH, false, defVal == null ? null : defVal.getAcceptPublish(), sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setAcceptPublish((Boolean)result.getRetData());
        if (!WebParameterUtils.getBooleanParamValue(paramCntr, WebFieldDef.ACCEPTSUBSCRIBE, false, defVal == null ? null : defVal.getAcceptSubscribe(), sBuffer, result)) {
            return result.isSuccess();
        }
        newConf.setAcceptSubscribe((Boolean)result.getRetData());
        result.setSuccResult((Object)newConf);
        return result.isSuccess();
    }

    public static <T> boolean getLongParamValue(T paramCntr, WebFieldDef fieldDef, boolean required, long defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(paramCntr, fieldDef, required, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String paramValue = (String)result.getRetData();
        if (paramValue == null) {
            result.setSuccResult((Object)defValue);
            return result.isSuccess();
        }
        try {
            long paramIntVal = Long.parseLong(paramValue);
            result.setSuccResult((Object)paramIntVal);
        }
        catch (Throwable e) {
            result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append(" parse error: ").append(e.getMessage()).toString());
            sBuffer.delete(0, sBuffer.length());
        }
        return result.isSuccess();
    }

    public static <T> boolean getFlowCtrlStatusParamValue(T paramCntr, boolean required, EnableStatus defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(paramCntr, WebFieldDef.STATUSID, required, -2, 0, 1, sBuffer, result)) {
            return result.isSuccess();
        }
        int paramValue = (Integer)result.getRetData();
        if (paramValue == -2) {
            result.setSuccResult((Object)defValue);
        } else if (paramValue == 1) {
            result.setSuccResult((Object)EnableStatus.STATUS_ENABLE);
        } else {
            result.setSuccResult((Object)EnableStatus.STATUS_DISABLE);
        }
        return result.isSuccess();
    }

    public static <T> boolean getIntParamValue(T paramCntr, WebFieldDef fieldDef, boolean required, StringBuilder sBuffer, ProcessResult result) {
        return WebParameterUtils.getIntParamValue(paramCntr, fieldDef, required, false, -2, false, -2, false, -2, sBuffer, result);
    }

    public static <T> boolean getIntParamValue(T paramCntr, WebFieldDef fieldDef, boolean required, int defValue, int minValue, StringBuilder sBuffer, ProcessResult result) {
        return WebParameterUtils.getIntParamValue(paramCntr, fieldDef, required, true, defValue, true, minValue, false, -2, sBuffer, result);
    }

    public static <T> boolean getIntParamValue(T paramCntr, WebFieldDef fieldDef, boolean required, int defValue, int minValue, int maxValue, StringBuilder sBuffer, ProcessResult result) {
        return WebParameterUtils.getIntParamValue(paramCntr, fieldDef, required, true, defValue, true, minValue, true, maxValue, sBuffer, result);
    }

    private static <T> boolean getIntParamValue(T paramCntr, WebFieldDef fieldDef, boolean required, boolean hasDefVal, int defValue, boolean hasMinVal, int minValue, boolean hasMaxVal, int maxValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(paramCntr, fieldDef, required, null, sBuffer, result)) {
            return result.isSuccess();
        }
        if (fieldDef.isCompFieldType()) {
            HashSet<Integer> tgtValueSet = new HashSet<Integer>();
            Set valItemSet = (Set)result.getRetData();
            if (valItemSet.isEmpty()) {
                if (hasDefVal) {
                    tgtValueSet.add(defValue);
                }
                result.setSuccResult(tgtValueSet);
                return result.isSuccess();
            }
            for (String itemVal : valItemSet) {
                if (!WebParameterUtils.checkIntValueNorms(fieldDef, itemVal, hasMinVal, minValue, hasMaxVal, maxValue, sBuffer, result)) {
                    return result.isSuccess();
                }
                tgtValueSet.add((Integer)result.getRetData());
            }
            result.setSuccResult(tgtValueSet);
        } else {
            String paramValue = (String)result.getRetData();
            if (paramValue == null) {
                if (hasDefVal) {
                    result.setSuccResult((Object)defValue);
                }
                return result.isSuccess();
            }
            WebParameterUtils.checkIntValueNorms(fieldDef, paramValue, hasMinVal, minValue, hasMaxVal, maxValue, sBuffer, result);
        }
        return result.isSuccess();
    }

    public static <T> boolean getBooleanParamValue(T paramCntr, WebFieldDef fieldDef, boolean required, Boolean defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(paramCntr, fieldDef, required, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String paramValue = (String)result.getRetData();
        if (paramValue == null) {
            result.setSuccResult((Object)defValue);
            return result.isSuccess();
        }
        if (paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("false")) {
            result.setSuccResult((Object)Boolean.parseBoolean(paramValue));
        } else {
            try {
                result.setSuccResult((Object)(Long.parseLong(paramValue) != 0L ? 1 : 0));
            }
            catch (Throwable e) {
                result.setSuccResult((Object)defValue);
            }
        }
        return result.isSuccess();
    }

    public static <T> boolean getStringParamValue(T paramCntr, WebFieldDef fieldDef, boolean required, String defValue, StringBuilder sBuffer, ProcessResult result) {
        String paramValue;
        if (paramCntr instanceof Map) {
            Map keyValueMap = (Map)paramCntr;
            paramValue = (String)keyValueMap.get(fieldDef.name);
            if (paramValue == null) {
                paramValue = (String)keyValueMap.get(fieldDef.shortName);
            }
        } else if (paramCntr instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)paramCntr;
            paramValue = req.getParameter(fieldDef.name);
            if (paramValue == null) {
                paramValue = req.getParameter(fieldDef.shortName);
            }
        } else if (paramCntr instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)paramCntr;
            paramValue = jsonObject.get(fieldDef.name).getAsString();
            if (paramValue == null) {
                paramValue = jsonObject.get(fieldDef.shortName).getAsString();
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter type!");
        }
        return WebParameterUtils.checkStrParamValue(paramValue, fieldDef, required, defValue, sBuffer, result);
    }

    private static boolean checkStrParamValue(String paramValue, WebFieldDef fieldDef, boolean required, String defValue, StringBuilder sBuffer, ProcessResult result) {
        if (TStringUtils.isNotBlank((String)paramValue)) {
            paramValue = WebParameterUtils.escDoubleQuotes(paramValue.trim());
        }
        if (TStringUtils.isBlank((String)paramValue)) {
            if (required) {
                result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append(" is missing or value is blank!").toString());
                sBuffer.delete(0, sBuffer.length());
            } else {
                WebParameterUtils.procStringDefValue(fieldDef.isCompFieldType(), defValue, result);
            }
            return result.isSuccess();
        }
        if (fieldDef.isCompFieldType()) {
            String[] strParamValueItems;
            TreeSet<String> valItemSet = new TreeSet<String>();
            for (String strParamValueItem : strParamValueItems = paramValue.split(fieldDef.splitToken)) {
                if (TStringUtils.isBlank((String)strParamValueItem)) continue;
                if (!WebParameterUtils.checkStrValueNorms(fieldDef, strParamValueItem, sBuffer, result)) {
                    return result.isSuccess();
                }
                valItemSet.add((String)result.getRetData());
            }
            if (valItemSet.isEmpty()) {
                if (required) {
                    result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append(" is missing or value is blank!").toString());
                    sBuffer.delete(0, sBuffer.length());
                } else {
                    WebParameterUtils.procStringDefValue(fieldDef.isCompFieldType(), defValue, result);
                }
                return result.isSuccess();
            }
            if (fieldDef.itemMaxCnt != -2 && valItemSet.size() > fieldDef.itemMaxCnt) {
                result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append("'s item count over max allowed count (").append(fieldDef.itemMaxCnt).append(")!").toString());
                sBuffer.delete(0, sBuffer.length());
            }
            valItemSet.comparator();
            result.setSuccResult(valItemSet);
        } else {
            if (!WebParameterUtils.checkStrValueNorms(fieldDef, paramValue, sBuffer, result)) {
                return result.isSuccess();
            }
            result.setSuccResult((Object)paramValue);
        }
        return result.isSuccess();
    }

    public static boolean getAndValidTopicNameInfo(HttpServletRequest req, MetaDataService defMetaDataService, boolean required, String defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, required, defValue, sBuffer, result)) {
            return result.isSuccess();
        }
        Set topicNameSet = (Set)result.getRetData();
        Set<String> existedTopicSet = defMetaDataService.getDeployedTopicSet();
        for (String topic : topicNameSet) {
            if (existedTopicSet.contains(topic)) continue;
            result.setFailResult(sBuffer.append(WebFieldDef.COMPSTOPICNAME.name).append(" value ").append(topic).append(" is not configure, please configure first!").toString());
            sBuffer.delete(0, sBuffer.length());
            break;
        }
        return result.isSuccess();
    }

    public static <T> boolean getFilterCondString(T paramCntr, boolean required, boolean transBlank, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getFilterCondSet(paramCntr, required, false, sBuffer, result)) {
            return result.isSuccess();
        }
        Set filterCondSet = (Set)result.getRetData();
        if (filterCondSet.isEmpty()) {
            if (transBlank) {
                sBuffer.append(",,");
            }
        } else {
            sBuffer.append(",");
            for (String filterCond : filterCondSet) {
                sBuffer.append(filterCond).append(",");
            }
        }
        result.setSuccResult((Object)sBuffer.toString());
        sBuffer.delete(0, sBuffer.length());
        return result.isSuccess();
    }

    public static <T> boolean getFilterCondSet(T paramCntr, boolean required, boolean transCondItem, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(paramCntr, WebFieldDef.FILTERCONDS, required, null, sBuffer, result)) {
            return result.isSuccess();
        }
        if (transCondItem) {
            TreeSet<String> newFilterCondSet = new TreeSet<String>();
            Set filterCondSet = (Set)result.getRetData();
            if (!filterCondSet.isEmpty()) {
                for (String filterCond : filterCondSet) {
                    newFilterCondSet.add(sBuffer.append(",").append(filterCond).append(",").toString());
                    sBuffer.delete(0, sBuffer.length());
                }
                newFilterCondSet.comparator();
            }
            result.setSuccResult(newFilterCondSet);
        }
        return result.isSuccess();
    }

    public static boolean isFilterSetFullIncluded(Set<String> qryFilterSet, String confFilterStr) {
        if (qryFilterSet == null || qryFilterSet.isEmpty()) {
            return true;
        }
        if (confFilterStr == null || confFilterStr.length() == 2 && confFilterStr.equals(",,")) {
            return false;
        }
        boolean allInc = true;
        for (String filterCond : qryFilterSet) {
            if (confFilterStr.contains(filterCond)) continue;
            allInc = false;
            break;
        }
        return allInc;
    }

    public static boolean getJsonDictParamValue(HttpServletRequest req, WebFieldDef fieldDef, boolean required, Map<String, Long> defValue, ProcessResult result) {
        String paramValue = req.getParameter(fieldDef.name);
        if (paramValue == null) {
            paramValue = req.getParameter(fieldDef.shortName);
        }
        if (TStringUtils.isNotBlank((String)paramValue)) {
            paramValue = WebParameterUtils.escDoubleQuotes(paramValue.trim());
        }
        if (TStringUtils.isBlank((String)paramValue)) {
            if (required) {
                result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append(" is missing or value is blank!").toString());
            } else {
                result.setSuccResult(defValue);
            }
            return result.isSuccess();
        }
        try {
            paramValue = URLDecoder.decode(paramValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append(" decode error, exception is ").append(e.toString()).toString());
        }
        if (TStringUtils.isBlank((String)paramValue)) {
            if (required) {
                result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append("'s value is blank!").toString());
            } else {
                result.setSuccResult(defValue);
            }
            return result.isSuccess();
        }
        if (fieldDef.valMaxLen != -2 && paramValue.length() > fieldDef.valMaxLen) {
            result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append("'s length over max allowed length (").append(fieldDef.valMaxLen).append(")!").toString());
            return result.isSuccess();
        }
        try {
            Map manOffsets = (Map)new Gson().fromJson(paramValue, new TypeToken<Map<String, Long>>(){}.getType());
            result.setSuccResult((Object)manOffsets);
        }
        catch (Throwable e) {
            result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append(" value parse failure, error is ").append(e.getMessage()).append("!").toString());
        }
        return result.isSuccess();
    }

    public static boolean getJsonArrayParamValue(HttpServletRequest req, WebFieldDef fieldDef, boolean required, List<Map<String, String>> defValue, ProcessResult result) {
        String paramValue = req.getParameter(fieldDef.name);
        if (paramValue == null) {
            paramValue = req.getParameter(fieldDef.shortName);
        }
        if (TStringUtils.isNotBlank((String)paramValue)) {
            paramValue = WebParameterUtils.escDoubleQuotes(paramValue.trim());
        }
        if (TStringUtils.isBlank((String)paramValue)) {
            if (required) {
                result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append(" is missing or value is blank!").toString());
            } else {
                result.setSuccResult(defValue);
            }
            return result.isSuccess();
        }
        try {
            paramValue = URLDecoder.decode(paramValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append(" decode error, exception is ").append(e.toString()).toString());
        }
        if (TStringUtils.isBlank((String)paramValue)) {
            if (required) {
                result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append("'s value is blank!").toString());
            } else {
                result.setSuccResult(defValue);
            }
            return result.isSuccess();
        }
        if (fieldDef.valMaxLen != -2 && paramValue.length() > fieldDef.valMaxLen) {
            result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append("'s length over max allowed length (").append(fieldDef.valMaxLen).append(")!").toString());
            return result.isSuccess();
        }
        try {
            List arrayValue = (List)new Gson().fromJson(paramValue, new TypeToken<List<Map<String, String>>>(){}.getType());
            result.setSuccResult((Object)arrayValue);
        }
        catch (Throwable e) {
            result.setFailResult(new StringBuilder(512).append("Parameter ").append(fieldDef.name).append(" value parse failure, error is ").append(e.getMessage()).append("!").toString());
        }
        return result.isSuccess();
    }

    public static <T> boolean getDateParameter(T paramCntr, WebFieldDef fieldDef, boolean required, Date defValue, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(paramCntr, fieldDef, required, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String paramValue = (String)result.getRetData();
        if (paramValue == null) {
            result.setSuccResult((Object)defValue);
            return result.isSuccess();
        }
        Date date = DateTimeConvertUtils.yyyyMMddHHmmss2date((String)paramValue);
        if (date == null) {
            result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append("'s value ").append(paramValue).append(" parse error, required value format is ").append("yyyyMMddHHmmss").toString());
            sBuffer.delete(0, sBuffer.length());
        } else {
            result.setSuccResult((Object)date);
        }
        return result.isSuccess();
    }

    public static boolean validReqAuthorizeInfo(HttpServletRequest req, boolean required, TMaster master, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.ADMINAUTHTOKEN, required, null, sBuffer, result)) {
            return result.isSuccess();
        }
        String paramValue = (String)result.getRetData();
        if (paramValue != null && !paramValue.equals(master.getMasterConfig().getConfModAuthToken())) {
            result.setFailResult("illegal access, unauthorized request!");
        }
        return result.isSuccess();
    }

    private static boolean procStringDefValue(boolean isCompFieldType, String defValue, ProcessResult result) {
        if (isCompFieldType) {
            TreeSet<String> valItemSet = new TreeSet<String>();
            if (TStringUtils.isNotBlank((String)defValue)) {
                valItemSet.add(defValue);
            }
            valItemSet.comparator();
            result.setSuccResult(valItemSet);
        } else {
            result.setSuccResult((Object)defValue);
        }
        return result.isSuccess();
    }

    private static boolean checkStrValueNorms(WebFieldDef fieldDef, String paramVal, StringBuilder sBuffer, ProcessResult result) {
        if (TStringUtils.isBlank((String)(paramVal = paramVal.trim()))) {
            result.setSuccResult(null);
            return true;
        }
        if (fieldDef.valMaxLen != -2 && paramVal.length() > fieldDef.valMaxLen) {
            result.setFailResult(sBuffer.append("over max length for ").append(fieldDef.name).append(", only allow ").append(fieldDef.valMaxLen).append(" length").toString());
            sBuffer.delete(0, sBuffer.length());
            return false;
        }
        if (fieldDef.regexCheck && !paramVal.matches(fieldDef.regexDef.getPattern()) && (fieldDef != WebFieldDef.TOPICNAME && fieldDef != WebFieldDef.COMPSTOPICNAME || !paramVal.equals("__offset_history__"))) {
            result.setFailResult(sBuffer.append("illegal value for ").append(fieldDef.name).append(", value ").append(fieldDef.regexDef.getErrMsgTemp()).toString());
            sBuffer.delete(0, sBuffer.length());
            return false;
        }
        result.setSuccResult((Object)paramVal);
        return true;
    }

    private static boolean checkIntValueNorms(WebFieldDef fieldDef, String paramValue, boolean hasMinVal, int minValue, boolean hasMaxVal, int maxValue, StringBuilder sBuffer, ProcessResult result) {
        try {
            int paramIntVal = Integer.parseInt(paramValue);
            if (hasMinVal && paramIntVal < minValue) {
                result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append(" value must >= ").append(minValue).toString());
                sBuffer.delete(0, sBuffer.length());
                return false;
            }
            if (hasMaxVal && paramIntVal > maxValue) {
                result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append(" value must <= ").append(maxValue).toString());
                sBuffer.delete(0, sBuffer.length());
                return false;
            }
            result.setSuccResult((Object)paramIntVal);
        }
        catch (Throwable e) {
            result.setFailResult(sBuffer.append("Parameter ").append(fieldDef.name).append(" parse error: ").append(e.getMessage()).toString());
            sBuffer.delete(0, sBuffer.length());
            return false;
        }
        return true;
    }

    public static String checkAndGetFilterConds(String inFilterConds, boolean isTransBlank, StringBuilder sb) throws Exception {
        if (TStringUtils.isNotBlank((String)inFilterConds)) {
            inFilterConds = WebParameterUtils.escDoubleQuotes(inFilterConds.trim());
        }
        if (TStringUtils.isBlank((String)inFilterConds)) {
            if (isTransBlank) {
                sb.append(",,");
            }
        } else {
            sb.append(",");
            TreeSet<String> filterConds = new TreeSet<String>();
            String[] strFilterConds = inFilterConds.split(",");
            for (int i = 0; i < strFilterConds.length; ++i) {
                if (TStringUtils.isBlank((String)strFilterConds[i])) continue;
                String filterCond = strFilterConds[i].trim();
                if (filterCond.length() > 256) {
                    sb.delete(0, sb.length());
                    throw new Exception(sb.append("Illegal value: the max length of ").append(filterCond).append(" in filterConds parameter over ").append(256).append(" characters").toString());
                }
                if (!filterCond.matches("^[_A-Za-z0-9]+$")) {
                    sb.delete(0, sb.length());
                    throw new Exception(sb.append("Illegal value: the value of ").append(filterCond).append(" in filterCond parameter ").append("must only contain characters,numbers,and underscores").toString());
                }
                filterConds.add(filterCond);
            }
            int count = 0;
            for (String itemStr : filterConds) {
                if (count++ > 0) {
                    sb.append(",");
                }
                sb.append(itemStr);
            }
            sb.append(",");
        }
        String strNewFilterConds = sb.toString();
        sb.delete(0, sb.length());
        return strNewFilterConds;
    }

    public static Set<String> checkAndGetFilterCondSet(String inFilterConds, boolean transCondItem, boolean checkTotalCnt, StringBuilder sb) throws Exception {
        HashSet<String> filterCondSet = new HashSet<String>();
        if (TStringUtils.isBlank((String)inFilterConds)) {
            return filterCondSet;
        }
        if (TStringUtils.isNotBlank((String)(inFilterConds = WebParameterUtils.escDoubleQuotes(inFilterConds.trim())))) {
            String[] strFilterConds = inFilterConds.split(",");
            for (int i = 0; i < strFilterConds.length; ++i) {
                if (TStringUtils.isBlank((String)strFilterConds[i])) continue;
                String filterCond = strFilterConds[i].trim();
                if (filterCond.length() > 500) {
                    sb.delete(0, sb.length());
                    throw new Exception(sb.append("Illegal value: the max length of ").append(filterCond).append(" in filterConds parameter over ").append(500).append(" characters").toString());
                }
                if (!filterCond.matches("^[_A-Za-z0-9]+$")) {
                    sb.delete(0, sb.length());
                    throw new Exception(sb.append("Illegal value: the value of ").append(filterCond).append(" in filterCond parameter must ").append("only contain characters,numbers,and underscores").toString());
                }
                if (transCondItem) {
                    filterCondSet.add(sb.append(",").append(filterCond).append(",").toString());
                    sb.delete(0, sb.length());
                    continue;
                }
                filterCondSet.add(filterCond);
            }
            if (checkTotalCnt && filterCondSet.size() > 500) {
                throw new Exception(sb.append("Illegal value: the count of filterCond's ").append("value over max allowed count(").append(500).append(")!").toString());
            }
        }
        return filterCondSet;
    }

    public static Set<String> getBatchGroupNames(String inputGroupName, boolean checkEmpty, boolean checkResToken, Set<String> resTokens, StringBuilder sb) throws Exception {
        HashSet<String> batchOpGroupNames = new HashSet<String>();
        if (TStringUtils.isNotBlank((String)inputGroupName)) {
            inputGroupName = WebParameterUtils.escDoubleQuotes(inputGroupName.trim());
        }
        if (TStringUtils.isBlank((String)inputGroupName)) {
            if (checkEmpty) {
                throw new Exception("Illegal value: required groupName parameter");
            }
            return batchOpGroupNames;
        }
        String[] strGroupNames = inputGroupName.split(",");
        if (strGroupNames.length > 100) {
            throw new Exception(sb.append("Illegal value: groupName's batch count over max count ").append(100).toString());
        }
        for (int i = 0; i < strGroupNames.length; ++i) {
            if (TStringUtils.isBlank((String)strGroupNames[i])) continue;
            String groupName = strGroupNames[i].trim();
            if (checkResToken && resTokens != null && !resTokens.isEmpty() && resTokens.contains(groupName)) {
                throw new Exception(sb.append("Illegal value: in groupName parameter, '").append(groupName).append("' is a system reserved token!").toString());
            }
            if (groupName.length() > 1024) {
                throw new Exception(sb.append("Illegal value: the max length of ").append(groupName).append(" in groupName parameter over ").append(1024).append(" characters").toString());
            }
            if (!groupName.matches("^[a-zA-Z][\\w-]+$")) {
                throw new Exception(sb.append("Illegal value: the value of ").append(groupName).append("in groupName parameter must begin with a letter, can only contain ").append("characters,numbers,hyphen,and underscores").toString());
            }
            batchOpGroupNames.add(groupName);
        }
        if (batchOpGroupNames.isEmpty() && checkEmpty) {
            throw new Exception("Illegal value: Null value of groupName parameter");
        }
        return batchOpGroupNames;
    }

    public static Set<String> getBatchBrokerIpSet(String inStrBrokerIps, boolean checkEmpty) throws Exception {
        HashSet<String> batchBrokerIps = new HashSet<String>();
        if (TStringUtils.isNotBlank((String)inStrBrokerIps)) {
            inStrBrokerIps = WebParameterUtils.escDoubleQuotes(inStrBrokerIps.trim());
        }
        if (TStringUtils.isBlank((String)inStrBrokerIps)) {
            if (checkEmpty) {
                throw new Exception("Illegal value: required brokerIp parameter");
            }
            return batchBrokerIps;
        }
        String[] strBrokerIps = inStrBrokerIps.split(",");
        for (int i = 0; i < strBrokerIps.length; ++i) {
            String brokerIp;
            if (TStringUtils.isEmpty((String)strBrokerIps[i]) || batchBrokerIps.contains(brokerIp = WebParameterUtils.checkParamCommonRequires("brokerIp", strBrokerIps[i], true))) continue;
            batchBrokerIps.add(brokerIp);
        }
        if (batchBrokerIps.isEmpty() && checkEmpty) {
            throw new Exception("Illegal value: Null value of brokerIp parameter");
        }
        return batchBrokerIps;
    }

    public static List<Map<String, String>> checkAndGetJsonArray(String paramName, String paramValue, int paramMaxLen, boolean required) throws Exception {
        String tmpParamValue = WebParameterUtils.checkParamCommonRequires(paramName, paramValue, required);
        if (TStringUtils.isBlank((String)tmpParamValue) && !required) {
            return null;
        }
        String decTmpParamVal = null;
        try {
            decTmpParamVal = URLDecoder.decode(tmpParamValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception(new StringBuilder(512).append("Decode ").append(paramName).append("error, exception is ").append(e.toString()).toString());
        }
        if (TStringUtils.isBlank((String)decTmpParamVal)) {
            if (required) {
                throw new Exception(new StringBuilder(512).append("Blank value of ").append(paramName).append(" parameter").toString());
            }
            return null;
        }
        if (paramMaxLen != -2 && decTmpParamVal.length() > paramMaxLen) {
            throw new Exception(new StringBuilder(512).append("the max length of ").append(paramName).append(" parameter is ").append(paramMaxLen).append(" characters").toString());
        }
        return (List)new Gson().fromJson(decTmpParamVal, new TypeToken<List<Map<String, String>>>(){}.getType());
    }

    public static boolean checkBrokerInOnlineStatus(BdbBrokerConfEntity curEntity) {
        if (curEntity != null) {
            return curEntity.getManageStatus() == 5 || curEntity.getManageStatus() == 6 || curEntity.getManageStatus() == 7;
        }
        return false;
    }

    public static String getBrokerManageStatusStr(int manageStatus) {
        String strManageStatus = "unsupported_status";
        if (manageStatus == 1) {
            strManageStatus = "draft";
        } else if (manageStatus == 5) {
            strManageStatus = "online";
        } else if (manageStatus == 9) {
            strManageStatus = "offline";
        } else if (manageStatus == 6) {
            strManageStatus = "only-read";
        } else if (manageStatus == 7) {
            strManageStatus = "only-write";
        }
        return strManageStatus;
    }

    public static int getBrokerManageStatusId(String strManageStatus) {
        int manageStatus = -2;
        if (strManageStatus.equals("draft")) {
            manageStatus = 1;
        } else if (strManageStatus.equals("online")) {
            manageStatus = 5;
        } else if (strManageStatus.equals("offline")) {
            manageStatus = 9;
        } else if (strManageStatus.equals("only-read")) {
            manageStatus = 6;
        } else if (strManageStatus.equals("only-write")) {
            manageStatus = 7;
        }
        return manageStatus;
    }

    public static Tuple2<Boolean, Boolean> getPubSubStatusByManageStatus(int manageStatus) {
        boolean isAcceptPublish = false;
        boolean isAcceptSubscribe = false;
        if (manageStatus >= 5) {
            if (manageStatus == 5) {
                isAcceptPublish = true;
                isAcceptSubscribe = true;
            } else if (manageStatus == 6) {
                isAcceptPublish = false;
                isAcceptSubscribe = true;
            } else if (manageStatus == 7) {
                isAcceptPublish = true;
                isAcceptSubscribe = false;
            }
        }
        return new Tuple2((Object)isAcceptPublish, (Object)isAcceptSubscribe);
    }

    public static String checkParamCommonRequires(String paramName, String paramValue, boolean required) throws Exception {
        String temParamValue = null;
        if (paramValue == null) {
            if (required) {
                throw new Exception(new StringBuilder(512).append("Required ").append(paramName).append(" parameter").toString());
            }
        } else {
            temParamValue = WebParameterUtils.escDoubleQuotes(paramValue.trim());
            if (TStringUtils.isBlank((String)temParamValue) && required) {
                throw new Exception(new StringBuilder(512).append("Null or blank value of ").append(paramName).append(" parameter").toString());
            }
        }
        return temParamValue;
    }

    public static <T> int getAndCheckFlowRules(T paramCntr, String defValue, StringBuilder sBuffer, ProcessResult result) {
        String paramValue;
        if (paramCntr instanceof Map) {
            Map keyValueMap = (Map)paramCntr;
            paramValue = (String)keyValueMap.get(WebFieldDef.FLOWCTRLSET.name);
            if (paramValue == null) {
                paramValue = (String)keyValueMap.get(WebFieldDef.FLOWCTRLSET.shortName);
            }
        } else if (paramCntr instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)paramCntr;
            paramValue = req.getParameter(WebFieldDef.FLOWCTRLSET.name);
            if (paramValue == null) {
                paramValue = req.getParameter(WebFieldDef.FLOWCTRLSET.shortName);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter type!");
        }
        if (TStringUtils.isBlank((String)paramValue)) {
            result.setSuccResult((Object)defValue);
            return 0;
        }
        paramValue = paramValue.trim();
        return WebParameterUtils.validFlowRuleValue(paramValue, sBuffer, result);
    }

    private static String escDoubleQuotes(String inPutStr) {
        if (TStringUtils.isBlank((String)inPutStr) || inPutStr.length() < 2) {
            return inPutStr;
        }
        if (inPutStr.charAt(0) == '\"' && inPutStr.charAt(inPutStr.length() - 1) == '\"') {
            if (inPutStr.length() == 2) {
                return "";
            }
            return inPutStr.substring(1, inPutStr.length() - 1).trim();
        }
        return inPutStr;
    }

    private static int validFlowRuleValue(String paramValue, StringBuilder sBuffer, ProcessResult result) {
        Map flowCtrlItemMap;
        int ruleCnt = 0;
        paramValue = paramValue.trim();
        List<Integer> ruleTypes = Arrays.asList(0, 1, 2, 3);
        FlowCtrlRuleHandler flowCtrlRuleHandler = new FlowCtrlRuleHandler(true);
        try {
            flowCtrlItemMap = flowCtrlRuleHandler.parseFlowCtrlInfo(paramValue);
        }
        catch (Throwable e) {
            result.setFailResult(sBuffer.append("Parse parameter ").append(WebFieldDef.FLOWCTRLSET.name).append(" failure: '").append(e.toString()).toString());
            sBuffer.delete(0, sBuffer.length());
            return 0;
        }
        sBuffer.append("[");
        for (Integer typeId : ruleTypes) {
            if (typeId == null) continue;
            int rules = 0;
            List flowCtrlItems = (List)flowCtrlItemMap.get(typeId);
            if (flowCtrlItems == null) continue;
            if (ruleCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"type\":").append(typeId).append(",\"rule\":[");
            for (FlowCtrlItem flowCtrlItem : flowCtrlItems) {
                if (flowCtrlItem == null) continue;
                if (rules++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer = flowCtrlItem.toJsonString(sBuffer);
            }
            sBuffer.append("]}");
        }
        sBuffer.append("]");
        result.setSuccResult((Object)sBuffer.toString());
        sBuffer.delete(0, sBuffer.length());
        return ruleCnt;
    }
}

