/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master;

import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.config.TLSConfig;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fileconfig.AbstractFileConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.BdbMetaConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.PrometheusConfig;
import org.apache.inlong.tubemq.server.common.fileconfig.ZKMetaConfig;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterConfig
extends AbstractFileConfig {
    private static final Logger logger = LoggerFactory.getLogger(MasterConfig.class);
    private String hostName;
    private int port;
    private int webPort = 8080;
    private TLSConfig tlsConfig;
    private boolean useBdbStoreMetaData = false;
    private ZKMetaConfig zkMetaConfig = null;
    private BdbMetaConfig bdbMetaConfig = null;
    private PrometheusConfig promConfig = null;
    private int consumerBalancePeriodMs = 60000;
    private int firstBalanceDelayAfterStartMs = 30000;
    private int consumerHeartbeatTimeoutMs = 30000;
    private int producerHeartbeatTimeoutMs = 30000;
    private int brokerHeartbeatTimeoutMs = 30000;
    private long rpcReadTimeoutMs = 10000L;
    private long nettyWriteBufferHighWaterMark = 0xA00000L;
    private long nettyWriteBufferLowWaterMark = 0x500000L;
    private long onlineOnlyReadToRWPeriodMs = 120000L;
    private long offlineOnlyReadToRWPeriodMs = 30000L;
    private long stepChgWaitPeriodMs = 12000L;
    private String confModAuthToken = "ASDFGHJKL";
    private String webResourcePath = "../resources";
    private int maxGroupBrokerConsumeRate = 1000;
    private int maxGroupRebalanceWaitPeriod = 2;
    private int maxAutoForbiddenCnt = 5;
    private long socketSendBuffer = -1L;
    private long socketRecvBuffer = -1L;
    private boolean startOffsetResetCheck = false;
    private int rowLockWaitDurMs = 30000;
    private boolean startVisitTokenCheck = false;
    private boolean startProduceAuthenticate = false;
    private boolean startProduceAuthorize = false;
    private boolean startConsumeAuthenticate = false;
    private boolean startConsumeAuthorize = false;
    private long visitTokenValidPeriodMs = 300000L;
    private boolean needBrokerVisitAuth = false;
    private boolean useWebProxy = false;
    private String visitName = "";
    private String visitPassword = "";
    private long authValidTimeStampPeriodMs = 20000L;
    private int rebalanceParallel = 4;
    private long maxMetaForceUpdatePeriodMs = 180000L;

    public String getHostName() {
        return this.hostName;
    }

    public boolean isTlsEnable() {
        return this.tlsConfig.isTlsEnable();
    }

    public int getPort() {
        return this.port;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public long getOfflineOnlyReadToRWPeriodMs() {
        return this.offlineOnlyReadToRWPeriodMs;
    }

    public String getConfModAuthToken() {
        return this.confModAuthToken;
    }

    public long getOnlineOnlyReadToRWPeriodMs() {
        return this.onlineOnlyReadToRWPeriodMs;
    }

    public long getStepChgWaitPeriodMs() {
        return this.stepChgWaitPeriodMs;
    }

    public long getRpcReadTimeoutMs() {
        return this.rpcReadTimeoutMs;
    }

    public long getNettyWriteBufferHighWaterMark() {
        return this.nettyWriteBufferHighWaterMark;
    }

    public long getNettyWriteBufferLowWaterMark() {
        return this.nettyWriteBufferLowWaterMark;
    }

    public int getConsumerBalancePeriodMs() {
        return this.consumerBalancePeriodMs;
    }

    public int getFirstBalanceDelayAfterStartMs() {
        return this.firstBalanceDelayAfterStartMs;
    }

    public String getWebResourcePath() {
        return this.webResourcePath;
    }

    public String getMetaDataPath() {
        if (this.useBdbStoreMetaData) {
            return this.bdbMetaConfig.getMetaDataPath();
        }
        return null;
    }

    public void setWebResourcePath(String webResourcePath) {
        this.webResourcePath = webResourcePath;
    }

    public int getConsumerHeartbeatTimeoutMs() {
        return this.consumerHeartbeatTimeoutMs;
    }

    public int getProducerHeartbeatTimeoutMs() {
        return this.producerHeartbeatTimeoutMs;
    }

    public int getBrokerHeartbeatTimeoutMs() {
        return this.brokerHeartbeatTimeoutMs;
    }

    public int getMaxGroupBrokerConsumeRate() {
        return this.maxGroupBrokerConsumeRate;
    }

    public boolean isStartOffsetResetCheck() {
        return this.startOffsetResetCheck;
    }

    public int getMaxGroupRebalanceWaitPeriod() {
        return this.maxGroupRebalanceWaitPeriod;
    }

    public int getRowLockWaitDurMs() {
        return this.rowLockWaitDurMs;
    }

    public int getMaxAutoForbiddenCnt() {
        return this.maxAutoForbiddenCnt;
    }

    public BdbMetaConfig getBdbMetaConfig() {
        return this.bdbMetaConfig;
    }

    public TLSConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public ZKMetaConfig getZkMetaConfig() {
        return this.zkMetaConfig;
    }

    public PrometheusConfig getPromConfig() {
        return this.promConfig;
    }

    public boolean isStartVisitTokenCheck() {
        return this.startVisitTokenCheck;
    }

    public long getVisitTokenValidPeriodMs() {
        return this.visitTokenValidPeriodMs;
    }

    public boolean isStartProduceAuthenticate() {
        return this.startProduceAuthenticate;
    }

    public boolean isStartProduceAuthorize() {
        return this.startProduceAuthorize;
    }

    public boolean isNeedBrokerVisitAuth() {
        return this.needBrokerVisitAuth;
    }

    public boolean isStartConsumeAuthenticate() {
        return this.startConsumeAuthenticate;
    }

    public boolean isStartConsumeAuthorize() {
        return this.startConsumeAuthorize;
    }

    public boolean isUseWebProxy() {
        return this.useWebProxy;
    }

    public long getSocketSendBuffer() {
        return this.socketSendBuffer;
    }

    public long getSocketRecvBuffer() {
        return this.socketRecvBuffer;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public String getVisitPassword() {
        return this.visitPassword;
    }

    public long getAuthValidTimeStampPeriodMs() {
        return this.authValidTimeStampPeriodMs;
    }

    public int getRebalanceParallel() {
        return this.rebalanceParallel;
    }

    public long getMaxMetaForceUpdatePeriodMs() {
        return this.maxMetaForceUpdatePeriodMs;
    }

    public boolean isUseBdbStoreMetaData() {
        return this.useBdbStoreMetaData;
    }

    @Override
    protected void loadFileSectAttributes(Ini iniConf) {
        int promHttpPort;
        this.loadSystemConf(iniConf);
        this.loadMetaDataSectConf(iniConf);
        this.tlsConfig = this.loadTlsSectConf(iniConf, 8716);
        this.promConfig = this.loadPrometheusSecConf(iniConf);
        if (this.port == this.webPort || this.tlsConfig.isTlsEnable() && this.tlsConfig.getTlsPort() == this.webPort) {
            throw new IllegalArgumentException(new StringBuilder(512).append("Illegal field value configuration, the value of ").append("port or tlsPort cannot be the same as the value of webPort!").toString());
        }
        if (this.promConfig.isPromEnable() && ((promHttpPort = this.promConfig.getPromHttpPort()) == this.port || promHttpPort == this.webPort || this.tlsConfig.isTlsEnable() && this.tlsConfig.getTlsPort() == promHttpPort)) {
            throw new IllegalArgumentException(new StringBuilder(512).append("Illegal port value configuration, the value of ").append("port or webPort or tlsPort cannot be the same as the value of promHttpPort!").toString());
        }
        if (this.useBdbStoreMetaData) {
            if (this.port == this.bdbMetaConfig.getRepNodePort() || this.tlsConfig.isTlsEnable() && this.tlsConfig.getTlsPort() == this.bdbMetaConfig.getRepNodePort()) {
                throw new IllegalArgumentException(new StringBuilder(512).append("Illegal field value configuration, the value of ").append("port or tlsPort cannot be the same as the value of repNodePort!").toString());
            }
            if (this.webPort == this.bdbMetaConfig.getRepNodePort()) {
                throw new IllegalArgumentException(new StringBuilder(512).append("Illegal field value configuration, the value of ").append("webPort cannot be the same as the value of repNodePort!").toString());
            }
            if (this.promConfig.isPromEnable() && this.promConfig.getPromHttpPort() == this.bdbMetaConfig.getRepNodePort()) {
                throw new IllegalArgumentException(new StringBuilder(512).append("Illegal field value configuration, the value of ").append("promHttpPort cannot be the same as the value of repNodePort!").toString());
            }
        }
    }

    private void loadSystemConf(Ini iniConf) {
        Profile.Section masterConf = (Profile.Section)iniConf.get((Object)"master");
        if (masterConf == null) {
            throw new IllegalArgumentException(new StringBuilder(256).append("master").append(" configure section is required!").toString());
        }
        Set configKeySet = masterConf.keySet();
        if (configKeySet.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Empty configure item in ").append("master").append(" section!").toString());
        }
        this.port = this.getInt(masterConf, "port", 8715);
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"hostName")))) {
            this.hostName = ((String)masterConf.get((Object)"hostName")).trim();
        } else {
            try {
                this.hostName = AddressUtils.getIPV4LocalAddress();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(new StringBuilder(256).append("Get default master hostName failure : ").append(e.getMessage()).toString());
            }
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"webPort")))) {
            this.webPort = this.getInt(masterConf, "webPort");
        }
        if (TStringUtils.isBlank((String)((String)masterConf.get((Object)"webResourcePath")))) {
            throw new IllegalArgumentException(new StringBuilder(256).append("webResourcePath is null or Blank in ").append("master").append(" section!").toString());
        }
        this.webResourcePath = ((String)masterConf.get((Object)"webResourcePath")).trim();
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"consumerBalancePeriodMs")))) {
            this.consumerBalancePeriodMs = this.getInt(masterConf, "consumerBalancePeriodMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"firstBalanceDelayAfterStartMs")))) {
            this.firstBalanceDelayAfterStartMs = this.getInt(masterConf, "firstBalanceDelayAfterStartMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"consumerHeartbeatTimeoutMs")))) {
            this.consumerHeartbeatTimeoutMs = this.getInt(masterConf, "consumerHeartbeatTimeoutMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"producerHeartbeatTimeoutMs")))) {
            this.producerHeartbeatTimeoutMs = this.getInt(masterConf, "producerHeartbeatTimeoutMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"brokerHeartbeatTimeoutMs")))) {
            this.brokerHeartbeatTimeoutMs = this.getInt(masterConf, "brokerHeartbeatTimeoutMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"socketSendBuffer")))) {
            this.socketSendBuffer = this.getLong(masterConf, "socketSendBuffer");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"socketRecvBuffer")))) {
            this.socketRecvBuffer = this.getLong(masterConf, "socketRecvBuffer");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"rpcReadTimeoutMs")))) {
            this.rpcReadTimeoutMs = this.getLong(masterConf, "rpcReadTimeoutMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"nettyWriteBufferHighWaterMark")))) {
            this.nettyWriteBufferHighWaterMark = this.getLong(masterConf, "nettyWriteBufferHighWaterMark");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"nettyWriteBufferLowWaterMark")))) {
            this.nettyWriteBufferLowWaterMark = this.getLong(masterConf, "nettyWriteBufferLowWaterMark");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"onlineOnlyReadToRWPeriodMs")))) {
            this.onlineOnlyReadToRWPeriodMs = this.getLong(masterConf, "onlineOnlyReadToRWPeriodMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"stepChgWaitPeriodMs")))) {
            this.stepChgWaitPeriodMs = this.getLong(masterConf, "stepChgWaitPeriodMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"offlineOnlyReadToRWPeriodMs")))) {
            this.offlineOnlyReadToRWPeriodMs = this.getLong(masterConf, "offlineOnlyReadToRWPeriodMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"confModAuthToken")))) {
            String tmpAuthToken = ((String)masterConf.get((Object)"confModAuthToken")).trim();
            if (tmpAuthToken.length() > 128) {
                throw new IllegalArgumentException("Invalid value: the length of confModAuthToken's value > 128");
            }
            this.confModAuthToken = tmpAuthToken;
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"maxGroupBrokerConsumeRate")))) {
            this.maxGroupBrokerConsumeRate = this.getInt(masterConf, "maxGroupBrokerConsumeRate");
            if (this.maxGroupBrokerConsumeRate <= 0) {
                throw new IllegalArgumentException("Invalid value: maxGroupBrokerConsumeRate's value must > 0 !");
            }
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"maxGroupRebalanceWaitPeriod")))) {
            this.maxGroupRebalanceWaitPeriod = this.getInt(masterConf, "maxGroupRebalanceWaitPeriod");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"startOffsetResetCheck")))) {
            this.startOffsetResetCheck = this.getBoolean(masterConf, "startOffsetResetCheck");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"rowLockWaitDurMs")))) {
            this.rowLockWaitDurMs = this.getInt(masterConf, "rowLockWaitDurMs");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"maxAutoForbiddenCnt")))) {
            this.maxAutoForbiddenCnt = this.getInt(masterConf, "maxAutoForbiddenCnt");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"visitTokenValidPeriodMs")))) {
            long tmpPeriodMs = this.getLong(masterConf, "visitTokenValidPeriodMs");
            if (tmpPeriodMs < 180000L) {
                tmpPeriodMs = 180000L;
            }
            this.visitTokenValidPeriodMs = tmpPeriodMs;
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"authValidTimeStampPeriodMs")))) {
            long tmpPeriodMs = this.getLong(masterConf, "authValidTimeStampPeriodMs");
            long l = tmpPeriodMs < 5000L ? 5000L : (this.authValidTimeStampPeriodMs = tmpPeriodMs > 120000L ? 120000L : tmpPeriodMs);
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"startVisitTokenCheck")))) {
            this.startVisitTokenCheck = this.getBoolean(masterConf, "startVisitTokenCheck");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"startProduceAuthenticate")))) {
            this.startProduceAuthenticate = this.getBoolean(masterConf, "startProduceAuthenticate");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"startProduceAuthorize")))) {
            this.startProduceAuthorize = this.getBoolean(masterConf, "startProduceAuthorize");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"useWebProxy")))) {
            this.useWebProxy = this.getBoolean(masterConf, "useWebProxy");
        }
        if (!this.startProduceAuthenticate && this.startProduceAuthorize) {
            throw new IllegalArgumentException("startProduceAuthenticate must set true if startProduceAuthorize is true!");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"startConsumeAuthenticate")))) {
            this.startConsumeAuthenticate = this.getBoolean(masterConf, "startConsumeAuthenticate");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"startConsumeAuthorize")))) {
            this.startConsumeAuthorize = this.getBoolean(masterConf, "startConsumeAuthorize");
        }
        if (!this.startConsumeAuthenticate && this.startConsumeAuthorize) {
            throw new IllegalArgumentException("startConsumeAuthenticate must set true if startConsumeAuthorize is true!");
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"needBrokerVisitAuth")))) {
            this.needBrokerVisitAuth = this.getBoolean(masterConf, "needBrokerVisitAuth");
        }
        if (this.needBrokerVisitAuth) {
            if (TStringUtils.isBlank((String)((String)masterConf.get((Object)"visitName")))) {
                throw new IllegalArgumentException(new StringBuilder(256).append("visitName is null or Blank in ").append("master").append(" section!").toString());
            }
            if (TStringUtils.isBlank((String)((String)masterConf.get((Object)"visitPassword")))) {
                throw new IllegalArgumentException(new StringBuilder(256).append("visitPassword is null or Blank in ").append("master").append(" section!").toString());
            }
            this.visitName = ((String)masterConf.get((Object)"visitName")).trim();
            this.visitPassword = ((String)masterConf.get((Object)"visitPassword")).trim();
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"rebalanceParallel")))) {
            int tmpParallel = this.getInt(masterConf, "rebalanceParallel");
            this.rebalanceParallel = MixedUtils.mid((int)tmpParallel, (int)1, (int)20);
        }
        if (TStringUtils.isNotBlank((String)((String)masterConf.get((Object)"maxMetaForceUpdatePeriodMs")))) {
            long tmpPeriodMs = this.getLong(masterConf, "maxMetaForceUpdatePeriodMs");
            if (tmpPeriodMs < 60000L) {
                tmpPeriodMs = 60000L;
            }
            this.maxMetaForceUpdatePeriodMs = tmpPeriodMs;
        }
    }

    private void loadMetaDataSectConf(Ini iniConf) {
        if (iniConf.get((Object)"meta_bdb") != null && iniConf.get((Object)"meta_zookeeper") != null) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Cannot configure both ").append("meta_bdb").append(" and ").append("meta_zookeeper").append(" meta-data sections in the same time").append(", please confirm them and retain one first!").toString());
        }
        Profile.Section metaSect = (Profile.Section)iniConf.get((Object)"meta_zookeeper");
        if (metaSect != null) {
            this.useBdbStoreMetaData = false;
            this.zkMetaConfig = this.loadZkMetaSectConf(iniConf);
            return;
        }
        metaSect = (Profile.Section)iniConf.get((Object)"meta_bdb");
        if (metaSect != null) {
            this.useBdbStoreMetaData = true;
            this.bdbMetaConfig = this.loadBdbMetaSectConf(iniConf);
            return;
        }
        metaSect = (Profile.Section)iniConf.get((Object)"replication");
        if (metaSect != null) {
            this.useBdbStoreMetaData = true;
            this.bdbMetaConfig = this.loadReplicationSectConf(iniConf);
            return;
        }
        metaSect = (Profile.Section)iniConf.get((Object)"bdbStore");
        if (metaSect != null) {
            this.useBdbStoreMetaData = true;
            this.bdbMetaConfig = this.loadBdbStoreSectConf(iniConf);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(256).append("Missing necessary meta-data section, please select ").append("meta_zookeeper").append(" or ").append("meta_bdb").append(" and configure ini again!").toString());
    }

    private ZKMetaConfig loadZkMetaSectConf(Ini iniConf) {
        Profile.Section zkeeperSect = (Profile.Section)iniConf.get((Object)"meta_zookeeper");
        if (zkeeperSect == null) {
            throw new IllegalArgumentException(new StringBuilder(256).append("meta_zookeeper").append(" configure section is required!").toString());
        }
        Set configKeySet = zkeeperSect.keySet();
        if (configKeySet.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Empty configure item in ").append("meta_zookeeper").append(" section!").toString());
        }
        ZKMetaConfig zkMetaConfig = new ZKMetaConfig();
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkServerAddr")))) {
            zkMetaConfig.setZkServerAddr(((String)zkeeperSect.get((Object)"zkServerAddr")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkNodeRoot")))) {
            zkMetaConfig.setZkNodeRoot(((String)zkeeperSect.get((Object)"zkNodeRoot")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkSessionTimeoutMs")))) {
            zkMetaConfig.setZkSessionTimeoutMs(this.getInt(zkeeperSect, "zkSessionTimeoutMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkConnectionTimeoutMs")))) {
            zkMetaConfig.setZkConnectionTimeoutMs(this.getInt(zkeeperSect, "zkConnectionTimeoutMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkSyncTimeMs")))) {
            zkMetaConfig.setZkSyncTimeMs(this.getInt(zkeeperSect, "zkSyncTimeMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkCommitPeriodMs")))) {
            zkMetaConfig.setZkCommitPeriodMs(this.getLong(zkeeperSect, "zkCommitPeriodMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkCommitFailRetries")))) {
            zkMetaConfig.setZkCommitFailRetries(this.getInt(zkeeperSect, "zkCommitFailRetries"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkMasterCheckPeriodMs")))) {
            zkMetaConfig.setZkMasterCheckPeriodMs(this.getInt(zkeeperSect, "zkMasterCheckPeriodMs"));
        }
        if (TStringUtils.isNotBlank((String)((String)zkeeperSect.get((Object)"zkRequestTimeoutMs")))) {
            zkMetaConfig.setZkRequestTimeoutMs(this.getInt(zkeeperSect, "zkRequestTimeoutMs"));
        }
        return zkMetaConfig;
    }

    private BdbMetaConfig loadBdbMetaSectConf(Ini iniConf) {
        Profile.Section repSect = (Profile.Section)iniConf.get((Object)"meta_bdb");
        if (repSect == null) {
            return null;
        }
        Set configKeySet = repSect.keySet();
        if (configKeySet.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Empty configure item in ").append("meta_bdb").append(" section!").toString());
        }
        BdbMetaConfig tmpMetaConfig = new BdbMetaConfig();
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repGroupName")))) {
            tmpMetaConfig.setRepGroupName(((String)repSect.get((Object)"repGroupName")).trim());
        }
        if (TStringUtils.isBlank((String)((String)repSect.get((Object)"repNodeName")))) {
            this.getSimilarConfigField("meta_bdb", configKeySet, "repNodeName");
        } else {
            tmpMetaConfig.setRepNodeName(((String)repSect.get((Object)"repNodeName")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repNodePort")))) {
            tmpMetaConfig.setRepNodePort(this.getInt(repSect, "repNodePort"));
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"metaDataPath")))) {
            tmpMetaConfig.setMetaDataPath(((String)repSect.get((Object)"metaDataPath")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repHelperHost")))) {
            tmpMetaConfig.setRepHelperHost(((String)repSect.get((Object)"repHelperHost")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"metaLocalSyncPolicy")))) {
            tmpMetaConfig.setMetaLocalSyncPolicy(this.getInt(repSect, "metaLocalSyncPolicy"));
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"metaReplicaSyncPolicy")))) {
            tmpMetaConfig.setMetaReplicaSyncPolicy(this.getInt(repSect, "metaReplicaSyncPolicy"));
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repReplicaAckPolicy")))) {
            tmpMetaConfig.setRepReplicaAckPolicy(this.getInt(repSect, "repReplicaAckPolicy"));
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repStatusCheckTimeoutMs")))) {
            tmpMetaConfig.setRepStatusCheckTimeoutMs(this.getLong(repSect, "repStatusCheckTimeoutMs"));
        }
        return tmpMetaConfig;
    }

    private BdbMetaConfig loadBdbStoreSectConf(Ini iniConf) {
        Profile.Section bdbSect = (Profile.Section)iniConf.get((Object)"bdbStore");
        if (bdbSect == null) {
            return null;
        }
        Set configKeySet = bdbSect.keySet();
        if (configKeySet.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Empty configure item in ").append("bdbStore").append(" section!").toString());
        }
        logger.warn("[bdbStore] section is deprecated. Please config in [meta_bdb] section.");
        BdbMetaConfig tmpMetaConfig = new BdbMetaConfig();
        if (TStringUtils.isBlank((String)((String)bdbSect.get((Object)"bdbRepGroupName")))) {
            this.getSimilarConfigField("bdbStore", configKeySet, "bdbRepGroupName");
        } else {
            tmpMetaConfig.setRepGroupName(((String)bdbSect.get((Object)"bdbRepGroupName")).trim());
        }
        if (TStringUtils.isBlank((String)((String)bdbSect.get((Object)"bdbNodeName")))) {
            this.getSimilarConfigField("bdbStore", configKeySet, "bdbNodeName");
        } else {
            tmpMetaConfig.setRepNodeName(((String)bdbSect.get((Object)"bdbNodeName")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)bdbSect.get((Object)"bdbNodePort")))) {
            tmpMetaConfig.setRepNodePort(this.getInt(bdbSect, "bdbNodePort"));
        }
        if (TStringUtils.isBlank((String)((String)bdbSect.get((Object)"bdbEnvHome")))) {
            this.getSimilarConfigField("bdbStore", configKeySet, "bdbEnvHome");
        } else {
            tmpMetaConfig.setMetaDataPath(((String)bdbSect.get((Object)"bdbEnvHome")).trim());
        }
        if (TStringUtils.isBlank((String)((String)bdbSect.get((Object)"bdbHelperHost")))) {
            this.getSimilarConfigField("bdbStore", configKeySet, "bdbHelperHost");
        } else {
            tmpMetaConfig.setRepHelperHost(((String)bdbSect.get((Object)"bdbHelperHost")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)bdbSect.get((Object)"bdbLocalSync")))) {
            tmpMetaConfig.setMetaLocalSyncPolicy(this.getInt(bdbSect, "bdbLocalSync"));
        }
        if (TStringUtils.isNotBlank((String)((String)bdbSect.get((Object)"bdbReplicaSync")))) {
            tmpMetaConfig.setMetaReplicaSyncPolicy(this.getInt(bdbSect, "bdbReplicaSync"));
        }
        if (TStringUtils.isNotBlank((String)((String)bdbSect.get((Object)"bdbReplicaAck")))) {
            tmpMetaConfig.setRepReplicaAckPolicy(this.getInt(bdbSect, "bdbReplicaAck"));
        }
        if (TStringUtils.isNotBlank((String)((String)bdbSect.get((Object)"bdbStatusCheckTimeoutMs")))) {
            tmpMetaConfig.setRepStatusCheckTimeoutMs(this.getLong(bdbSect, "bdbStatusCheckTimeoutMs"));
        }
        return tmpMetaConfig;
    }

    private BdbMetaConfig loadReplicationSectConf(Ini iniConf) {
        Profile.Section masterConf;
        Profile.Section repSect = (Profile.Section)iniConf.get((Object)"replication");
        if (repSect == null) {
            return null;
        }
        Set configKeySet = repSect.keySet();
        if (configKeySet.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(256).append("Empty configure item in ").append("replication").append(" section!").toString());
        }
        BdbMetaConfig tmpMetaConfig = new BdbMetaConfig();
        logger.warn("[replication] section is deprecated. Please config in [meta_bdb] section.");
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repGroupName")))) {
            tmpMetaConfig.setRepGroupName(((String)repSect.get((Object)"repGroupName")).trim());
        }
        if (TStringUtils.isBlank((String)((String)repSect.get((Object)"repNodeName")))) {
            this.getSimilarConfigField("replication", configKeySet, "repNodeName");
        } else {
            tmpMetaConfig.setRepNodeName(((String)repSect.get((Object)"repNodeName")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repNodePort")))) {
            tmpMetaConfig.setRepNodePort(this.getInt(repSect, "repNodePort"));
        }
        if (TStringUtils.isNotBlank((String)((String)(masterConf = (Profile.Section)iniConf.get((Object)"master")).get((Object)"metaDataPath")))) {
            tmpMetaConfig.setMetaDataPath(((String)masterConf.get((Object)"metaDataPath")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repHelperHost")))) {
            tmpMetaConfig.setRepHelperHost(((String)repSect.get((Object)"repHelperHost")).trim());
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"metaLocalSyncPolicy")))) {
            tmpMetaConfig.setMetaLocalSyncPolicy(this.getInt(repSect, "metaLocalSyncPolicy"));
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"metaReplicaSyncPolicy")))) {
            tmpMetaConfig.setMetaReplicaSyncPolicy(this.getInt(repSect, "metaReplicaSyncPolicy"));
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repReplicaAckPolicy")))) {
            tmpMetaConfig.setRepReplicaAckPolicy(this.getInt(repSect, "repReplicaAckPolicy"));
        }
        if (TStringUtils.isNotBlank((String)((String)repSect.get((Object)"repStatusCheckTimeoutMs")))) {
            tmpMetaConfig.setRepStatusCheckTimeoutMs(this.getLong(repSect, "repStatusCheckTimeoutMs"));
        }
        return tmpMetaConfig;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("hostName", (Object)this.hostName).append("port", this.port).append("webPort", this.webPort).append("tlsConfig", (Object)this.tlsConfig).append("promConfig", (Object)this.promConfig).append("useBdbStoreMetaData", this.useBdbStoreMetaData).append("zkMetaConfig", (Object)this.zkMetaConfig).append("bdbMetaConfig", (Object)this.bdbMetaConfig).append("consumerBalancePeriodMs", this.consumerBalancePeriodMs).append("firstBalanceDelayAfterStartMs", this.firstBalanceDelayAfterStartMs).append("consumerHeartbeatTimeoutMs", this.consumerHeartbeatTimeoutMs).append("producerHeartbeatTimeoutMs", this.producerHeartbeatTimeoutMs).append("brokerHeartbeatTimeoutMs", this.brokerHeartbeatTimeoutMs).append("rpcReadTimeoutMs", this.rpcReadTimeoutMs).append("nettyWriteBufferHighWaterMark", this.nettyWriteBufferHighWaterMark).append("nettyWriteBufferLowWaterMark", this.nettyWriteBufferLowWaterMark).append("onlineOnlyReadToRWPeriodMs", this.onlineOnlyReadToRWPeriodMs).append("offlineOnlyReadToRWPeriodMs", this.offlineOnlyReadToRWPeriodMs).append("stepChgWaitPeriodMs", this.stepChgWaitPeriodMs).append("confModAuthToken", (Object)this.confModAuthToken).append("webResourcePath", (Object)this.webResourcePath).append("maxGroupBrokerConsumeRate", this.maxGroupBrokerConsumeRate).append("maxGroupRebalanceWaitPeriod", this.maxGroupRebalanceWaitPeriod).append("maxAutoForbiddenCnt", this.maxAutoForbiddenCnt).append("socketSendBuffer", this.socketSendBuffer).append("socketRecvBuffer", this.socketRecvBuffer).append("startOffsetResetCheck", this.startOffsetResetCheck).append("rowLockWaitDurMs", this.rowLockWaitDurMs).append("startVisitTokenCheck", this.startVisitTokenCheck).append("startProduceAuthenticate", this.startProduceAuthenticate).append("startProduceAuthorize", this.startProduceAuthorize).append("startConsumeAuthenticate", this.startConsumeAuthenticate).append("startConsumeAuthorize", this.startConsumeAuthorize).append("visitTokenValidPeriodMs", this.visitTokenValidPeriodMs).append("needBrokerVisitAuth", this.needBrokerVisitAuth).append("useWebProxy", this.useWebProxy).append("visitName", (Object)this.visitName).append("visitPassword", (Object)this.visitPassword).append("authValidTimeStampPeriodMs", this.authValidTimeStampPeriodMs).append("rebalanceParallel", this.rebalanceParallel).append("maxMetaForceUpdatePeriodMs", this.maxMetaForceUpdatePeriodMs).toString();
    }
}

