/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.balance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.server.master.balance.LoadBalancer;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupResCtrlEntity;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeGroupInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumerInfoHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.NodeRebInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.RebProcessInfo;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLoadBalancer
implements LoadBalancer {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancer.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    @Override
    public Map<String, Map<String, List<Partition>>> balanceCluster(Map<String, Map<String, Map<String, Partition>>> clusterState, ConsumerInfoHolder consumerHolder, BrokerRunManager brokerRunManager, List<String> groupSet, MetaDataService defMetaDataService, StringBuilder strBuffer) {
        HashMap<String, Map<String, List<Partition>>> finalSubInfoMap = new HashMap<String, Map<String, List<Partition>>>();
        HashMap<String, RebProcessInfo> rejGroupClientInfoMap = new HashMap<String, RebProcessInfo>();
        HashSet<String> onlineOfflineGroupSet = new HashSet<String>();
        HashSet<String> boundGroupSet = new HashSet<String>();
        for (String group : groupSet) {
            List<ConsumerInfo> consumerList;
            ConsumeGroupInfo consumeGroupInfo;
            if (group == null || (consumeGroupInfo = consumerHolder.getConsumeGroupInfo(group)) == null || consumeGroupInfo.isClientBalance() || CollectionUtils.isEmpty(consumerList = consumeGroupInfo.getConsumerInfoList())) continue;
            if (consumeGroupInfo.isUnReadyServerBalance()) {
                boundGroupSet.add(group);
                continue;
            }
            ArrayList<ConsumerInfo> newConsumerList = new ArrayList<ConsumerInfo>();
            for (ConsumerInfo consumerInfo : consumerList) {
                if (consumerInfo == null) continue;
                newConsumerList.add(consumerInfo);
            }
            if (CollectionUtils.isEmpty(newConsumerList)) continue;
            Set<String> topicSet = consumeGroupInfo.getTopicSet();
            if (consumeGroupInfo.needResourceCheck()) {
                GroupResCtrlEntity offsetResetGroupEntity = defMetaDataService.getGroupCtrlConf(group);
                int confAllowBClientRate = offsetResetGroupEntity != null && offsetResetGroupEntity.getAllowedBrokerClientRate() > 0 ? offsetResetGroupEntity.getAllowedBrokerClientRate() : -2;
                int allowRate = confAllowBClientRate > 0 ? confAllowBClientRate : consumerHolder.getDefResourceRate();
                int maxBrokerCount = brokerRunManager.getSubTopicMaxBrokerCount(topicSet);
                int curBClientRate = (int)Math.floor(maxBrokerCount / newConsumerList.size());
                if (curBClientRate > allowRate) {
                    int minClientCnt = maxBrokerCount / allowRate;
                    if (maxBrokerCount % allowRate != 0) {
                        ++minClientCnt;
                    }
                    consumeGroupInfo.setConsumeResourceInfo(confAllowBClientRate, curBClientRate, minClientCnt, false);
                    if (!consumeGroupInfo.isEnableBalanceChkPrint()) continue;
                    logger.info(strBuffer.append("[UnBound Alloc 2] Not allocate partition :group(").append(group).append(")'s consumer getCachedSize(").append(consumeGroupInfo.getGroupCnt()).append(") low than min required client count:").append(minClientCnt).toString());
                    strBuffer.delete(0, strBuffer.length());
                    continue;
                }
                consumeGroupInfo.setConsumeResourceInfo(confAllowBClientRate, curBClientRate, -2, true);
            }
            RebProcessInfo rebProcessInfo = new RebProcessInfo();
            if (!consumeGroupInfo.isBalanceMapEmpty() && !(rebProcessInfo = consumerHolder.getNeedRebNodeList(group)).isProcessInfoEmpty()) {
                rejGroupClientInfoMap.put(group, rebProcessInfo);
            }
            ArrayList<ConsumerInfo> newConsumerList2 = new ArrayList<ConsumerInfo>();
            Map<String, Partition> partMap = brokerRunManager.getSubBrokerAcceptSubParts(topicSet);
            Map<String, NodeRebInfo> rebProcessInfoMap = consumeGroupInfo.getBalanceMap();
            for (ConsumerInfo consumer : newConsumerList) {
                HashMap partitions = new HashMap();
                finalSubInfoMap.put(consumer.getConsumerId(), partitions);
                Map<String, Map<String, Partition>> relation = clusterState.get(consumer.getConsumerId());
                if (relation == null) continue;
                if (rebProcessInfo.needProcessList.contains(consumer.getConsumerId()) || rebProcessInfo.needEscapeList.contains(consumer.getConsumerId())) {
                    NodeRebInfo tmpNodeRegInfo = rebProcessInfoMap.get(consumer.getConsumerId());
                    if (tmpNodeRegInfo != null && tmpNodeRegInfo.getReqType() == 0) {
                        newConsumerList2.add(consumer);
                    }
                    for (Map.Entry<String, Map<String, Partition>> entry : relation.entrySet()) {
                        partitions.put(entry.getKey(), new ArrayList());
                    }
                    continue;
                }
                newConsumerList2.add(consumer);
                for (Map.Entry<String, Map<String, Partition>> entry : relation.entrySet()) {
                    ArrayList<Partition> ps = new ArrayList<Partition>();
                    partitions.put(entry.getKey(), ps);
                    Map<String, Partition> partitionMap = entry.getValue();
                    if (partitionMap == null || partitionMap.isEmpty()) continue;
                    for (Partition partition : partitionMap.values()) {
                        Partition curPart = partMap.remove(partition.getPartitionKey());
                        if (curPart == null) continue;
                        ps.add(curPart);
                    }
                }
            }
            if (partMap.isEmpty()) continue;
            onlineOfflineGroupSet.add(group);
            if (newConsumerList2.isEmpty()) continue;
            this.randomAssign(partMap, newConsumerList2, finalSubInfoMap, clusterState, rebProcessInfo.needProcessList);
        }
        ArrayList<String> groupsNeedToBalance = new ArrayList<String>();
        if (onlineOfflineGroupSet.isEmpty()) {
            for (String string : groupSet) {
                if (string == null) continue;
                groupsNeedToBalance.add(string);
            }
        } else {
            for (String string : groupSet) {
                if (string == null || onlineOfflineGroupSet.contains(string)) continue;
                groupsNeedToBalance.add(string);
            }
        }
        if (!boundGroupSet.isEmpty()) {
            for (String string : boundGroupSet) {
                groupsNeedToBalance.remove(string);
            }
        }
        if (!groupsNeedToBalance.isEmpty()) {
            this.balance(finalSubInfoMap, consumerHolder, brokerRunManager, groupsNeedToBalance, clusterState, rejGroupClientInfoMap);
        }
        if (!rejGroupClientInfoMap.isEmpty()) {
            for (Map.Entry entry : rejGroupClientInfoMap.entrySet()) {
                consumerHolder.setRebNodeProcessed((String)entry.getKey(), ((RebProcessInfo)entry.getValue()).needProcessList);
            }
        }
        return finalSubInfoMap;
    }

    private void balance(Map<String, Map<String, List<Partition>>> clusterState, ConsumerInfoHolder consumerHolder, BrokerRunManager brokerRunManager, List<String> groupSet, Map<String, Map<String, Map<String, Partition>>> oldClusterState, Map<String, RebProcessInfo> rejGroupClientInfoMap) {
        block0: for (String group : groupSet) {
            ConsumeGroupInfo consumeGroupInfo = consumerHolder.getConsumeGroupInfo(group);
            if (consumeGroupInfo == null || consumeGroupInfo.isClientBalance()) continue;
            List<Object> consumerList = new ArrayList();
            List<ConsumerInfo> consumerList1 = consumeGroupInfo.getConsumerInfoList();
            RebProcessInfo rebProcessInfo = rejGroupClientInfoMap.get(group);
            if (rebProcessInfo != null) {
                for (ConsumerInfo consumerInfo : consumerList1) {
                    if (consumerInfo == null) continue;
                    if (rebProcessInfo.needProcessList.contains(consumerInfo.getConsumerId()) || rebProcessInfo.needEscapeList.contains(consumerInfo.getConsumerId())) {
                        Map partitions2 = clusterState.computeIfAbsent(consumerInfo.getConsumerId(), k -> new HashMap());
                        Map<String, Map<String, Partition>> relation = oldClusterState.get(consumerInfo.getConsumerId());
                        if (relation == null) continue;
                        for (String topic : relation.keySet()) {
                            partitions2.put(topic, new ArrayList());
                        }
                        continue;
                    }
                    consumerList.add(consumerInfo);
                }
            } else {
                consumerList = consumerList1;
            }
            if (CollectionUtils.isEmpty(consumerList)) continue;
            Set<String> topics = consumeGroupInfo.getTopicSet();
            Map<String, Partition> psPartMap = brokerRunManager.getSubBrokerAcceptSubParts(topics);
            int min = psPartMap.size() / consumerList.size();
            int max = psPartMap.size() % consumerList.size() == 0 ? min : min + 1;
            int serverNumToLoadMax = psPartMap.size() % consumerList.size();
            LinkedBlockingQueue<Partition> partitionToMove = new LinkedBlockingQueue<Partition>();
            HashMap<String, Integer> serverToTake = new HashMap<String, Integer>();
            block3: for (ConsumerInfo consumerInfo : consumerList) {
                int numToOffload;
                Map<String, List<Partition>> partitions = clusterState.get(consumerInfo.getConsumerId());
                if (partitions == null) {
                    partitions = new HashMap<String, List<Partition>>();
                }
                int load = 0;
                for (List<Partition> entry : partitions.values()) {
                    load += entry.size();
                }
                if (load < max) {
                    if (load == 0) {
                        serverToTake.put(consumerInfo.getConsumerId(), max - load);
                        continue;
                    }
                    if (load >= min) continue;
                    serverToTake.put(consumerInfo.getConsumerId(), max - load);
                    continue;
                }
                if (serverNumToLoadMax > 0) {
                    --serverNumToLoadMax;
                    numToOffload = load - max;
                } else {
                    numToOffload = load - min;
                }
                for (List<Partition> entry : partitions.values()) {
                    if (entry.size() > numToOffload) {
                        int condition = numToOffload;
                        for (int i = 0; i < condition; ++i) {
                            partitionToMove.add(entry.remove(0));
                            --numToOffload;
                        }
                        if (numToOffload > 0) continue;
                        continue block3;
                    }
                    partitionToMove.addAll(entry);
                    entry.clear();
                    if ((numToOffload -= entry.size()) > 0) continue;
                    continue block3;
                }
            }
            for (Map.Entry entry : serverToTake.entrySet()) {
                for (int i = 0; i < (Integer)entry.getValue() && partitionToMove.size() > 0; ++i) {
                    Partition partition = (Partition)partitionToMove.poll();
                    this.assign(partition, clusterState, (String)entry.getKey());
                }
            }
            if (partitionToMove.isEmpty()) continue;
            for (String string : serverToTake.keySet()) {
                if (partitionToMove.isEmpty()) continue block0;
                this.assign((Partition)partitionToMove.poll(), clusterState, string);
            }
        }
    }

    private void assign(Partition partition, Map<String, Map<String, List<Partition>>> clusterState, String consumerId) {
        Map partitions = clusterState.computeIfAbsent(consumerId, k -> new HashMap());
        List ps = partitions.computeIfAbsent(partition.getTopic(), k -> new ArrayList());
        ps.add(partition);
    }

    private void randomAssign(Map<String, Partition> partitionToAssignMap, List<ConsumerInfo> consumerList, Map<String, Map<String, List<Partition>>> clusterState, Map<String, Map<String, Map<String, Partition>>> oldClusterState, List<String> filterList) {
        int searched = 1;
        int consumerSize = consumerList.size();
        for (Partition partition : partitionToAssignMap.values()) {
            ConsumerInfo consumer = null;
            int indeId = RANDOM.nextInt(consumerSize);
            do {
                Map<String, Partition> oldPartitions;
                searched = 1;
                consumer = consumerList.get(indeId);
                if (!filterList.contains(consumer.getConsumerId())) continue;
                if (consumerList.size() == 1) {
                    searched = 0;
                    break;
                }
                Map<String, Map<String, Partition>> oldPartitionMap = oldClusterState.get(consumer.getConsumerId());
                if (oldPartitionMap == null || (oldPartitions = oldPartitionMap.get(partition.getTopic())) == null || oldPartitions.get(partition.getPartitionKey()) == null) continue;
                searched = 2;
                indeId = (indeId + 1) % consumerSize;
            } while (searched >= 2);
            if (searched == 0) {
                return;
            }
            Map partitions = clusterState.computeIfAbsent(consumer.getConsumerId(), k -> new HashMap());
            List ps = partitions.computeIfAbsent(partition.getTopic(), k -> new ArrayList());
            ps.add(partition);
        }
    }

    @Override
    public Map<String, List<Partition>> roundRobinAssignment(List<Partition> partitions, List<String> consumers) {
        if (partitions.isEmpty() || consumers.isEmpty()) {
            return null;
        }
        TreeMap<String, List<Partition>> assignments = new TreeMap<String, List<Partition>>();
        int numPartitions = partitions.size();
        int numServers = consumers.size();
        int max = (int)Math.ceil((float)numPartitions / (float)numServers);
        int serverIdx = 0;
        if (numServers > 1) {
            serverIdx = RANDOM.nextInt(numServers);
        }
        int partitionIdx = 0;
        for (int j = 0; j < numServers; ++j) {
            String server = consumers.get((j + serverIdx) % numServers);
            ArrayList<Partition> serverPartitions = new ArrayList<Partition>(max);
            for (int i = partitionIdx; i < numPartitions; i += numServers) {
                serverPartitions.add(partitions.get(i % numPartitions));
            }
            assignments.put(server, serverPartitions);
            ++partitionIdx;
        }
        return assignments;
    }

    @Override
    public ConsumerInfo randomAssignment(List<ConsumerInfo> consumers) {
        if (consumers == null || consumers.isEmpty()) {
            logger.warn("Wanted to do random assignment but no servers to assign to");
            return null;
        }
        return consumers.get(RANDOM.nextInt(consumers.size()));
    }

    @Override
    public Map<String, Map<String, List<Partition>>> bukAssign(ConsumerInfoHolder consumerHolder, BrokerRunManager brokerRunManager, List<String> groupSet, MetaDataService defMetaDataService, StringBuilder strBuffer) {
        HashMap<String, Map<String, List<Partition>>> finalSubInfoMap = new HashMap<String, Map<String, List<Partition>>>();
        for (String group : groupSet) {
            List<ConsumerInfo> consumerList;
            ConsumeGroupInfo consumeGroupInfo = consumerHolder.getConsumeGroupInfo(group);
            if (consumeGroupInfo == null || consumeGroupInfo.isClientBalance() || consumeGroupInfo.isUnReadyServerBalance() || CollectionUtils.isEmpty(consumerList = consumeGroupInfo.getConsumerInfoList())) continue;
            Set<String> topicSet = consumeGroupInfo.getTopicSet();
            GroupResCtrlEntity offsetResetGroupEntity = defMetaDataService.getGroupCtrlConf(group);
            int confAllowBClientRate = offsetResetGroupEntity != null && offsetResetGroupEntity.getAllowedBrokerClientRate() > 0 ? offsetResetGroupEntity.getAllowedBrokerClientRate() : -2;
            int allowRate = confAllowBClientRate > 0 ? confAllowBClientRate : consumerHolder.getDefResourceRate();
            int maxBrokerCount = brokerRunManager.getSubTopicMaxBrokerCount(topicSet);
            int curBClientRate = (int)Math.floor(maxBrokerCount / consumerList.size());
            if (curBClientRate > allowRate) {
                int minClientCnt = maxBrokerCount / allowRate;
                if (maxBrokerCount % allowRate != 0) {
                    ++minClientCnt;
                }
                consumeGroupInfo.setConsumeResourceInfo(confAllowBClientRate, curBClientRate, minClientCnt, false);
                if (!consumeGroupInfo.isEnableBalanceChkPrint()) continue;
                logger.info(strBuffer.append("[UnBound Alloc 1] Not allocate partition :group(").append(group).append(")'s consumer getCachedSize(").append(consumeGroupInfo.getGroupCnt()).append(") low than min required client count:").append(minClientCnt).toString());
                strBuffer.delete(0, strBuffer.length());
                continue;
            }
            consumeGroupInfo.setConsumeResourceInfo(confAllowBClientRate, curBClientRate, -2, true);
            Collections.sort(consumerList);
            for (String topic : topicSet) {
                List<Partition> partPubList = brokerRunManager.getSubBrokerAcceptSubParts(topic);
                Collections.sort(partPubList);
                int partsPerConsumer = partPubList.size() / consumerList.size();
                int consumersWithExtraPart = partPubList.size() % consumerList.size();
                for (int i = 0; i < consumerList.size(); ++i) {
                    String consumerId = consumerList.get(i).getConsumerId();
                    Map topicSubPartMap = finalSubInfoMap.computeIfAbsent(consumerId, k -> new HashMap());
                    List partList = topicSubPartMap.computeIfAbsent(topic, k -> new ArrayList());
                    int startIndex = partsPerConsumer * i + Math.min(i, consumersWithExtraPart);
                    int parts = partsPerConsumer + (i + 1 > consumersWithExtraPart ? 0 : 1);
                    for (int j = startIndex; j < startIndex + parts; ++j) {
                        Partition part = partPubList.get(j);
                        partList.add(part);
                    }
                }
            }
        }
        return finalSubInfoMap;
    }

    @Override
    public Map<String, Map<String, Map<String, Partition>>> resetBukAssign(ConsumerInfoHolder consumerHolder, BrokerRunManager brokerRunManager, List<String> groupSet, MetaDataService defMetaDataService, StringBuilder strBuffer) {
        return this.inReBalanceCluster(false, consumerHolder, brokerRunManager, groupSet, defMetaDataService, strBuffer);
    }

    @Override
    public Map<String, Map<String, Map<String, Partition>>> resetBalanceCluster(Map<String, Map<String, Map<String, Partition>>> clusterState, ConsumerInfoHolder consumerHolder, BrokerRunManager brokerRunManager, List<String> groupSet, MetaDataService defMetaDataService, StringBuilder strBuffer) {
        return this.inReBalanceCluster(true, consumerHolder, brokerRunManager, groupSet, defMetaDataService, strBuffer);
    }

    private Map<String, Map<String, Map<String, Partition>>> inReBalanceCluster(boolean isResetRebalance, ConsumerInfoHolder consumerHolder, BrokerRunManager brokerRunManager, List<String> groupSet, MetaDataService defMetaDataService, StringBuilder strBuffer) {
        HashMap<String, Map<String, Map<String, Partition>>> finalSubInfoMap = new HashMap<String, Map<String, Map<String, Partition>>>();
        for (String group : groupSet) {
            ConsumeGroupInfo consumeGroupInfo;
            if (group == null || (consumeGroupInfo = consumerHolder.getConsumeGroupInfo(group)) == null || consumeGroupInfo.isGroupEmpty() || consumeGroupInfo.isNotNeedBoundBalance()) continue;
            if (!consumeGroupInfo.isGroupFullSize()) {
                Long checkCycle = consumerHolder.addCurCheckCycle(group);
                if (isResetRebalance) {
                    if (checkCycle == null || checkCycle % 15L != 0L) continue;
                    logger.info(strBuffer.append("[Bound Alloc 2] Not allocate partition :group(").append(group).append(")'s consumer getCachedSize(").append(consumeGroupInfo.getGroupCnt()).append(") low than required source count:").append(consumeGroupInfo.getSourceCount()).append(", checked cycle is ").append(checkCycle).toString());
                    strBuffer.delete(0, strBuffer.length());
                    continue;
                }
                logger.info(strBuffer.append("[Bound Alloc 1] Not allocate partition :group(").append(group).append(")'s consumer getCachedSize(").append(consumeGroupInfo.getGroupCnt()).append(") low than required source count:").append(consumeGroupInfo.getSourceCount()).toString());
                strBuffer.delete(0, strBuffer.length());
                continue;
            }
            Map<String, Partition> partPubMap = brokerRunManager.getSubBrokerAcceptSubParts(consumeGroupInfo.getTopicSet());
            HashMap<String, Partition> partitionMap = new HashMap<String, Partition>();
            for (Partition partition : partPubMap.values()) {
                partitionMap.put(partition.getPartitionKey(), partition);
            }
            Map<String, String> partsConsumerMap = consumeGroupInfo.getPartitionInfoMap();
            for (Map.Entry<String, String> entry : partsConsumerMap.entrySet()) {
                Partition foundPart = (Partition)partitionMap.get(entry.getKey());
                if (foundPart == null) continue;
                String consumerId = entry.getValue();
                Map topicSubPartMap = finalSubInfoMap.computeIfAbsent(consumerId, k -> new HashMap());
                Map partMap = topicSubPartMap.computeIfAbsent(foundPart.getTopic(), k -> new HashMap());
                partMap.put(foundPart.getPartitionKey(), foundPart);
                partitionMap.remove(entry.getKey());
            }
            if (consumeGroupInfo.addAllocatedTimes() <= 0) continue;
            MasterSrvStatsHolder.updSvrBalResetDurations(System.currentTimeMillis() - consumeGroupInfo.getCreateTime());
        }
        return finalSubInfoMap;
    }
}

