/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.configuration;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.inlong.sort.configuration.FallbackKey;

public class ConfigOption<T> {
    private static final FallbackKey[] EMPTY = new FallbackKey[0];
    private final String key;
    private final FallbackKey[] fallbackKeys;
    private final T defaultValue;
    private final String description;

    ConfigOption(String key, T defaultValue) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.description = "";
        this.defaultValue = defaultValue;
        this.fallbackKeys = EMPTY;
    }

    ConfigOption(String key, String description, T defaultValue, FallbackKey ... fallbackKeys) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.description = (String)Preconditions.checkNotNull((Object)description);
        this.defaultValue = defaultValue;
        this.fallbackKeys = fallbackKeys == null || fallbackKeys.length == 0 ? EMPTY : fallbackKeys;
    }

    public ConfigOption<T> withFallbackKeys(String ... fallbackKeys) {
        Stream<FallbackKey> newFallbackKeys = Arrays.stream(fallbackKeys).map(FallbackKey::createFallbackKey);
        Stream<FallbackKey> currentAlternativeKeys = Arrays.stream(this.fallbackKeys);
        FallbackKey[] mergedAlternativeKeys = (FallbackKey[])Stream.concat(newFallbackKeys, currentAlternativeKeys).toArray(FallbackKey[]::new);
        return new ConfigOption<T>(this.key, this.description, this.defaultValue, mergedAlternativeKeys);
    }

    public ConfigOption<T> withDeprecatedKeys(String ... deprecatedKeys) {
        Stream<FallbackKey> newDeprecatedKeys = Arrays.stream(deprecatedKeys).map(FallbackKey::createDeprecatedKey);
        Stream<FallbackKey> currentAlternativeKeys = Arrays.stream(this.fallbackKeys);
        FallbackKey[] mergedAlternativeKeys = (FallbackKey[])Stream.concat(currentAlternativeKeys, newDeprecatedKeys).toArray(FallbackKey[]::new);
        return new ConfigOption<T>(this.key, this.description, this.defaultValue, mergedAlternativeKeys);
    }

    public ConfigOption<T> withDescription(String description) {
        return new ConfigOption<T>(this.key, description, this.defaultValue, this.fallbackKeys);
    }

    public String key() {
        return this.key;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    @Deprecated
    public boolean hasDeprecatedKeys() {
        return this.fallbackKeys != EMPTY && Arrays.stream(this.fallbackKeys).anyMatch(FallbackKey::isDeprecated);
    }

    @Deprecated
    public Iterable<String> deprecatedKeys() {
        return this.fallbackKeys == EMPTY ? Collections.emptyList() : (Iterable)Arrays.stream(this.fallbackKeys).filter(FallbackKey::isDeprecated).map(FallbackKey::getKey).collect(Collectors.toList());
    }

    public boolean hasFallbackKeys() {
        return this.fallbackKeys != EMPTY;
    }

    public Iterable<FallbackKey> fallbackKeys() {
        return this.fallbackKeys == EMPTY ? Collections.emptyList() : Arrays.asList(this.fallbackKeys);
    }

    public String description() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == ConfigOption.class) {
            ConfigOption that = (ConfigOption)o;
            return this.key.equals(that.key) && Arrays.equals(this.fallbackKeys, that.fallbackKeys) && (this.defaultValue == null ? that.defaultValue == null : that.defaultValue != null && this.defaultValue.equals(that.defaultValue));
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + 17 * Arrays.hashCode(this.fallbackKeys) + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
    }

    public String toString() {
        return String.format("Key: '%s' , default: %s (fallback keys: %s)", this.key, this.defaultValue, Arrays.toString(this.fallbackKeys));
    }
}

