/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.LookupOptions;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.enums.RedisCommand;
import org.apache.inlong.sort.protocol.enums.RedisMode;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="redisExtract")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RedisExtractNode
extends ExtractNode
implements Metadata,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    @JsonProperty(value="redisMode")
    private RedisMode redisMode;
    @Nonnull
    @JsonProperty(value="command")
    private RedisCommand command;
    @Nullable
    @JsonProperty(value="clusterNodes")
    private String clusterNodes;
    @Nullable
    @JsonProperty(value="masterName")
    private String masterName;
    @Nullable
    @JsonProperty(value="sentinelsInfo")
    private String sentinelsInfo;
    @Nullable
    @JsonProperty(value="host")
    private String host;
    @Nullable
    @JsonProperty(value="port")
    private Integer port;
    @Nullable
    @JsonProperty(value="password")
    private String password;
    @Nullable
    @JsonProperty(value="additionalKey")
    private String additionalKey;
    @Nullable
    @JsonProperty(value="database")
    private Integer database;
    @Nullable
    @JsonProperty(value="timeout")
    private Integer timeout;
    @Nullable
    @JsonProperty(value="soTimeout")
    private Integer soTimeout;
    @Nullable
    @JsonProperty(value="maxTotal")
    private Integer maxTotal;
    @Nullable
    @JsonProperty(value="maxIdle")
    private Integer maxIdle;
    @Nullable
    @JsonProperty(value="minIdle")
    private Integer minIdle;
    @Nullable
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @Nullable
    @JsonProperty(value="lookupOptions")
    private LookupOptions lookupOptions;

    public RedisExtractNode(@Nonnull @JsonProperty(value="id") String id, @Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @Nonnull @JsonProperty(value="command") RedisCommand command, @Nullable @JsonProperty(value="host") String host, @Nullable @JsonProperty(value="port") Integer port, @Nullable @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="additionalKey") String additionalKey, @Nullable @JsonProperty(value="database") Integer database, @Nullable @JsonProperty(value="timeout") Integer timeout, @Nullable @JsonProperty(value="soTimeout") Integer soTimeout, @Nullable @JsonProperty(value="maxTotal") Integer maxTotal, @Nullable @JsonProperty(value="maxIdle") Integer maxIdle, @Nullable @JsonProperty(value="minIdle") Integer minIdle, @Nullable @JsonProperty(value="lookupOptions") LookupOptions lookupOptions) {
        this(id, name, fields, watermarkField, properties, primaryKey, RedisMode.STANDALONE, command, null, null, null, host, port, password, additionalKey, database, timeout, soTimeout, maxTotal, maxIdle, minIdle, lookupOptions);
    }

    public RedisExtractNode(@Nonnull @JsonProperty(value="id") String id, @Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @Nonnull @JsonProperty(value="command") RedisCommand command, @Nullable @JsonProperty(value="clusterNodes") String clusterNodes, @Nullable @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="additionalKey") String additionalKey, @Nullable @JsonProperty(value="database") Integer database, @Nullable @JsonProperty(value="timeout") Integer timeout, @Nullable @JsonProperty(value="soTimeout") Integer soTimeout, @Nullable @JsonProperty(value="maxTotal") Integer maxTotal, @Nullable @JsonProperty(value="maxIdle") Integer maxIdle, @Nullable @JsonProperty(value="minIdle") Integer minIdle, @Nullable @JsonProperty(value="lookupOptions") LookupOptions lookupOptions) {
        this(id, name, fields, watermarkField, properties, primaryKey, RedisMode.CLUSTER, command, null, null, null, null, null, password, additionalKey, database, timeout, soTimeout, maxTotal, maxIdle, minIdle, lookupOptions);
    }

    public RedisExtractNode(@Nonnull @JsonProperty(value="id") String id, @Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @Nonnull @JsonProperty(value="command") RedisCommand command, @Nullable @JsonProperty(value="masterName") String masterName, @Nullable @JsonProperty(value="sentinelsInfo") String sentinelsInfo, @Nullable @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="additionalKey") String additionalKey, @Nullable @JsonProperty(value="database") Integer database, @Nullable @JsonProperty(value="timeout") Integer timeout, @Nullable @JsonProperty(value="soTimeout") Integer soTimeout, @Nullable @JsonProperty(value="maxTotal") Integer maxTotal, @Nullable @JsonProperty(value="maxIdle") Integer maxIdle, @Nullable @JsonProperty(value="minIdle") Integer minIdle, @Nullable @JsonProperty(value="lookupOptions") LookupOptions lookupOptions) {
        this(id, name, fields, watermarkField, properties, primaryKey, RedisMode.SENTINEL, command, null, masterName, sentinelsInfo, null, null, password, additionalKey, database, timeout, soTimeout, maxTotal, maxIdle, minIdle, lookupOptions);
    }

    @JsonCreator
    public RedisExtractNode(@Nonnull @JsonProperty(value="id") String id, @Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="properties") Map<String, String> properties, @Nullable @JsonProperty(value="primaryKey") String primaryKey, @Nonnull @JsonProperty(value="redisMode") RedisMode redisMode, @Nonnull @JsonProperty(value="command") RedisCommand command, @Nullable @JsonProperty(value="clusterNodes") String clusterNodes, @Nullable @JsonProperty(value="masterName") String masterName, @Nullable @JsonProperty(value="sentinelsInfo") String sentinelsInfo, @Nullable @JsonProperty(value="host") String host, @Nullable @JsonProperty(value="port") Integer port, @Nullable @JsonProperty(value="password") String password, @Nullable @JsonProperty(value="additionalKey") String additionalKey, @Nullable @JsonProperty(value="database") Integer database, @Nullable @JsonProperty(value="timeout") Integer timeout, @Nullable @JsonProperty(value="soTimeout") Integer soTimeout, @Nullable @JsonProperty(value="maxTotal") Integer maxTotal, @Nullable @JsonProperty(value="maxIdle") Integer maxIdle, @Nullable @JsonProperty(value="minIdle") Integer minIdle, @Nullable @JsonProperty(value="lookupOptions") LookupOptions lookupOptions) {
        super(id, name, fields, watermarkField, properties);
        this.redisMode = (RedisMode)((Object)Preconditions.checkNotNull((Object)((Object)redisMode), (Object)"redisMode is null"));
        this.command = (RedisCommand)((Object)Preconditions.checkNotNull((Object)((Object)command), (Object)"command is null"));
        this.clusterNodes = clusterNodes;
        this.masterName = masterName;
        this.sentinelsInfo = sentinelsInfo;
        this.host = host;
        this.port = port;
        this.primaryKey = primaryKey;
        this.password = password;
        this.additionalKey = additionalKey;
        this.database = database;
        this.timeout = timeout;
        this.soTimeout = soTimeout;
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
        this.lookupOptions = lookupOptions;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "redis-inlong");
        options.put("command", this.command.getValue());
        options.put("redis-mode", this.redisMode.getValue());
        switch (this.redisMode) {
            case CLUSTER: {
                options.put("cluster-nodes", (String)Preconditions.checkNotNull((Object)this.clusterNodes, (Object)"clusterNodes is null"));
                break;
            }
            case SENTINEL: {
                options.put("master.name", (String)Preconditions.checkNotNull((Object)this.masterName, (Object)"masterName is null"));
                options.put("sentinels.info", (String)Preconditions.checkNotNull((Object)this.sentinelsInfo, (Object)"sentinelsInfo is null"));
                if (this.database == null) break;
                options.put("database", this.database.toString());
                break;
            }
            case STANDALONE: {
                options.put("host", (String)Preconditions.checkNotNull((Object)this.host, (Object)"host is null"));
                if (this.port != null) {
                    options.put("port", this.port.toString());
                }
                if (this.database == null) break;
                options.put("database", this.database.toString());
                break;
            }
        }
        if (this.command == RedisCommand.HGET || this.command == RedisCommand.ZREVRANK || this.command == RedisCommand.ZSCORE) {
            options.put("additional.key", (String)Preconditions.checkNotNull((Object)this.additionalKey, (Object)"additionalKey is null"));
        }
        if (this.password != null) {
            options.put("password", this.password);
        }
        if (this.timeout != null) {
            options.put("timeout", this.timeout.toString());
        }
        if (this.soTimeout != null) {
            options.put("soTimeout", this.soTimeout.toString());
        }
        if (this.maxTotal != null) {
            options.put("maxTotal", this.maxTotal.toString());
        }
        if (this.maxIdle != null) {
            options.put("maxIdle", this.maxIdle.toString());
        }
        if (this.minIdle != null) {
            options.put("minIdle", this.minIdle.toString());
        }
        if (this.lookupOptions != null) {
            if (this.lookupOptions.getLookupCacheMaxRows() != null) {
                options.put("lookup.cache.max-rows", this.lookupOptions.getLookupCacheMaxRows().toString());
            }
            if (this.lookupOptions.getLookupCacheTtl() != null) {
                options.put("lookup.cache.ttl", this.lookupOptions.getLookupCacheTtl().toString());
            }
            if (this.lookupOptions.getLookupMaxRetries() != null) {
                options.put("lookup.max-retries", this.lookupOptions.getLookupMaxRetries().toString());
            }
        }
        return options;
    }

    @Override
    public String genTableName() {
        return String.format("table_%s", this.getId());
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return false;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.PROCESS_TIME);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisExtractNode)) {
            return false;
        }
        RedisExtractNode other = (RedisExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$database = this.getDatabase();
        Integer other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$soTimeout = this.getSoTimeout();
        Integer other$soTimeout = other.getSoTimeout();
        if (this$soTimeout == null ? other$soTimeout != null : !((Object)this$soTimeout).equals(other$soTimeout)) {
            return false;
        }
        Integer this$maxTotal = this.getMaxTotal();
        Integer other$maxTotal = other.getMaxTotal();
        if (this$maxTotal == null ? other$maxTotal != null : !((Object)this$maxTotal).equals(other$maxTotal)) {
            return false;
        }
        Integer this$maxIdle = this.getMaxIdle();
        Integer other$maxIdle = other.getMaxIdle();
        if (this$maxIdle == null ? other$maxIdle != null : !((Object)this$maxIdle).equals(other$maxIdle)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        RedisMode this$redisMode = this.getRedisMode();
        RedisMode other$redisMode = other.getRedisMode();
        if (this$redisMode == null ? other$redisMode != null : !((Object)((Object)this$redisMode)).equals((Object)other$redisMode)) {
            return false;
        }
        RedisCommand this$command = this.getCommand();
        RedisCommand other$command = other.getCommand();
        if (this$command == null ? other$command != null : !((Object)((Object)this$command)).equals((Object)other$command)) {
            return false;
        }
        String this$clusterNodes = this.getClusterNodes();
        String other$clusterNodes = other.getClusterNodes();
        if (this$clusterNodes == null ? other$clusterNodes != null : !this$clusterNodes.equals(other$clusterNodes)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        String this$sentinelsInfo = this.getSentinelsInfo();
        String other$sentinelsInfo = other.getSentinelsInfo();
        if (this$sentinelsInfo == null ? other$sentinelsInfo != null : !this$sentinelsInfo.equals(other$sentinelsInfo)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$additionalKey = this.getAdditionalKey();
        String other$additionalKey = other.getAdditionalKey();
        if (this$additionalKey == null ? other$additionalKey != null : !this$additionalKey.equals(other$additionalKey)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        LookupOptions this$lookupOptions = this.getLookupOptions();
        LookupOptions other$lookupOptions = other.getLookupOptions();
        return !(this$lookupOptions == null ? other$lookupOptions != null : !((Object)this$lookupOptions).equals(other$lookupOptions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RedisExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $soTimeout = this.getSoTimeout();
        result = result * 59 + ($soTimeout == null ? 43 : ((Object)$soTimeout).hashCode());
        Integer $maxTotal = this.getMaxTotal();
        result = result * 59 + ($maxTotal == null ? 43 : ((Object)$maxTotal).hashCode());
        Integer $maxIdle = this.getMaxIdle();
        result = result * 59 + ($maxIdle == null ? 43 : ((Object)$maxIdle).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        RedisMode $redisMode = this.getRedisMode();
        result = result * 59 + ($redisMode == null ? 43 : ((Object)((Object)$redisMode)).hashCode());
        RedisCommand $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)((Object)$command)).hashCode());
        String $clusterNodes = this.getClusterNodes();
        result = result * 59 + ($clusterNodes == null ? 43 : $clusterNodes.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        String $sentinelsInfo = this.getSentinelsInfo();
        result = result * 59 + ($sentinelsInfo == null ? 43 : $sentinelsInfo.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $additionalKey = this.getAdditionalKey();
        result = result * 59 + ($additionalKey == null ? 43 : $additionalKey.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        LookupOptions $lookupOptions = this.getLookupOptions();
        result = result * 59 + ($lookupOptions == null ? 43 : ((Object)$lookupOptions).hashCode());
        return result;
    }

    @Nonnull
    public RedisMode getRedisMode() {
        return this.redisMode;
    }

    @Nonnull
    public RedisCommand getCommand() {
        return this.command;
    }

    @Nullable
    public String getClusterNodes() {
        return this.clusterNodes;
    }

    @Nullable
    public String getMasterName() {
        return this.masterName;
    }

    @Nullable
    public String getSentinelsInfo() {
        return this.sentinelsInfo;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getAdditionalKey() {
        return this.additionalKey;
    }

    @Nullable
    public Integer getDatabase() {
        return this.database;
    }

    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    @Nullable
    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    @Nullable
    public Integer getMaxIdle() {
        return this.maxIdle;
    }

    @Nullable
    public Integer getMinIdle() {
        return this.minIdle;
    }

    @Override
    @Nullable
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Nullable
    public LookupOptions getLookupOptions() {
        return this.lookupOptions;
    }

    public void setRedisMode(@Nonnull RedisMode redisMode) {
        if (redisMode == null) {
            throw new NullPointerException("redisMode is marked non-null but is null");
        }
        this.redisMode = redisMode;
    }

    public void setCommand(@Nonnull RedisCommand command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.command = command;
    }

    public void setClusterNodes(@Nullable String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setMasterName(@Nullable String masterName) {
        this.masterName = masterName;
    }

    public void setSentinelsInfo(@Nullable String sentinelsInfo) {
        this.sentinelsInfo = sentinelsInfo;
    }

    public void setHost(@Nullable String host) {
        this.host = host;
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public void setAdditionalKey(@Nullable String additionalKey) {
        this.additionalKey = additionalKey;
    }

    public void setDatabase(@Nullable Integer database) {
        this.database = database;
    }

    public void setTimeout(@Nullable Integer timeout) {
        this.timeout = timeout;
    }

    public void setSoTimeout(@Nullable Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setMaxTotal(@Nullable Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(@Nullable Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(@Nullable Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setPrimaryKey(@Nullable String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setLookupOptions(@Nullable LookupOptions lookupOptions) {
        this.lookupOptions = lookupOptions;
    }

    @Override
    public String toString() {
        return "RedisExtractNode(redisMode=" + (Object)((Object)this.getRedisMode()) + ", command=" + (Object)((Object)this.getCommand()) + ", clusterNodes=" + this.getClusterNodes() + ", masterName=" + this.getMasterName() + ", sentinelsInfo=" + this.getSentinelsInfo() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", password=" + this.getPassword() + ", additionalKey=" + this.getAdditionalKey() + ", database=" + this.getDatabase() + ", timeout=" + this.getTimeout() + ", soTimeout=" + this.getSoTimeout() + ", maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", primaryKey=" + this.getPrimaryKey() + ", lookupOptions=" + this.getLookupOptions() + ")";
    }
}

