/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.source;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.Configurable;
import org.apache.flume.source.AbstractSource;
import org.apache.inlong.audit.channel.FailoverChannelProcessor;
import org.apache.inlong.audit.source.ServiceDecoder;
import org.apache.inlong.audit.utils.EventLoopUtil;
import org.apache.inlong.audit.utils.FailoverChannelProcessorHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTcpSource
extends AbstractSource
implements Configurable,
EventDrivenSource {
    private static final Logger logger = LoggerFactory.getLogger(SimpleTcpSource.class);
    private static final String CONNECTIONS = "connections";
    protected int maxConnections = Integer.MAX_VALUE;
    protected long msgValidThresholdDays;
    protected Context context;
    private ServerBootstrap bootstrap = null;
    protected EventLoopGroup acceptorGroup;
    protected EventLoopGroup workerGroup;
    protected DefaultThreadFactory acceptorThreadFactory;
    protected ChannelGroup allChannels = new DefaultChannelGroup("DefaultAuditChannelGroup", (EventExecutor)GlobalEventExecutor.INSTANCE);
    protected ChannelFuture channelFuture;
    protected int port;
    protected String host = null;
    protected String msgFactoryName;
    protected String serviceDecoderName;
    protected String messageHandlerName;
    protected int maxMsgLength;
    private int maxThreads = 32;
    private boolean tcpNoDelay = true;
    private boolean keepAlive = true;
    private int receiveBufferSize;
    private int highWaterMark;
    private int sendBufferSize;
    protected boolean customProcessor = false;
    private static String HOST_DEFAULT_VALUE = "0.0.0.0";
    private static int DEFAULT_MAX_THREADS = 32;
    private static int DEFAULT_MAX_CONNECTIONS = 5000;
    private static long DEFAULT_MSG_VALID_THRESHOLD_DAYS = 7L;
    private static int MIN_MSG_LENGTH = 4;
    private static int MAX_MSG_LENGTH = 65536;
    private static int BUFFER_SIZE_MUST_THAN = 0;
    private static int HIGH_WATER_MARK_DEFAULT_VALUE = 65536;
    private static int RECEIVE_BUFFER_DEFAULT_SIZE = 65536;
    private static int SEND_BUFFER_DEFAULT_SIZE = 65536;
    private static int RECEIVE_BUFFER_MAX_SIZE = 0x1000000;
    private static int SEND_BUFFER_MAX_SIZE = 0x1000000;
    protected boolean enableBusyWait = false;
    protected int acceptorThreads = 1;
    private Channel nettyChannel = null;

    public synchronized void start() {
        logger.info("start " + this.getName());
        if (this.customProcessor) {
            ChannelSelector selector = this.getChannelProcessor().getSelector();
            FailoverChannelProcessor newProcessor = new FailoverChannelProcessor(selector);
            newProcessor.configure(this.context);
            this.setChannelProcessor(newProcessor);
            FailoverChannelProcessorHolder.setChannelProcessor(newProcessor);
        }
        super.start();
        this.acceptorThreadFactory = new DefaultThreadFactory("tcpSource-nettyBoss-threadGroup");
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup(this.acceptorThreads, false, (ThreadFactory)this.acceptorThreadFactory);
        this.workerGroup = EventLoopUtil.newEventLoopGroup(this.maxThreads, this.enableBusyWait, (ThreadFactory)new DefaultThreadFactory("tcpSource-nettyWorker-threadGroup"));
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.keepAlive);
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.receiveBufferSize);
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.sendBufferSize);
        this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)this.highWaterMark);
        this.bootstrap.channel(EventLoopUtil.getServerSocketChannelClass(this.workerGroup));
        EventLoopUtil.enableTriggeredMode(this.bootstrap);
        this.bootstrap.group(this.acceptorGroup, this.workerGroup);
        logger.info("load msgFactory=" + this.msgFactoryName + " and serviceDecoderName=" + this.serviceDecoderName);
        ChannelInitializer fac = null;
        try {
            ServiceDecoder serviceDecoder = (ServiceDecoder)Class.forName(this.serviceDecoderName).newInstance();
            Class<?> clazz = Class.forName(this.msgFactoryName);
            Constructor<?> ctor = clazz.getConstructor(AbstractSource.class, ChannelGroup.class, ServiceDecoder.class, String.class, Integer.class, Integer.class, Long.class, String.class);
            logger.info("Using channel processor:{}", (Object)((Object)((Object)this)).getClass().getName());
            fac = (ChannelInitializer)ctor.newInstance(new Object[]{this, this.allChannels, serviceDecoder, this.messageHandlerName, this.maxMsgLength, this.maxConnections, this.msgValidThresholdDays, this.getName()});
        }
        catch (Exception e) {
            logger.error("Simple Tcp Source start error, fail to construct ChannelPipelineFactory with name {}, ex {}", (Object)this.msgFactoryName, (Object)e);
            this.stop();
            throw new FlumeException(e.getMessage());
        }
        this.bootstrap.childHandler((ChannelHandler)fac);
        try {
            this.channelFuture = this.host == null ? this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port)).sync() : this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.host, this.port)).sync();
        }
        catch (Exception e) {
            logger.error("Simple TCP Source bind {}:{} error, program will exit!", new Object[]{this.host, this.port, e});
            System.exit(-1);
        }
        logger.info("Simple TCP Source started at host {}, port {}", (Object)this.host, (Object)this.port);
    }

    public synchronized void stop() {
        logger.info("[STOP SOURCE]{} stopping...", (Object)super.getName());
        if (this.allChannels != null && !this.allChannels.isEmpty()) {
            try {
                this.allChannels.close().awaitUninterruptibly();
            }
            catch (Exception e) {
                logger.warn("Simple TCP Source netty server stop ex", (Throwable)e);
            }
            finally {
                this.allChannels.clear();
            }
        }
        super.stop();
        logger.info("[STOP SOURCE]{} stopped", (Object)super.getName());
    }

    public void configure(Context context) {
        logger.info("context is {}", (Object)context);
        this.context = context;
        this.port = context.getInteger("port");
        this.host = context.getString("host", HOST_DEFAULT_VALUE);
        this.tcpNoDelay = context.getBoolean("tcpNoDelay", Boolean.valueOf(true));
        this.keepAlive = context.getBoolean("keepAlive", Boolean.valueOf(true));
        this.highWaterMark = context.getInteger("highWaterMark", Integer.valueOf(HIGH_WATER_MARK_DEFAULT_VALUE));
        this.receiveBufferSize = context.getInteger("receiveBufferSize", Integer.valueOf(RECEIVE_BUFFER_DEFAULT_SIZE));
        if (this.receiveBufferSize > RECEIVE_BUFFER_MAX_SIZE) {
            this.receiveBufferSize = RECEIVE_BUFFER_MAX_SIZE;
        }
        Preconditions.checkArgument((this.receiveBufferSize > BUFFER_SIZE_MUST_THAN ? 1 : 0) != 0, (Object)"receiveBufferSize must be > 0");
        this.sendBufferSize = context.getInteger("sendBufferSize", Integer.valueOf(SEND_BUFFER_DEFAULT_SIZE));
        if (this.sendBufferSize > SEND_BUFFER_MAX_SIZE) {
            this.sendBufferSize = SEND_BUFFER_MAX_SIZE;
        }
        Preconditions.checkArgument((this.sendBufferSize > BUFFER_SIZE_MUST_THAN ? 1 : 0) != 0, (Object)"sendBufferSize must be > 0");
        try {
            this.maxThreads = context.getInteger("max-threads", Integer.valueOf(DEFAULT_MAX_THREADS));
        }
        catch (NumberFormatException e) {
            logger.warn("Simple TCP Source max-threads property must specify an integer value. {}", (Object)context.getString("max-threads"));
        }
        try {
            this.maxConnections = context.getInteger(CONNECTIONS, Integer.valueOf(DEFAULT_MAX_CONNECTIONS));
        }
        catch (NumberFormatException e) {
            logger.warn("BaseSource's \"connections\" property must specify an integer value.", (Object)context.getString(CONNECTIONS));
        }
        try {
            this.msgValidThresholdDays = context.getLong("msg.valid.threshold.days", Long.valueOf(DEFAULT_MSG_VALID_THRESHOLD_DAYS));
        }
        catch (NumberFormatException e) {
            logger.warn("BaseSource's \"msg.valid.threshold.days\" property must specify a long value.", (Object)context.getString("msg.valid.threshold.days"));
        }
        this.msgFactoryName = context.getString("msg-factory-name", "org.apache.inlong.audit.source.ServerMessageFactory");
        this.msgFactoryName = this.msgFactoryName.trim();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.msgFactoryName), (Object)"msgFactoryName is empty");
        this.serviceDecoderName = context.getString("service-decoder-name", "org.apache.inlong.audit.source.DefaultServiceDecoder");
        this.serviceDecoderName = this.serviceDecoderName.trim();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.serviceDecoderName), (Object)"serviceProcessorName is empty");
        this.messageHandlerName = context.getString("message-handler-name", "org.apache.inlong.audit.source.ServerMessageHandler");
        this.messageHandlerName = this.messageHandlerName.trim();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.messageHandlerName), (Object)"messageHandlerName is empty");
        this.maxMsgLength = context.getInteger("max-msg-length", Integer.valueOf(MAX_MSG_LENGTH));
        Preconditions.checkArgument((this.maxMsgLength >= MIN_MSG_LENGTH && this.maxMsgLength <= 0x1400000 ? 1 : 0) != 0, (Object)"maxMsgLength must be >= 4 and <= 20971520");
        this.customProcessor = context.getBoolean("custom-cp", Boolean.valueOf(false));
    }
}

