/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.config;

import java.io.Serializable;
import java.net.URLEncoder;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Base64;
import org.apache.inlong.sdk.dataproxy.config.EncryptInfo;
import org.apache.inlong.sdk.dataproxy.utils.EncryptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptConfigEntry
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(EncryptConfigEntry.class);
    private String userName = "";
    private String version;
    private String pubKey;
    private byte[] aesKey;
    private String rsaEncryptedKey;
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);

    public EncryptConfigEntry(String userName, String version, String pubKey) {
        this.userName = userName;
        this.version = version;
        this.pubKey = pubKey;
        this.aesKey = null;
        this.rsaEncryptedKey = null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public synchronized byte[] getAesKey() {
        if (this.aesKey == null) {
            this.aesKey = EncryptUtil.generateAesKey();
        }
        return this.aesKey;
    }

    public String getRsaEncryptedKey() {
        if (this.rsaEncryptedKey == null) {
            RSAPublicKey rsaKey = EncryptUtil.loadPublicKeyByText(this.pubKey);
            try {
                byte[] encryptedKey = EncryptUtil.rsaEncrypt(rsaKey, this.getAesKey());
                String tmpKey = Base64.encodeBase64String((byte[])encryptedKey);
                this.rsaEncryptedKey = URLEncoder.encode(tmpKey, "utf8");
                this.lastUpdateTime.set(System.currentTimeMillis());
                return this.rsaEncryptedKey;
            }
            catch (Exception e) {
                logger.error("RSA Encrypt error {}", (Throwable)e);
                return null;
            }
        }
        return this.rsaEncryptedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptInfo getRsaEncryptInfo() {
        EncryptInfo encryptInfo = null;
        long visitTime = this.lastUpdateTime.get();
        if (this.rsaEncryptedKey != null && System.currentTimeMillis() - visitTime <= 180000L) {
            encryptInfo = new EncryptInfo(this.version, this.rsaEncryptedKey, this.aesKey);
            if (visitTime == this.lastUpdateTime.get()) {
                return encryptInfo;
            }
            encryptInfo = null;
        }
        AtomicLong atomicLong = this.lastUpdateTime;
        synchronized (atomicLong) {
            if (visitTime == this.lastUpdateTime.get()) {
                RSAPublicKey rsaKey = EncryptUtil.loadPublicKeyByText(this.pubKey);
                this.aesKey = EncryptUtil.generateAesKey();
                try {
                    byte[] encryptedKey = EncryptUtil.rsaEncrypt(rsaKey, this.aesKey);
                    String tmpKey = Base64.encodeBase64String((byte[])encryptedKey);
                    this.rsaEncryptedKey = URLEncoder.encode(tmpKey, "utf8");
                    this.lastUpdateTime.set(System.currentTimeMillis());
                    return new EncryptInfo(this.version, this.rsaEncryptedKey, this.aesKey);
                }
                catch (Throwable e) {
                    logger.error("getRsaEncryptInfo failure, RSA Encrypt error {}", e);
                    return null;
                }
            }
        }
        return new EncryptInfo(this.version, this.rsaEncryptedKey, this.aesKey);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EncryptConfigEntry)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        EncryptConfigEntry info = (EncryptConfigEntry)other;
        return this.userName.equals(info.getUserName()) && this.version.equals(info.getVersion()) && Objects.equals(this.pubKey, info.getPubKey());
    }

    public String toString() {
        return "{\"version\":\"" + this.version + "\",\"public_key\":\"" + this.pubKey + "\",\"groupId\":\"" + this.userName + "\"}";
    }
}

