/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.sender.MsgSendCallback;

public class TcpCallFuture
implements MsgSendCallback {
    private final int messageId;
    private final String groupId;
    private final String streamId;
    private final int msgCnt;
    private final int eventSize;
    private final long rtTime;
    private final String clientAddr;
    private final long chanTerm;
    private final String chanStr;
    private final MsgSendCallback callback;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final boolean isAsyncCall;
    private ProcessResult result = null;
    private Throwable error = null;

    public TcpCallFuture(EncodeObject encObject, String clientAddr, long chanTerm, String chanStr, MsgSendCallback callback) {
        this.messageId = encObject.getMessageId();
        this.groupId = encObject.getGroupId();
        this.streamId = encObject.getStreamId();
        this.rtTime = encObject.getRtms();
        this.msgCnt = encObject.getMsgCnt();
        this.eventSize = encObject.getEventSize();
        this.clientAddr = clientAddr;
        this.chanTerm = chanTerm;
        this.chanStr = chanStr;
        this.callback = callback;
        this.isAsyncCall = callback != null;
    }

    @Override
    public void onMessageAck(ProcessResult result) {
        this.result = result;
        this.latch.countDown();
        if (this.isAsyncCall) {
            this.callback.onMessageAck(result);
        }
    }

    @Override
    public void onException(Throwable ex) {
        this.error = ex;
        this.latch.countDown();
        if (this.isAsyncCall) {
            this.callback.onException(this.error);
        }
    }

    public boolean get(ProcessResult processResult, long timeout, TimeUnit unit) {
        try {
            if (this.latch.await(timeout, unit)) {
                if (this.error != null) {
                    return processResult.setFailResult(ErrorCode.SEND_ON_EXCEPTION, this.error.getMessage());
                }
                return processResult.setFailResult(this.result);
            }
            return processResult.setFailResult(ErrorCode.SEND_WAIT_TIMEOUT);
        }
        catch (Throwable ex) {
            if (ex instanceof InterruptedException) {
                return processResult.setFailResult(ErrorCode.SEND_WAIT_INTERRUPT);
            }
            return processResult.setFailResult(ErrorCode.UNKNOWN_ERROR, ex.getMessage());
        }
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public int getMsgCnt() {
        return this.msgCnt;
    }

    public long getRtTime() {
        return this.rtTime;
    }

    public String getClientAddr() {
        return this.clientAddr;
    }

    public String getChanStr() {
        return this.chanStr;
    }

    public long getChanTerm() {
        return this.chanTerm;
    }

    public boolean isAsyncCall() {
        return this.isAsyncCall;
    }

    public int getEventSize() {
        return this.eventSize;
    }
}

