/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterDTO;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterInfo;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KafkaClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaClusterOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "KAFKA";
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        KafkaClusterInfo kafkaClusterInfo = new KafkaClusterInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)kafkaClusterInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            KafkaClusterDTO dto = KafkaClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)kafkaClusterInfo);
        }
        return kafkaClusterInfo;
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        KafkaClusterRequest kafkaRequest = (KafkaClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)kafkaRequest, (Object)targetEntity, (boolean)true);
        try {
            KafkaClusterDTO dto = KafkaClusterDTO.getFromRequest((KafkaClusterRequest)kafkaRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.debug("success to set entity for kafka cluster");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of Kafka Cluster failure: %s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean testConnection(ClusterRequest request) {
        String bootstrapServers = request.getUrl();
        Preconditions.expectNotBlank((String)bootstrapServers, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection url cannot be empty");
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        try (Admin ignored = Admin.create((Properties)props);){
            ListTopicsResult topics = ignored.listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(30000)));
            topics.names().get();
            LOGGER.debug("kafka connection not null - connection success for bootstrapServers={}", (Object)topics);
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsg = String.format("kafka connection failed for bootstrapServers=%s", bootstrapServers);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }

    @Override
    public Object getClusterInfo(InlongClusterEntity entity) {
        KafkaClusterInfo kafkaClusterInfo = (KafkaClusterInfo)this.getFromEntity(entity);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", kafkaClusterInfo.getUrl());
        return map;
    }
}

