/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.hudi;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.hudi.HudiDataNodeDTO;
import org.apache.inlong.manager.pojo.node.hudi.HudiDataNodeInfo;
import org.apache.inlong.manager.pojo.node.hudi.HudiDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.hudi.HudiCatalogClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HudiDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HudiDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "HUDI";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        HudiDataNodeInfo hudiDataNodeInfo = new HudiDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)hudiDataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            HudiDataNodeDTO dto = HudiDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)hudiDataNodeInfo);
        }
        return hudiDataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        HudiDataNodeRequest hudiNodeRequest = (HudiDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)hudiNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            HudiDataNodeDTO dto = HudiDataNodeDTO.getFromRequest((HudiDataNodeRequest)hudiNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Hudi node: %s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean testConnection(DataNodeRequest request) {
        HudiDataNodeRequest hudiRequest = (HudiDataNodeRequest)request;
        String metastoreUri = hudiRequest.getUrl();
        String warehouse = hudiRequest.getWarehouse();
        Preconditions.expectNotBlank((String)metastoreUri, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection url cannot be empty");
        try (HudiCatalogClient client = new HudiCatalogClient(metastoreUri, warehouse);){
            client.open();
            client.listAllDatabases();
            LOGGER.info("hudi connection not null - connection success for metastoreUri={}, warehouse={}", (Object)metastoreUri, (Object)warehouse);
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsg = String.format("hudi connection failed for metastoreUri=%s, warehouse=%s", metastoreUri, warehouse);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

