/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.queue.pulsar;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.QueryMessageRequest;
import org.apache.inlong.manager.service.resource.queue.pulsar.PulsarOperator;
import org.apache.inlong.manager.service.resource.queue.pulsar.QueryCountDownLatch;

public class QueryLatestMessagesRunnable
implements Runnable {
    private InlongPulsarInfo inlongPulsarInfo;
    private InlongStreamInfo streamInfo;
    private PulsarClusterInfo clusterInfo;
    private PulsarOperator pulsarOperator;
    private QueryMessageRequest queryMessageRequest;
    private List<BriefMQMessage> briefMQMessages;
    private QueryCountDownLatch latch;

    public QueryLatestMessagesRunnable(InlongPulsarInfo inlongPulsarInfo, InlongStreamInfo streamInfo, PulsarClusterInfo clusterInfo, PulsarOperator pulsarOperator, QueryMessageRequest queryMessageRequest, List<BriefMQMessage> briefMQMessages, QueryCountDownLatch latch) {
        this.inlongPulsarInfo = inlongPulsarInfo;
        this.streamInfo = streamInfo;
        this.clusterInfo = clusterInfo;
        this.pulsarOperator = pulsarOperator;
        this.queryMessageRequest = queryMessageRequest;
        this.briefMQMessages = briefMQMessages;
        this.latch = latch;
    }

    @Override
    public void run() {
        boolean serial;
        String tenant = this.inlongPulsarInfo.getPulsarTenant();
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = this.clusterInfo.getPulsarTenant();
        }
        String namespace = this.inlongPulsarInfo.getMqResource();
        String topicName = this.streamInfo.getMqResource();
        String fullTopicName = tenant + "/" + namespace + "/" + topicName;
        List<BriefMQMessage> messages = this.pulsarOperator.queryLatestMessage(this.clusterInfo, fullTopicName, this.queryMessageRequest, this.streamInfo, serial = "SERIAL".equals(this.inlongPulsarInfo.getQueueModule()));
        if (CollectionUtils.isNotEmpty(messages)) {
            this.briefMQMessages.addAll(messages);
            this.latch.countDown(messages.size());
        }
    }
}

