/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.SinkType;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractStandaloneSinkResourceOperator
implements SinkResourceOperator {
    private static final Logger log = LoggerFactory.getLogger(AbstractStandaloneSinkResourceOperator.class);
    @Autowired
    private InlongClusterEntityMapper clusterEntityMapper;
    @Autowired
    private StreamSinkEntityMapper sinkEntityMapper;
    @Autowired
    private InlongGroupEntityMapper groupEntityMapper;
    @Autowired
    private StreamSinkService sinkService;
    private Random rand = new Random();

    @VisibleForTesting
    protected void assignCluster(SinkInfo sinkInfo) {
        try {
            if (StringUtils.isBlank((CharSequence)sinkInfo.getSinkType())) {
                throw new IllegalArgumentException(ErrorCodeEnum.SINK_TYPE_IS_NULL.getMessage());
            }
            if (StringUtils.isNotBlank((CharSequence)sinkInfo.getInlongClusterName())) {
                String info = "no need to auto-assign cluster since the cluster has already assigned";
                this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
                return;
            }
            String targetCluster = this.assignOneCluster(sinkInfo);
            Preconditions.expectNotBlank((String)targetCluster, (String)String.format("find no proper cluster assign to group=%s, stream=%s, sink type=%s, data node=%s ", sinkInfo.getInlongGroupId(), sinkInfo.getInlongStreamId(), sinkInfo.getSinkType(), sinkInfo.getDataNodeName()));
            StreamSinkEntity sink = this.sinkEntityMapper.selectByPrimaryKey(sinkInfo.getId());
            sink.setInlongClusterName(targetCluster);
            sink.setStatus(SinkStatus.CONFIG_SUCCESSFUL.getCode());
            this.sinkEntityMapper.updateByIdSelective(sink);
        }
        catch (Throwable e) {
            String errMsg = "assign standalone cluster failed: " + e.getMessage();
            log.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
    }

    protected void checkTaskAndConsumerGroup(SinkInfo sinkInfo) {
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sinkInfo.getSortConsumerGroup(), sinkInfo.getSortTaskName()})) {
            return;
        }
        StreamSinkEntity sink = this.sinkEntityMapper.selectByPrimaryKey(sinkInfo.getId());
        if (StringUtils.isBlank((CharSequence)sink.getSortConsumerGroup())) {
            sink.setSortConsumerGroup(sink.getDataNodeName());
        }
        if (StringUtils.isBlank((CharSequence)sink.getSortTaskName())) {
            sink.setSortTaskName(sink.getDataNodeName());
        }
        this.sinkEntityMapper.updateByIdSelective(sink);
    }

    private String assignOneCluster(SinkInfo sinkInfo) {
        InlongGroupEntity group = this.groupEntityMapper.selectByGroupId(sinkInfo.getInlongGroupId());
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.assignFromExist(sinkInfo.getDataNodeName(), group.getInlongClusterTag()), this.assignFromRelated(sinkInfo.getSinkType(), group)});
    }

    private String assignFromExist(String dataNodeName, String clusterTag) {
        return this.sinkEntityMapper.selectAssignedCluster(dataNodeName, clusterTag);
    }

    private String assignFromRelated(String sinkType, InlongGroupEntity group) {
        String sortClusterType = SinkType.relatedSortClusterType((String)sinkType);
        if (StringUtils.isBlank((CharSequence)sortClusterType)) {
            log.error("find no relate sort cluster type for sink type={}", (Object)sinkType);
            return null;
        }
        List clusters = this.clusterEntityMapper.selectByKey(group.getInlongClusterTag(), null, sortClusterType);
        return CollectionUtils.isEmpty((Collection)clusters) ? null : ((InlongClusterEntity)clusters.get(this.rand.nextInt(clusters.size()))).getName();
    }
}

