/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.sqlserver;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerColumnInfo;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerTableInfo;
import org.apache.inlong.manager.service.resource.sink.sqlserver.SQLServerSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerJdbcUtils {
    private static final String SQLSERVER_JDBC_PREFIX = "jdbc:sqlserver";
    private static final String SQLSERVER_DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final Logger LOG = LoggerFactory.getLogger(SQLServerJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        Connection conn;
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(SQLSERVER_JDBC_PREFIX)) {
            throw new Exception("SQLServer server URL was invalid, it should start with jdbc:sqlserver");
        }
        try {
            Class.forName(SQLSERVER_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "get SQLServer connection error, please check SQLServer JDBC url, username or password!";
            LOG.error("get SQLServer connection error, please check SQLServer JDBC url, username or password!", (Throwable)e);
            throw new Exception("get SQLServer connection error, please check SQLServer JDBC url, username or password! other error msg: " + e.getMessage());
        }
        if (conn == null) {
            throw new Exception("get SQLServer connection failed, please contact administrator.");
        }
        LOG.info("get SQLServer connection success, url={}", (Object)url);
        return conn;
    }

    public static void executeSql(Connection conn, String sql) throws Exception {
        conn.setAutoCommit(true);
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOG.info("execute sql [{}] success", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
        }
        finally {
            conn.setAutoCommit(true);
        }
        LOG.info("execute sql [{}] success", sqls);
    }

    public static void createSchema(Connection conn, String schemaName) throws Exception {
        if (!SQLServerJdbcUtils.checkSchemaExist(conn, schemaName)) {
            String createSql = SQLServerSqlBuilder.buildCreateSchemaSql(schemaName);
            SQLServerJdbcUtils.executeSql(conn, createSql);
            LOG.info("execute sql [{}] success", (Object)createSql);
        } else {
            LOG.info("The schemaName [{}] are exists", (Object)schemaName);
        }
    }

    public static void createTable(Connection conn, SQLServerTableInfo tableInfo) throws Exception {
        if (SQLServerJdbcUtils.checkTablesExist(conn, tableInfo.getSchemaName(), tableInfo.getTableName())) {
            LOG.info("The table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            List<String> createTableSqls = SQLServerSqlBuilder.buildCreateTableSql(tableInfo);
            SQLServerJdbcUtils.executeSqlBatch(conn, createTableSqls);
            LOG.info("execute sql [{}] success", createTableSqls);
        }
    }

    public static boolean checkTablesExist(Connection conn, String schemaName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = SQLServerSqlBuilder.getCheckTable(schemaName, tableName);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkTableSql);){
            int count;
            if (null != resultSet && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check table exist for schema={} table={}, result={}", new Object[]{schemaName, tableName, result});
        return result;
    }

    public static boolean checkSchemaExist(Connection conn, String schemaName) throws Exception {
        boolean result = false;
        String checkSchemaSql = SQLServerSqlBuilder.getCheckSchema(schemaName);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkSchemaSql);){
            int count;
            if (null != resultSet && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check schema exist for schemaName={}, result={}", (Object)schemaName, (Object)result);
        return result;
    }

    public static boolean checkColumnExist(Connection conn, String schemaName, String tableName, String column) throws Exception {
        boolean result = false;
        String checkTableSql = SQLServerSqlBuilder.getCheckColumn(schemaName, tableName, column);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkTableSql);){
            int count;
            if (null != resultSet && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check column exist for schema={} table={}, result={} column={}", new Object[]{schemaName, tableName, result, column});
        return result;
    }

    public static List<SQLServerColumnInfo> getColumns(Connection conn, String schemaName, String tableName) throws Exception {
        String querySql = SQLServerSqlBuilder.buildDescTableSql(schemaName, tableName);
        ArrayList<SQLServerColumnInfo> columnList = new ArrayList<SQLServerColumnInfo>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(querySql);){
            while (rs.next()) {
                SQLServerColumnInfo columnInfo = new SQLServerColumnInfo();
                columnInfo.setName(rs.getString(1));
                columnInfo.setType(rs.getString(2));
                columnInfo.setComment(rs.getString(3));
                columnList.add(columnInfo);
            }
        }
        return columnList;
    }

    public static void addColumns(Connection conn, String schemaName, String tableName, List<SQLServerColumnInfo> columns) throws Exception {
        ArrayList columnInfos = Lists.newArrayList();
        for (SQLServerColumnInfo columnInfo : columns) {
            if (SQLServerJdbcUtils.checkColumnExist(conn, schemaName, tableName, columnInfo.getName())) continue;
            columnInfos.add(columnInfo);
        }
        SQLServerJdbcUtils.executeSqlBatch(conn, SQLServerSqlBuilder.buildAddColumnsSql(schemaName, tableName, columnInfos));
    }
}

