/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.oceanbase;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.pojo.node.oceanbase.OceanBaseDataNodeInfo;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.oceanbase.OceanBaseBinlogSource;
import org.apache.inlong.manager.pojo.source.oceanbase.OceanBaseBinlogSourceDTO;
import org.apache.inlong.manager.pojo.source.oceanbase.OceanBaseBinlogSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OceanBaseSourceOperator
extends AbstractSourceOperator {
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "OCEANBASE".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "OCEANBASE";
    }

    @Override
    public String getExtParams(StreamSourceEntity sourceEntity) {
        OceanBaseBinlogSourceDTO OceanBaseBinlogSourceDTO2 = (OceanBaseBinlogSourceDTO)JsonUtils.parseObject((String)sourceEntity.getExtParams(), OceanBaseBinlogSourceDTO.class);
        if (Objects.nonNull(OceanBaseBinlogSourceDTO2) && StringUtils.isBlank((CharSequence)OceanBaseBinlogSourceDTO2.getHostname())) {
            OceanBaseDataNodeInfo dataNodeInfo = (OceanBaseDataNodeInfo)this.dataNodeService.get(sourceEntity.getDataNodeName(), "OCEANBASE");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)OceanBaseBinlogSourceDTO2, (boolean)true);
            OceanBaseBinlogSourceDTO2.setPassword(dataNodeInfo.getToken());
            OceanBaseBinlogSourceDTO2.setHostname(dataNodeInfo.getUrl().split(":")[0]);
            OceanBaseBinlogSourceDTO2.setPort(Integer.valueOf(dataNodeInfo.getUrl().split(":")[1]));
            return JsonUtils.toJsonString((Object)OceanBaseBinlogSourceDTO2);
        }
        return sourceEntity.getExtParams();
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        OceanBaseBinlogSourceRequest sourceRequest = (OceanBaseBinlogSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            OceanBaseBinlogSourceDTO dto = OceanBaseBinlogSourceDTO.getFromRequest((OceanBaseBinlogSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of OceanBaseBinlog SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        OceanBaseBinlogSource source = new OceanBaseBinlogSource();
        if (entity == null) {
            return source;
        }
        OceanBaseBinlogSourceDTO dto = OceanBaseBinlogSourceDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getHostname())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, "OceanBase url and data node is blank");
            }
            OceanBaseDataNodeInfo dataNodeInfo = (OceanBaseDataNodeInfo)this.dataNodeService.get(entity.getDataNodeName(), "OCEANBASE");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
            dto.setPassword(dataNodeInfo.getToken());
            dto.setHostname(dataNodeInfo.getUrl().split(":")[0]);
            dto.setPort(Integer.valueOf(dataNodeInfo.getUrl().split(":")[1]));
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }
}

