/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;

public enum FieldType {
    INT,
    INTEGER,
    TINYINT,
    SMALLINT,
    BIGINT,
    SHORT,
    LONG,
    DOUBLE,
    FLOAT,
    DECIMAL,
    STRING,
    TEXT,
    FIXED,
    BYTE,
    BINARY,
    CHAR,
    VARCHAR,
    VARBINARY,
    BOOLEAN,
    DATE,
    TIME,
    INT8,
    INT16,
    INT32,
    INT64,
    FLOAT4,
    FLOAT8,
    FLOAT32,
    FLOAT64,
    DATETIME,
    TIMESTAMP,
    TIMESTAMPTZ,
    LOCAL_ZONE_TIMESTAMP,
    ARRAY,
    MAP,
    STRUCT,
    FUNCTION,
    KEYWORD,
    LARGEINT,
    JSON;


    public static FieldType forName(String name) {
        Preconditions.expectNotBlank(name, ErrorCodeEnum.INVALID_PARAMETER, "FieldType should not be null");
        for (FieldType value : FieldType.values()) {
            if (!value.toString().equalsIgnoreCase(name)) continue;
            return value;
        }
        throw new IllegalArgumentException(String.format("Unsupported FieldType : %s", name));
    }

    public String toString() {
        return this.name();
    }
}

