/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.security.AccessController;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateUtils;
import org.joda.time.DateTime;

public class JodaCompatibleZonedDateTime {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(JodaCompatibleZonedDateTime.class));
    private static final DateFormatter DATE_FORMATTER = DateFormatters.forPattern("strict_date_time");
    private ZonedDateTime dt;

    private static void logDeprecated(String key, String message, Object ... params) {
        AccessController.doPrivileged(() -> {
            DEPRECATION_LOGGER.deprecatedAndMaybeLog(key, message, params);
            return null;
        });
    }

    private static void logDeprecatedMethod(String oldMethod, String newMethod) {
        JodaCompatibleZonedDateTime.logDeprecated(oldMethod, "Use of the joda time method [{}] is deprecated. Use [{}] instead.", oldMethod, newMethod);
    }

    public JodaCompatibleZonedDateTime(Instant instant, ZoneId zone) {
        this.dt = ZonedDateTime.ofInstant(instant, zone);
    }

    public ZonedDateTime getZonedDateTime() {
        return this.dt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JodaCompatibleZonedDateTime that = (JodaCompatibleZonedDateTime)o;
        return Objects.equals(this.dt, that.dt);
    }

    public int hashCode() {
        return Objects.hash(this.dt);
    }

    public String toString() {
        return DATE_FORMATTER.format(this.dt);
    }

    public boolean isAfter(JodaCompatibleZonedDateTime o) {
        return this.dt.isAfter(o.getZonedDateTime());
    }

    public boolean isBefore(JodaCompatibleZonedDateTime o) {
        return this.dt.isBefore(o.getZonedDateTime());
    }

    public boolean isEqual(JodaCompatibleZonedDateTime o) {
        return this.dt.isEqual(o.getZonedDateTime());
    }

    public int getDayOfMonth() {
        return this.dt.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dt.getDayOfYear();
    }

    public int getHour() {
        return this.dt.getHour();
    }

    public LocalDate toLocalDate() {
        return this.dt.toLocalDate();
    }

    public LocalDateTime toLocalDateTime() {
        return this.dt.toLocalDateTime();
    }

    public int getMinute() {
        return this.dt.getMinute();
    }

    public Month getMonth() {
        return this.dt.getMonth();
    }

    public int getMonthValue() {
        return this.dt.getMonthValue();
    }

    public int getNano() {
        return this.dt.getNano();
    }

    public int getSecond() {
        return this.dt.getSecond();
    }

    public int getYear() {
        return this.dt.getYear();
    }

    public ZoneId getZone() {
        return this.dt.getZone();
    }

    public ZonedDateTime minus(TemporalAmount delta) {
        return this.dt.minus(delta);
    }

    public ZonedDateTime minus(long amount, TemporalUnit unit) {
        return this.dt.minus(amount, unit);
    }

    public ZonedDateTime minusYears(long amount) {
        return this.dt.minusYears(amount);
    }

    public ZonedDateTime minusMonths(long amount) {
        return this.dt.minusMonths(amount);
    }

    public ZonedDateTime minusWeeks(long amount) {
        return this.dt.minusWeeks(amount);
    }

    public ZonedDateTime minusDays(long amount) {
        return this.dt.minusDays(amount);
    }

    public ZonedDateTime minusHours(long amount) {
        return this.dt.minusHours(amount);
    }

    public ZonedDateTime minusMinutes(long amount) {
        return this.dt.minusMinutes(amount);
    }

    public ZonedDateTime minusSeconds(long amount) {
        return this.dt.minusSeconds(amount);
    }

    public ZonedDateTime minusNanos(long amount) {
        return this.dt.minusNanos(amount);
    }

    public ZonedDateTime plus(TemporalAmount amount) {
        return this.dt.plus(amount);
    }

    public ZonedDateTime plus(long amount, TemporalUnit unit) {
        return this.dt.plus(amount, unit);
    }

    public ZonedDateTime plusDays(long amount) {
        return this.dt.plusDays(amount);
    }

    public ZonedDateTime plusHours(long amount) {
        return this.dt.plusHours(amount);
    }

    public ZonedDateTime plusMinutes(long amount) {
        return this.dt.plusMinutes(amount);
    }

    public ZonedDateTime plusMonths(long amount) {
        return this.dt.plusMonths(amount);
    }

    public ZonedDateTime plusNanos(long amount) {
        return this.dt.plusNanos(amount);
    }

    public ZonedDateTime plusSeconds(long amount) {
        return this.dt.plusSeconds(amount);
    }

    public ZonedDateTime plusWeeks(long amount) {
        return this.dt.plusWeeks(amount);
    }

    public ZonedDateTime plusYears(long amount) {
        return this.dt.plusYears(amount);
    }

    public Instant toInstant() {
        return this.dt.toInstant();
    }

    public OffsetDateTime toOffsetDateTime() {
        return this.dt.toOffsetDateTime();
    }

    @SuppressForbidden(reason="only exposing the method as a passthrough")
    public ZonedDateTime truncatedTo(TemporalUnit unit) {
        return this.dt.truncatedTo(unit);
    }

    public ZonedDateTime with(TemporalAdjuster adjuster) {
        return this.dt.with(adjuster);
    }

    public ZonedDateTime with(TemporalField field, long newValue) {
        return this.dt.with(field, newValue);
    }

    public ZonedDateTime withDayOfMonth(int value) {
        return this.dt.withDayOfMonth(value);
    }

    public ZonedDateTime withDayOfYear(int value) {
        return this.dt.withDayOfYear(value);
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        return this.dt.withEarlierOffsetAtOverlap();
    }

    public ZonedDateTime withFixedOffsetZone() {
        return this.dt.withFixedOffsetZone();
    }

    public ZonedDateTime withHour(int value) {
        return this.dt.withHour(value);
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        return this.dt.withLaterOffsetAtOverlap();
    }

    public ZonedDateTime withMinute(int value) {
        return this.dt.withMinute(value);
    }

    public ZonedDateTime withMonth(int value) {
        return this.dt.withMonth(value);
    }

    public ZonedDateTime withNano(int value) {
        return this.dt.withNano(value);
    }

    public ZonedDateTime withSecond(int value) {
        return this.dt.withSecond(value);
    }

    public ZonedDateTime withYear(int value) {
        return this.dt.withYear(value);
    }

    public ZonedDateTime withZoneSameLocal(ZoneId zone) {
        return this.dt.withZoneSameLocal(zone);
    }

    public ZonedDateTime withZoneSameInstant(ZoneId zone) {
        return this.dt.withZoneSameInstant(zone);
    }

    @Deprecated
    public long getMillis() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMillis()", "toInstant().toEpochMilli()");
        return this.dt.toInstant().toEpochMilli();
    }

    @Deprecated
    public int getCenturyOfEra() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getCenturyOfEra()", "get(ChronoField.YEAR_OF_ERA) / 100");
        return this.dt.get(ChronoField.YEAR_OF_ERA) / 100;
    }

    @Deprecated
    public int getEra() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getEra()", "get(ChronoField.ERA)");
        return this.dt.get(ChronoField.ERA);
    }

    @Deprecated
    public int getHourOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getHourOfDay()", "getHour()");
        return this.dt.getHour();
    }

    @Deprecated
    public int getMillisOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMillisOfDay()", "get(ChronoField.MILLI_OF_DAY)");
        return this.dt.get(ChronoField.MILLI_OF_DAY);
    }

    @Deprecated
    public int getMillisOfSecond() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMillisOfSecond()", "get(ChronoField.MILLI_OF_SECOND)");
        return this.dt.get(ChronoField.MILLI_OF_SECOND);
    }

    @Deprecated
    public int getMinuteOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMinuteOfDay()", "get(ChronoField.MINUTE_OF_DAY)");
        return this.dt.get(ChronoField.MINUTE_OF_DAY);
    }

    @Deprecated
    public int getMinuteOfHour() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMinuteOfHour()", "getMinute()");
        return this.dt.getMinute();
    }

    @Deprecated
    public int getMonthOfYear() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getMonthOfYear()", "getMonthValue()");
        return this.dt.getMonthValue();
    }

    @Deprecated
    public int getSecondOfDay() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getSecondOfDay()", "get(ChronoField.SECOND_OF_DAY)");
        return this.dt.get(ChronoField.SECOND_OF_DAY);
    }

    @Deprecated
    public int getSecondOfMinute() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getSecondOfMinute()", "getSecond()");
        return this.dt.getSecond();
    }

    @Deprecated
    public int getWeekOfWeekyear() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getWeekOfWeekyear()", "get(WeekFields.ISO.weekOfWeekBasedYear())");
        return this.dt.get(WeekFields.ISO.weekOfWeekBasedYear());
    }

    @Deprecated
    public int getWeekyear() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getWeekyear()", "get(WeekFields.ISO.weekBasedYear())");
        return this.dt.get(WeekFields.ISO.weekBasedYear());
    }

    @Deprecated
    public int getYearOfCentury() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getYearOfCentury()", "get(ChronoField.YEAR_OF_ERA) % 100");
        return this.dt.get(ChronoField.YEAR_OF_ERA) % 100;
    }

    @Deprecated
    public int getYearOfEra() {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("getYearOfEra()", "get(ChronoField.YEAR_OF_ERA)");
        return this.dt.get(ChronoField.YEAR_OF_ERA);
    }

    @Deprecated
    public String toString(String format) {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("toString(String)", "a DateTimeFormatter");
        return new DateTime(this.dt.toInstant().toEpochMilli(), DateUtils.zoneIdToDateTimeZone(this.dt.getZone())).toString(format);
    }

    @Deprecated
    public String toString(String format, Locale locale) {
        JodaCompatibleZonedDateTime.logDeprecatedMethod("toString(String,Locale)", "a DateTimeFormatter");
        return new DateTime(this.dt.toInstant().toEpochMilli(), DateUtils.zoneIdToDateTimeZone(this.dt.getZone())).toString(format, locale);
    }

    public DayOfWeek getDayOfWeekEnum() {
        return this.dt.getDayOfWeek();
    }

    @Deprecated
    public int getDayOfWeek() {
        JodaCompatibleZonedDateTime.logDeprecated("getDayOfWeek()", "The return type of [getDayOfWeek()] will change to an enum in 7.0. Use getDayOfWeekEnum().getValue().", new Object[0]);
        return this.dt.getDayOfWeek().getValue();
    }
}

