/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazy.LazyBoolean;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.lazy.LazyDouble;
import org.apache.hadoop.hive.serde2.lazy.LazyFloat;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveChar;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveDecimal;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveIntervalDayTime;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.lazy.LazyHiveVarchar;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.LazyUnion;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUnion;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObject;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class VerifyLazy {
    public static boolean lazyCompareList(ListTypeInfo listTypeInfo, List<Object> list, List<Object> expectedList) {
        TypeInfo elementTypeInfo = listTypeInfo.getListElementTypeInfo();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object expectedEleObj;
            Object lazyEleObj = list.get(i);
            if (VerifyLazy.lazyCompare(elementTypeInfo, lazyEleObj, expectedEleObj = expectedList.get(i))) continue;
            throw new RuntimeException("List element deserialized value does not match elementTypeInfo " + elementTypeInfo.toString());
        }
        return true;
    }

    public static boolean lazyCompareMap(MapTypeInfo mapTypeInfo, Map<Object, Object> map, Map<Object, Object> expectedMap) {
        TypeInfo keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
        if (map.size() != expectedMap.size()) {
            throw new RuntimeException("Map key/value deserialized map.size() " + map.size() + " map " + map.toString() + " expectedMap.size() " + expectedMap.size() + " expectedMap " + expectedMap.toString() + " does not match keyTypeInfo " + keyTypeInfo.toString() + " valueTypeInfo " + valueTypeInfo.toString());
        }
        return true;
    }

    public static boolean lazyCompareStruct(StructTypeInfo structTypeInfo, List<Object> fields, List<Object> expectedFields) {
        ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
        int size = fieldTypeInfos.size();
        for (int i = 0; i < size; ++i) {
            Object lazyEleObj = fields.get(i);
            Object expectedEleObj = expectedFields.get(i);
            if (VerifyLazy.lazyCompare(fieldTypeInfos.get(i), lazyEleObj, expectedEleObj)) continue;
            throw new RuntimeException("SerDe deserialized value does not match");
        }
        return true;
    }

    public static boolean lazyCompareUnion(UnionTypeInfo unionTypeInfo, LazyBinaryUnion union, UnionObject expectedUnion) {
        byte expectedTag;
        byte tag = union.getTag();
        if (tag != (expectedTag = expectedUnion.getTag())) {
            throw new RuntimeException("Union tag does not match union.getTag() " + tag + " expectedUnion.getTag() " + expectedTag);
        }
        return VerifyLazy.lazyCompare(unionTypeInfo.getAllUnionObjectTypeInfos().get(tag), union.getField(), expectedUnion.getObject());
    }

    public static boolean lazyCompareUnion(UnionTypeInfo unionTypeInfo, LazyUnion union, UnionObject expectedUnion) {
        byte expectedTag;
        byte tag = union.getTag();
        if (tag != (expectedTag = expectedUnion.getTag())) {
            throw new RuntimeException("Union tag does not match union.getTag() " + tag + " expectedUnion.getTag() " + expectedTag);
        }
        return VerifyLazy.lazyCompare(unionTypeInfo.getAllUnionObjectTypeInfos().get(tag), union.getField(), expectedUnion.getObject());
    }

    public static boolean lazyCompareUnion(UnionTypeInfo unionTypeInfo, UnionObject union, UnionObject expectedUnion) {
        byte expectedTag;
        byte tag = union.getTag();
        if (tag != (expectedTag = expectedUnion.getTag())) {
            throw new RuntimeException("Union tag does not match union.getTag() " + tag + " expectedUnion.getTag() " + expectedTag);
        }
        return VerifyLazy.lazyCompare(unionTypeInfo.getAllUnionObjectTypeInfos().get(tag), union.getObject(), expectedUnion.getObject());
    }

    public static boolean lazyCompare(TypeInfo typeInfo, Object lazyObject, Object expectedObject) {
        block68: {
            block67: {
                if (expectedObject == null) {
                    if (lazyObject != null) {
                        throw new RuntimeException("Expected object is null but object is not null " + lazyObject.toString() + " typeInfo " + typeInfo.toString());
                    }
                    return true;
                }
                if (lazyObject == null) {
                    throw new RuntimeException("Expected object is not null \"" + expectedObject.toString() + "\" typeInfo " + typeInfo.toString() + " but object is null");
                }
                if (lazyObject instanceof Writable) {
                    if (!lazyObject.equals(expectedObject)) {
                        throw new RuntimeException("Expected object " + expectedObject.toString() + " and actual object " + lazyObject.toString() + " is not equal typeInfo " + typeInfo.toString());
                    }
                    return true;
                }
                if (!(lazyObject instanceof LazyPrimitive)) break block67;
                Object primitiveObject = ((LazyPrimitive)lazyObject).getObject();
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        boolean expected;
                        if (!(primitiveObject instanceof LazyBoolean)) {
                            throw new RuntimeException("Expected LazyBoolean");
                        }
                        boolean value = ((BooleanWritable)((LazyBoolean)primitiveObject).getWritableObject()).get();
                        if (value != (expected = ((BooleanWritable)expectedObject).get())) {
                            throw new RuntimeException("Boolean field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case BYTE: {
                        byte expected;
                        if (!(primitiveObject instanceof LazyByte)) {
                            throw new RuntimeException("Expected LazyByte");
                        }
                        byte value = ((ByteWritable)((Object)((LazyByte)primitiveObject).getWritableObject())).get();
                        if (value != (expected = ((ByteWritable)((Object)expectedObject)).get())) {
                            throw new RuntimeException("Byte field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case SHORT: {
                        short expected;
                        if (!(primitiveObject instanceof LazyShort)) {
                            throw new RuntimeException("Expected LazyShort");
                        }
                        short value = ((ShortWritable)((LazyShort)primitiveObject).getWritableObject()).get();
                        if (value != (expected = ((ShortWritable)expectedObject).get())) {
                            throw new RuntimeException("Short field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case INT: {
                        int expected;
                        if (!(primitiveObject instanceof LazyInteger)) {
                            throw new RuntimeException("Expected LazyInteger");
                        }
                        int value = ((IntWritable)((LazyInteger)primitiveObject).getWritableObject()).get();
                        if (value != (expected = ((IntWritable)expectedObject).get())) {
                            throw new RuntimeException("Int field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case LONG: {
                        long expected;
                        if (!(primitiveObject instanceof LazyLong)) {
                            throw new RuntimeException("Expected LazyLong");
                        }
                        long value = ((LongWritable)((LazyLong)primitiveObject).getWritableObject()).get();
                        if (value != (expected = ((LongWritable)expectedObject).get())) {
                            throw new RuntimeException("Long field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case FLOAT: {
                        float expected;
                        if (!(primitiveObject instanceof LazyFloat)) {
                            throw new RuntimeException("Expected LazyFloat");
                        }
                        float value = ((FloatWritable)((LazyFloat)primitiveObject).getWritableObject()).get();
                        if (value != (expected = ((FloatWritable)expectedObject).get())) {
                            throw new RuntimeException("Float field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case DOUBLE: {
                        double expected;
                        if (!(primitiveObject instanceof LazyDouble)) {
                            throw new RuntimeException("Expected LazyDouble");
                        }
                        double value = ((DoubleWritable)((Object)((LazyDouble)primitiveObject).getWritableObject())).get();
                        if (value != (expected = ((DoubleWritable)((Object)expectedObject)).get())) {
                            throw new RuntimeException("Double field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case STRING: {
                        Text expected;
                        if (!(primitiveObject instanceof LazyString)) {
                            throw new RuntimeException("Text expected writable not Text");
                        }
                        Text value = (Text)((LazyString)primitiveObject).getWritableObject();
                        if (!value.equals((Object)(expected = (Text)expectedObject))) {
                            throw new RuntimeException("String field mismatch (expected '" + expected + "' found '" + value + "')");
                        }
                        break block68;
                    }
                    case CHAR: {
                        HiveChar expected;
                        if (!(primitiveObject instanceof LazyHiveChar)) {
                            throw new RuntimeException("Expected LazyHiveChar");
                        }
                        HiveChar value = ((HiveCharWritable)((LazyHiveChar)primitiveObject).getWritableObject()).getHiveChar();
                        if (!value.equals((Object)(expected = ((HiveCharWritable)expectedObject).getHiveChar()))) {
                            throw new RuntimeException("HiveChar field mismatch (expected '" + expected + "' found '" + value + "')");
                        }
                        break block68;
                    }
                    case VARCHAR: {
                        HiveVarchar expected;
                        if (!(primitiveObject instanceof LazyHiveVarchar)) {
                            throw new RuntimeException("Expected LazyHiveVarchar");
                        }
                        HiveVarchar value = ((HiveVarcharWritable)((LazyHiveVarchar)primitiveObject).getWritableObject()).getHiveVarchar();
                        if (!value.equals((Object)(expected = ((HiveVarcharWritable)expectedObject).getHiveVarchar()))) {
                            throw new RuntimeException("HiveVarchar field mismatch (expected '" + expected + "' found '" + value + "')");
                        }
                        break block68;
                    }
                    case DECIMAL: {
                        HiveDecimal expected;
                        if (!(primitiveObject instanceof LazyHiveDecimal)) {
                            throw new RuntimeException("Expected LazyDecimal");
                        }
                        HiveDecimal value = ((LazyHiveDecimal)primitiveObject).getWritableObject().getHiveDecimal();
                        if (!value.equals((Object)(expected = ((HiveDecimalWritable)expectedObject).getHiveDecimal()))) {
                            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                            int precision = decimalTypeInfo.getPrecision();
                            int scale = decimalTypeInfo.getScale();
                            throw new RuntimeException("Decimal field mismatch (expected " + expected.toString() + " found " + value.toString() + ") precision " + precision + ", scale " + scale);
                        }
                        break block68;
                    }
                    case DATE: {
                        Date expected;
                        if (!(primitiveObject instanceof LazyDate)) {
                            throw new RuntimeException("Expected LazyDate");
                        }
                        Date value = ((DateWritableV2)((LazyDate)primitiveObject).getWritableObject()).get();
                        if (!value.equals((Object)(expected = ((DateWritableV2)expectedObject).get()))) {
                            throw new RuntimeException("Date field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case TIMESTAMP: {
                        Timestamp expected;
                        if (!(primitiveObject instanceof LazyTimestamp)) {
                            throw new RuntimeException("TimestampWritableV2 expected writable not TimestampWritableV2");
                        }
                        Timestamp value = ((LazyTimestamp)primitiveObject).getWritableObject().getTimestamp();
                        if (!value.equals((Object)(expected = ((TimestampWritableV2)expectedObject).getTimestamp()))) {
                            throw new RuntimeException("Timestamp field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        HiveIntervalYearMonth expected;
                        if (!(primitiveObject instanceof LazyHiveIntervalYearMonth)) {
                            throw new RuntimeException("Expected LazyHiveIntervalYearMonth");
                        }
                        HiveIntervalYearMonth value = ((LazyHiveIntervalYearMonth)primitiveObject).getWritableObject().getHiveIntervalYearMonth();
                        if (!value.equals((Object)(expected = ((HiveIntervalYearMonthWritable)expectedObject).getHiveIntervalYearMonth()))) {
                            throw new RuntimeException("HiveIntervalYearMonth field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case INTERVAL_DAY_TIME: {
                        HiveIntervalDayTime expected;
                        if (!(primitiveObject instanceof LazyHiveIntervalDayTime)) {
                            throw new RuntimeException("Expected writable LazyHiveIntervalDayTime");
                        }
                        HiveIntervalDayTime value = ((LazyHiveIntervalDayTime)primitiveObject).getWritableObject().getHiveIntervalDayTime();
                        if (!value.equals((Object)(expected = ((HiveIntervalDayTimeWritable)expectedObject).getHiveIntervalDayTime()))) {
                            throw new RuntimeException("HiveIntervalDayTime field mismatch (expected " + expected + " found " + value + ")");
                        }
                        break block68;
                    }
                    case BINARY: {
                        BytesWritable bytesWritableExpected;
                        byte[] expected;
                        if (!(primitiveObject instanceof LazyBinary)) {
                            throw new RuntimeException("Expected LazyBinary");
                        }
                        BytesWritable bytesWritable = (BytesWritable)((LazyBinary)primitiveObject).getWritableObject();
                        byte[] value = Arrays.copyOfRange(bytesWritable.getBytes(), 0, bytesWritable.getLength());
                        if (value.length != (expected = Arrays.copyOfRange((bytesWritableExpected = (BytesWritable)expectedObject).getBytes(), 0, bytesWritableExpected.getLength())).length) {
                            throw new RuntimeException("Byte Array field mismatch (expected " + Arrays.toString(expected) + " found " + Arrays.toString(value) + ")");
                        }
                        for (int b = 0; b < value.length; ++b) {
                            if (value[b] == expected[b]) continue;
                            throw new RuntimeException("Byte Array field mismatch (expected " + Arrays.toString(expected) + " found " + Arrays.toString(value) + ")");
                        }
                        break block68;
                    }
                    default: {
                        throw new Error("Unknown primitive category " + (Object)((Object)primitiveTypeInfo.getPrimitiveCategory()));
                    }
                }
            }
            if (lazyObject instanceof LazyArray) {
                LazyArray lazyArray = (LazyArray)lazyObject;
                List<Object> list = lazyArray.getList();
                List expectedList = (List)expectedObject;
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                if (list.size() != expectedList.size()) {
                    throw new RuntimeException("SerDe deserialized list length does not match (list " + list.toString() + " list.size() " + list.size() + " expectedList " + expectedList.toString() + " expectedList.size() " + expectedList.size() + ") elementTypeInfo " + listTypeInfo.getListElementTypeInfo().toString());
                }
                return VerifyLazy.lazyCompareList((ListTypeInfo)typeInfo, list, expectedList);
            }
            if (typeInfo instanceof ListTypeInfo) {
                List<Object> list = lazyObject instanceof LazyBinaryArray ? ((LazyBinaryArray)lazyObject).getList() : (List<Object>)lazyObject;
                List expectedList = (List)expectedObject;
                if (list.size() != expectedList.size()) {
                    throw new RuntimeException("SerDe deserialized list length does not match (list " + list.toString() + " list.size() " + list.size() + " expectedList " + expectedList.toString() + " expectedList.size() " + expectedList.size() + ")");
                }
                return VerifyLazy.lazyCompareList((ListTypeInfo)typeInfo, list, expectedList);
            }
            if (lazyObject instanceof LazyMap) {
                LazyMap lazyMap = (LazyMap)lazyObject;
                Map<Object, Object> map = lazyMap.getMap();
                Map expectedMap = (Map)expectedObject;
                return VerifyLazy.lazyCompareMap((MapTypeInfo)typeInfo, map, expectedMap);
            }
            if (typeInfo instanceof MapTypeInfo) {
                Map expectedMap = (Map)expectedObject;
                Map<Object, Object> map = lazyObject instanceof LazyBinaryMap ? ((LazyBinaryMap)lazyObject).getMap() : (Map<Object, Object>)lazyObject;
                return VerifyLazy.lazyCompareMap((MapTypeInfo)typeInfo, map, expectedMap);
            }
            if (lazyObject instanceof LazyStruct) {
                LazyStruct lazyStruct = (LazyStruct)lazyObject;
                List<Object> fields = lazyStruct.getFieldsAsList();
                List expectedFields = (List)expectedObject;
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                return VerifyLazy.lazyCompareStruct(structTypeInfo, fields, expectedFields);
            }
            if (typeInfo instanceof StructTypeInfo) {
                List fields = lazyObject instanceof LazyBinaryStruct ? ((LazyBinaryStruct)lazyObject).getFieldsAsList() : (ArrayList)lazyObject;
                List expectedFields = (List)expectedObject;
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                return VerifyLazy.lazyCompareStruct(structTypeInfo, fields, expectedFields);
            }
            if (lazyObject instanceof LazyUnion) {
                LazyUnion union = (LazyUnion)lazyObject;
                StandardUnionObjectInspector.StandardUnion expectedUnion = (StandardUnionObjectInspector.StandardUnion)expectedObject;
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                return VerifyLazy.lazyCompareUnion(unionTypeInfo, union, (UnionObject)expectedUnion);
            }
            if (typeInfo instanceof UnionTypeInfo) {
                StandardUnionObjectInspector.StandardUnion expectedUnion = (StandardUnionObjectInspector.StandardUnion)expectedObject;
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                if (lazyObject instanceof LazyBinaryUnion) {
                    return VerifyLazy.lazyCompareUnion(unionTypeInfo, (LazyBinaryUnion)lazyObject, (UnionObject)expectedUnion);
                }
                return VerifyLazy.lazyCompareUnion(unionTypeInfo, (UnionObject)lazyObject, (UnionObject)expectedUnion);
            }
            System.err.println("Not implemented " + typeInfo.getClass().getName());
        }
        return true;
    }
}

