/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.ByBox;
import com.moilioncircle.redis.replicator.cmd.impl.ByRadius;
import com.moilioncircle.redis.replicator.cmd.impl.Count;
import com.moilioncircle.redis.replicator.cmd.impl.FromLonLat;
import com.moilioncircle.redis.replicator.cmd.impl.FromMember;
import com.moilioncircle.redis.replicator.cmd.impl.GeoSearchStoreCommand;
import com.moilioncircle.redis.replicator.cmd.impl.OrderType;
import com.moilioncircle.redis.replicator.cmd.impl.UnitType;
import com.moilioncircle.redis.replicator.util.Strings;

public class GeoSearchStoreParser
implements CommandParser<GeoSearchStoreCommand> {
    @Override
    public GeoSearchStoreCommand parse(Object[] command) {
        int idx = 1;
        byte[] destination = CommandParsers.toBytes(command[idx++]);
        byte[] source = CommandParsers.toBytes(command[idx++]);
        boolean withCoord = false;
        boolean withDist = false;
        boolean withHash = false;
        boolean storeDist = false;
        FromMember fromMember = null;
        FromLonLat fromLonLat = null;
        ByRadius byRadius = null;
        ByBox byBox = null;
        OrderType orderType = OrderType.NONE;
        Count count = null;
        for (int i = idx; i < command.length; ++i) {
            String token = CommandParsers.toRune(command[i]);
            if (Strings.isEquals(token, "FROMMEMBER")) {
                fromMember = new FromMember(CommandParsers.toBytes(command[++i]));
                continue;
            }
            if (Strings.isEquals(token, "FROMLONLAT")) {
                double longitude = CommandParsers.toDouble(command[++i]);
                double latitude = CommandParsers.toDouble(command[++i]);
                fromLonLat = new FromLonLat(longitude, latitude);
                continue;
            }
            if (Strings.isEquals(token, "BYRADIUS")) {
                double radius = CommandParsers.toDouble(command[++i]);
                UnitType unit = this.parseUnit(CommandParsers.toRune(command[++i]));
                byRadius = new ByRadius(radius, unit);
                continue;
            }
            if (Strings.isEquals(token, "BYBOX")) {
                double width = CommandParsers.toDouble(command[++i]);
                double height = CommandParsers.toDouble(command[++i]);
                UnitType unit = this.parseUnit(CommandParsers.toRune(command[++i]));
                byBox = new ByBox(width, height, unit);
                continue;
            }
            if (Strings.isEquals(token, "ASC")) {
                orderType = OrderType.ASC;
                continue;
            }
            if (Strings.isEquals(token, "DESC")) {
                orderType = OrderType.DESC;
                continue;
            }
            if (Strings.isEquals(token, "COUNT")) {
                count = new Count(CommandParsers.toInt(command[++i]));
                continue;
            }
            if (Strings.isEquals(token, "WITHCOORD")) {
                withCoord = true;
                continue;
            }
            if (Strings.isEquals(token, "WITHDIST")) {
                withDist = true;
                continue;
            }
            if (Strings.isEquals(token, "WITHHASH")) {
                withHash = true;
                continue;
            }
            if (Strings.isEquals(token, "STOREDIST")) {
                storeDist = true;
                continue;
            }
            throw new AssertionError((Object)("parse [GEOSEARCHSTORE] command error." + token));
        }
        return new GeoSearchStoreCommand(destination, source, fromMember, fromLonLat, byRadius, byBox, count, orderType, withCoord, withDist, withHash, storeDist);
    }

    private UnitType parseUnit(String token) {
        if (Strings.isEquals(token, "M")) {
            return UnitType.M;
        }
        if (Strings.isEquals(token, "KM")) {
            return UnitType.KM;
        }
        if (Strings.isEquals(token, "FT")) {
            return UnitType.FT;
        }
        if (Strings.isEquals(token, "MI")) {
            return UnitType.MI;
        }
        throw new AssertionError((Object)("parse [GEOSEARCHSTORE] command error." + token));
    }
}

