/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.ScriptCommand;
import com.moilioncircle.redis.replicator.cmd.impl.ScriptFlushCommand;
import com.moilioncircle.redis.replicator.cmd.impl.ScriptLoadCommand;
import com.moilioncircle.redis.replicator.util.Strings;

public class ScriptParser
implements CommandParser<ScriptCommand> {
    @Override
    public ScriptCommand parse(Object[] command) {
        int idx = 1;
        String keyword = CommandParsers.toRune(command[idx++]);
        boolean isAsync = false;
        boolean isSync = false;
        if (Strings.isEquals(keyword, "LOAD")) {
            byte[] script = CommandParsers.toBytes(command[idx]);
            ++idx;
            return new ScriptLoadCommand(script);
        }
        if (Strings.isEquals(keyword, "FLUSH")) {
            if (idx >= command.length) {
                return new ScriptFlushCommand(false, false);
            }
            String value = CommandParsers.toRune(command[idx]);
            if (Strings.isEquals(value, "ASYNC")) {
                isAsync = true;
            } else if (Strings.isEquals(value, "SYNC")) {
                isSync = true;
            }
            return new ScriptFlushCommand(isAsync, isSync);
        }
        throw new AssertionError((Object)("SCRIPT " + keyword));
    }
}

