/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ByteBufferOutputStream() {
        this(32);
    }

    public ByteBufferOutputStream(int size) {
        this.buf = new byte[size];
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void close() throws IOException {
    }

    public void writeBytes(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count);
    }

    private void ensureCapacity(int capacity) {
        if (capacity - this.buf.length > 0) {
            this.grow(capacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteBufferOutputStream.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int capacity) {
        if (capacity < 0) {
            throw new OutOfMemoryError();
        }
        return capacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

