/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.metric.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.metric.Gauge;
import org.apache.inlong.tubemq.corebase.metric.impl.BaseMetric;

public class LongMaxGauge
extends BaseMetric
implements Gauge {
    private final AtomicLong value = new AtomicLong(Long.MIN_VALUE);

    public LongMaxGauge(String metricName, String prefix) {
        super(metricName, prefix);
    }

    @Override
    public void update(long newValue) {
        long cur;
        while (newValue > (cur = this.value.get()) && !this.value.compareAndSet(cur, newValue)) {
        }
    }

    @Override
    public void clear() {
        this.value.set(Long.MIN_VALUE);
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public long getAndResetValue() {
        return this.value.getAndSet(Long.MIN_VALUE);
    }
}

