/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.aftermatch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.aftermatch.NoSkipStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipPastLastStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipToFirstStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipToLastStrategy;
import org.apache.flink.cep.nfa.aftermatch.SkipToNextStrategy;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferAccessor;

public abstract class AfterMatchSkipStrategy
implements Serializable {
    private static final long serialVersionUID = -4048930333619068531L;

    public static SkipToFirstStrategy skipToFirst(String patternName) {
        return new SkipToFirstStrategy(patternName, false);
    }

    public static SkipToLastStrategy skipToLast(String patternName) {
        return new SkipToLastStrategy(patternName, false);
    }

    public static SkipPastLastStrategy skipPastLastEvent() {
        return SkipPastLastStrategy.INSTANCE;
    }

    public static AfterMatchSkipStrategy skipToNext() {
        return SkipToNextStrategy.INSTANCE;
    }

    public static NoSkipStrategy noSkip() {
        return NoSkipStrategy.INSTANCE;
    }

    public abstract boolean isSkipStrategy();

    public void prune(Collection<ComputationState> matchesToPrune, Collection<Map<String, List<EventId>>> matchedResult, SharedBufferAccessor<?> sharedBufferAccessor) throws Exception {
        EventId pruningId = this.getPruningId(matchedResult);
        if (pruningId != null) {
            ArrayList<ComputationState> discardStates = new ArrayList<ComputationState>();
            for (ComputationState computationState : matchesToPrune) {
                if (computationState.getStartEventID() == null || !this.shouldPrune(computationState.getStartEventID(), pruningId)) continue;
                sharedBufferAccessor.releaseNode(computationState.getPreviousBufferEntry(), computationState.getVersion());
                discardStates.add(computationState);
            }
            matchesToPrune.removeAll(discardStates);
        }
    }

    protected abstract boolean shouldPrune(EventId var1, EventId var2);

    protected abstract EventId getPruningId(Collection<Map<String, List<EventId>>> var1);

    public Optional<String> getPatternName() {
        return Optional.empty();
    }

    static EventId max(EventId o1, EventId o2) {
        if (o2 == null) {
            return o1;
        }
        if (o1 == null) {
            return o2;
        }
        if (o1.compareTo(o2) >= 0) {
            return o1;
        }
        return o2;
    }

    static EventId min(EventId o1, EventId o2) {
        if (o2 == null) {
            return o1;
        }
        if (o1 == null) {
            return o2;
        }
        if (o1.compareTo(o2) <= 0) {
            return o1;
        }
        return o2;
    }

    AfterMatchSkipStrategy() {
    }
}

