/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class DefaultVFS
extends VFS {
    private static final Log log = LogFactory.getLog(DefaultVFS.class);
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};

    @Override
    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list(URL url, String path) throws IOException {
        InputStream is = null;
        try {
            ArrayList<String> resources = new ArrayList();
            URL jarUrl = this.findJarForResource(url);
            if (jarUrl != null) {
                is = jarUrl.openStream();
                if (log.isDebugEnabled()) {
                    log.debug("Listing " + url);
                }
                resources = this.listResources(new JarInputStream(is), path);
            } else {
                List<Object> children;
                block51: {
                    children = new ArrayList();
                    try {
                        if (this.isJar(url)) {
                            is = url.openStream();
                            JarInputStream jarInput = new JarInputStream(is);
                            Object object = null;
                            try {
                                JarEntry jarEntry;
                                if (log.isDebugEnabled()) {
                                    log.debug("Listing " + url);
                                }
                                while ((jarEntry = jarInput.getNextJarEntry()) != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Jar entry: " + jarEntry.getName());
                                    }
                                    children.add(jarEntry.getName());
                                }
                                break block51;
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (jarInput != null) {
                                    if (object != null) {
                                        try {
                                            jarInput.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        jarInput.close();
                                    }
                                }
                            }
                        }
                        is = url.openStream();
                        ArrayList<String> lines = new ArrayList<String>();
                        Throwable throwable = null;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Reader entry: " + line);
                                }
                                lines.add(line);
                                if (!DefaultVFS.getResources(path + "/" + line).isEmpty()) continue;
                                lines.clear();
                                break;
                            }
                        }
                        catch (Throwable line) {
                            Throwable throwable2 = line;
                            throw line;
                        }
                        if (!lines.isEmpty()) {
                            if (log.isDebugEnabled()) {
                                log.debug("Listing " + url);
                            }
                            children.addAll(lines);
                        }
                    }
                    catch (FileNotFoundException e) {
                        if ("file".equals(url.getProtocol())) {
                            File file = new File(url.getFile());
                            if (log.isDebugEnabled()) {
                                log.debug("Listing directory " + file.getAbsolutePath());
                            }
                            if (file.isDirectory()) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Listing " + url);
                                }
                                children = Arrays.asList(file.list());
                            }
                        }
                        throw e;
                    }
                }
                String prefix = url.toExternalForm();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                for (String string : children) {
                    String resourcePath = path + "/" + string;
                    resources.add(resourcePath);
                    URL childUrl = new URL(prefix + string);
                    resources.addAll(this.list(childUrl, resourcePath));
                }
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected List<String> listResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            StringBuilder name = new StringBuilder(entry.getName());
            if (name.charAt(0) != '/') {
                name.insert(0, '/');
            }
            if (name.indexOf(path) != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found resource: " + name);
            }
            resources.add(name.substring(1));
        }
        return resources;
    }

    protected URL findJarForResource(URL url) throws MalformedURLException {
        if (log.isDebugEnabled()) {
            log.debug("Find JAR URL: " + url);
        }
        boolean continueLoop = true;
        while (continueLoop) {
            try {
                url = new URL(url.getFile());
                if (!log.isDebugEnabled()) continue;
                log.debug("Inner URL: " + url);
            }
            catch (MalformedURLException e) {
                continueLoop = false;
            }
        }
        StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
        int index = jarUrl.lastIndexOf(".jar");
        if (index >= 0) {
            jarUrl.setLength(index + 4);
            if (log.isDebugEnabled()) {
                log.debug("Extracted JAR URL: " + jarUrl);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Not a JAR: " + jarUrl);
            }
            return null;
        }
        try {
            URL testUrl = new URL(jarUrl.toString());
            if (this.isJar(testUrl)) {
                return testUrl;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not a JAR: " + jarUrl);
            }
            jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
            File file = new File(jarUrl.toString());
            if (!file.exists()) {
                try {
                    file = new File(URLEncoder.encode(jarUrl.toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
                }
            }
            if (file.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("Trying real file: " + file.getAbsolutePath());
                }
                if (this.isJar(testUrl = file.toURI().toURL())) {
                    return testUrl;
                }
            }
        }
        catch (MalformedURLException e) {
            log.warn("Invalid JAR URL: " + jarUrl);
        }
        if (log.isDebugEnabled()) {
            log.debug("Not a JAR: " + jarUrl);
        }
        return null;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isJar(URL url, byte[] buffer) {
        InputStream is = null;
        try {
            is = url.openStream();
            is.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                if (log.isDebugEnabled()) {
                    log.debug("Found JAR: " + url);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }
}

