/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.SerializableFunction;

abstract class TimeTransform<S>
implements Transform<S, Integer> {
    TimeTransform() {
    }

    protected abstract Transform<S, Integer> toEnum(Type var1);

    @Override
    public SerializableFunction<S, Integer> bind(Type type) {
        return this.toEnum(type).bind(type);
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.DATE || type.typeId() == Type.TypeID.TIMESTAMP;
    }

    @Override
    public UnboundPredicate<Integer> project(String name, BoundPredicate<S> predicate) {
        if (predicate.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, name, predicate);
        }
        return this.toEnum(((BoundTerm)predicate.term()).type()).project(name, predicate);
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<S> predicate) {
        if (predicate.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, name, predicate);
        }
        return this.toEnum(((BoundTerm)predicate.term()).type()).projectStrict(name, predicate);
    }

    @Override
    public String dedupName() {
        return "time";
    }
}

