/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.inlong.manager.client.api.InlongGroup;
import org.apache.inlong.manager.client.api.InlongGroupContext;
import org.apache.inlong.manager.client.api.InlongStreamBuilder;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantRoleClient;
import org.apache.inlong.manager.client.api.inner.client.UserClient;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.pojo.CreateGroupConf;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.client.cli.validator.UserTypeValidator;
import org.apache.inlong.manager.common.enums.DataFormat;
import org.apache.inlong.manager.common.enums.TenantUserTypeEnum;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.sort.BaseSortConf;
import org.apache.inlong.manager.pojo.sort.FlinkSortConf;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.tenant.InlongTenantRequest;
import org.apache.inlong.manager.pojo.user.TenantRoleRequest;
import org.apache.inlong.manager.pojo.user.UserRequest;

@Parameters(commandDescription="Create resource by json file")
public class CreateCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public CreateCommand() {
        super("create");
        this.jcommander.addCommand("group", (Object)new CreateGroup());
        this.jcommander.addCommand("cluster", (Object)new CreateCluster());
        this.jcommander.addCommand("cluster-tag", (Object)new CreateClusterTag());
        this.jcommander.addCommand("cluster-node", (Object)new CreateClusterNode());
        this.jcommander.addCommand("user", (Object)new CreateUser());
        this.jcommander.addCommand("tenant", (Object)new CreateTenant());
        this.jcommander.addCommand("tenant-role", (Object)new CreateTenantRole());
    }

    @Parameters(commandDescription="Create tenant role")
    private static class CreateTenantRole
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-u", "--username"}, description="username")
        private String username;
        @Parameter(names={"-p", "--role-code"}, description="role code")
        private String roleCode;
        @Parameter(names={"-t", "--tenant"}, description="tenant")
        private String tenant;

        private CreateTenantRole() {
        }

        @Override
        void run() {
            try {
                TenantRoleRequest request = new TenantRoleRequest();
                request.setUsername(this.username);
                request.setRoleCode(this.roleCode);
                request.setTenant(this.tenant);
                request.setVersion(Integer.valueOf(0));
                ClientUtils.initClientFactory();
                InlongTenantRoleClient roleClient = ClientUtils.clientFactory.getInlongTenantRoleClient();
                Integer roleId = roleClient.save(request);
                if (roleId != null) {
                    System.out.println("Create role success! ID: " + roleId);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Create tenant")
    private static class CreateTenant
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-n", "--name"}, description="tenant name")
        private String name;
        @Parameter(names={"-d", "--description"}, description="tenant description")
        private String description;

        private CreateTenant() {
        }

        @Override
        void run() {
            try {
                InlongTenantRequest request = new InlongTenantRequest();
                request.setName(this.name);
                request.setDescription(this.description);
                request.setVersion(Integer.valueOf(0));
                ClientUtils.initClientFactory();
                InlongTenantClient tenantClient = ClientUtils.clientFactory.getInlongTenantClient();
                Integer userId = tenantClient.save(request);
                if (userId != null) {
                    System.out.println("Create tenant success! ID: " + userId);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Create user")
    private static class CreateUser
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-u", "--username"}, description="username")
        private String username;
        @Parameter(names={"-p", "--password"}, description="password")
        private String password;
        @Parameter(names={"-t", "--type"}, description="account type", validateWith={UserTypeValidator.class})
        private String type;
        @Parameter(names={"-d", "--days"}, description="valid days")
        private Integer validDays;

        private CreateUser() {
        }

        @Override
        void run() {
            try {
                UserRequest request = new UserRequest();
                request.setName(this.username);
                request.setPassword(this.password);
                request.setAccountType(TenantUserTypeEnum.parseName((String)this.type));
                request.setValidDays(this.validDays);
                ClientUtils.initClientFactory();
                UserClient userClient = ClientUtils.clientFactory.getUserClient();
                Integer userId = userClient.register(request);
                if (userId != null) {
                    System.out.println("Create user success! ID: " + userId);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Create cluster node by json file")
    private static class CreateClusterNode
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-f", "--file"}, description="json file", converter=FileConverter.class)
        private File file;

        private CreateClusterNode() {
        }

        @Override
        void run() {
            try {
                String content = ClientUtils.readFile(this.file);
                ClusterNodeRequest request = (ClusterNodeRequest)JsonUtils.parseObject((String)content, ClusterNodeRequest.class);
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                Integer nodeId = clusterClient.saveNode(request);
                if (nodeId != null) {
                    System.out.println("Create cluster node success! ID: " + nodeId);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Create cluster tag by json file")
    private static class CreateClusterTag
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-f", "--file"}, description="json file", converter=FileConverter.class)
        private File file;

        private CreateClusterTag() {
        }

        @Override
        void run() {
            try {
                String content = ClientUtils.readFile(this.file);
                ClusterTagRequest request = (ClusterTagRequest)JsonUtils.parseObject((String)content, ClusterTagRequest.class);
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                Integer tagId = clusterClient.saveTag(request);
                if (tagId != null) {
                    System.out.println("Create cluster tag success! ID: " + tagId);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Create cluster by json file")
    private static class CreateCluster
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-f", "--file"}, description="json file", converter=FileConverter.class)
        private File file;

        private CreateCluster() {
        }

        @Override
        void run() {
            try {
                String content = ClientUtils.readFile(this.file);
                ClusterRequest request = (ClusterRequest)JsonUtils.parseObject((String)content, ClusterRequest.class);
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                assert (request != null);
                Integer clusterId = clusterClient.saveCluster(request);
                if (clusterId != null) {
                    System.out.println("Create cluster success! ID: " + clusterId);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Create group by json file")
    private static class CreateGroup
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-f", "--file"}, converter=FileConverter.class, description="json file")
        private File file;

        private CreateGroup() {
        }

        @Override
        void run() {
            try {
                String content = ClientUtils.readFile(this.file);
                CreateGroupConf groupConf = (CreateGroupConf)JsonUtils.parseObject((String)content, CreateGroupConf.class);
                assert (groupConf != null);
                this.setDefaultConfigInfo(groupConf);
                InlongClientImpl inlongClient = ClientUtils.getClient();
                InlongGroup group = inlongClient.forGroup(groupConf.getGroupInfo());
                InlongStreamBuilder streamBuilder = group.createStream(groupConf.getStreamInfo());
                streamBuilder.fields(groupConf.getStreamInfo().getFieldList());
                groupConf.getStreamInfo().getSourceList().forEach(arg_0 -> ((InlongStreamBuilder)streamBuilder).source(arg_0));
                groupConf.getStreamInfo().getSinkList().forEach(arg_0 -> ((InlongStreamBuilder)streamBuilder).sink(arg_0));
                if (groupConf.getStreamTransform() != null) {
                    streamBuilder.transform((StreamTransform)groupConf.getStreamTransform());
                }
                streamBuilder.initOrUpdate();
                InlongGroupContext context = group.init();
                System.out.println("Create group success, current status: " + context.getStatus());
            }
            catch (Exception e) {
                System.out.println("Create group failed!");
                System.out.println(e.getMessage());
            }
        }

        private void setDefaultConfigInfo(CreateGroupConf groupConf) {
            String inlongGroupId = groupConf.getGroupInfo().getInlongGroupId();
            String inlongStreamId = groupConf.getStreamInfo().getInlongStreamId();
            groupConf.getGroupInfo().setInCharges("admin");
            groupConf.getGroupInfo().setInlongGroupMode(Integer.valueOf(0));
            groupConf.getGroupInfo().setSortConf((BaseSortConf)new FlinkSortConf());
            InlongStreamInfo streamInfo = groupConf.getStreamInfo();
            groupConf.getStreamInfo().setInlongGroupId(inlongGroupId);
            streamInfo.setDataType(Optional.ofNullable(streamInfo.getDataType()).orElse(DataFormat.CSV.getName()));
            streamInfo.setDataEncoding(Optional.ofNullable(streamInfo.getDataEncoding()).orElse("UTF-8"));
            streamInfo.setDataSeparator(Optional.ofNullable(streamInfo.getDataSeparator()).orElse("124"));
            streamInfo.setIgnoreParseError(Optional.ofNullable(streamInfo.getIgnoreParseError()).orElse(true));
            streamInfo.getFieldList().forEach(field -> {
                field.setInlongGroupId(inlongGroupId);
                field.setInlongStreamId(inlongStreamId);
            });
            streamInfo.getSourceList().forEach(source -> {
                source.setInlongGroupId(inlongGroupId);
                source.setInlongStreamId(inlongStreamId);
            });
            streamInfo.getSinkList().forEach(sink -> {
                sink.setInlongGroupId(inlongGroupId);
                sink.setInlongStreamId(inlongStreamId);
            });
        }
    }
}

