/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect;

import com.github.pagehelper.PageRowBounds;
import com.github.pagehelper.dialect.AbstractDialect;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public abstract class AbstractRowBoundsDialect
extends AbstractDialect {
    @Override
    public boolean skip(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return rowBounds == RowBounds.DEFAULT;
    }

    @Override
    public boolean beforeCount(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        if (rowBounds instanceof PageRowBounds) {
            PageRowBounds pageRowBounds = (PageRowBounds)rowBounds;
            return pageRowBounds.getCount() == null || pageRowBounds.getCount() != false;
        }
        return false;
    }

    @Override
    public boolean afterCount(long count, Object parameterObject, RowBounds rowBounds) {
        ((PageRowBounds)rowBounds).setTotal(count);
        return count > 0L;
    }

    @Override
    public Object processParameterObject(MappedStatement ms, Object parameterObject, BoundSql boundSql, CacheKey pageKey) {
        return parameterObject;
    }

    @Override
    public boolean beforePage(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return true;
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        return this.getPageSql(sql, rowBounds, pageKey);
    }

    public abstract String getPageSql(String var1, RowBounds var2, CacheKey var3);

    @Override
    public Object afterPage(List pageList, Object parameterObject, RowBounds rowBounds) {
        return pageList;
    }

    @Override
    public void afterAll() {
    }

    @Override
    public void setProperties(Properties properties) {
    }
}

