/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.math.BigDecimal;
import org.apache.inlong.sdk.transform.decode.JsonSourceDecoder;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.pojo.BsonSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonSourceDecoder
extends SourceDecoder<byte[]> {
    private static final Logger log = LoggerFactory.getLogger(BsonSourceDecoder.class);
    private final JsonSourceDecoder decoder;

    public BsonSourceDecoder(BsonSourceInfo sourceInfo) {
        this.decoder = new JsonSourceDecoder(sourceInfo);
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        return this.decoder.decode(this.parse(srcBytes), context);
    }

    public String parse(byte[] bsonData) {
        try {
            RawBsonDocument rawBsonDocument = new RawBsonDocument(bsonData);
            JsonWriterSettings writerSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).decimal128Converter((value, writer) -> writer.writeNumber(value.bigDecimalValue().toPlainString())).doubleConverter((value, writer) -> writer.writeNumber(new BigDecimal((double)value).toString())).build();
            BsonDocument bsonDocument = BsonDocument.parse((String)rawBsonDocument.toJson(writerSettings));
            bsonDocument.remove((Object)"_id");
            return bsonDocument.toJson();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

