/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonNode {
    private String name;
    private boolean isArray = false;
    private List<Integer> arrayIndices = new ArrayList<Integer>();

    public JsonNode(String nodeString) {
        int beginIndex = nodeString.indexOf(40);
        if (beginIndex < 0) {
            this.name = nodeString;
        } else {
            this.name = StringUtils.trim((String)nodeString.substring(0, beginIndex));
            int endIndex = nodeString.lastIndexOf(41);
            if (endIndex >= 0) {
                String[] indices;
                this.isArray = true;
                String indicesString = nodeString.substring(beginIndex + 1, endIndex);
                for (String index : indices = indicesString.split(",")) {
                    int arrayIndex = NumberUtils.toInt((String)StringUtils.trim((String)index), (int)-1);
                    if (arrayIndex < 0) {
                        arrayIndex = 0;
                    }
                    this.arrayIndices.add(arrayIndex);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public List<Integer> getArrayIndices() {
        return this.arrayIndices;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public void setArrayIndices(List<Integer> arrayIndices) {
        this.arrayIndices = arrayIndices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonNode)) {
            return false;
        }
        JsonNode other = (JsonNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isArray() != other.isArray()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Integer> this$arrayIndices = this.getArrayIndices();
        List<Integer> other$arrayIndices = other.getArrayIndices();
        return !(this$arrayIndices == null ? other$arrayIndices != null : !((Object)this$arrayIndices).equals(other$arrayIndices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isArray() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Integer> $arrayIndices = this.getArrayIndices();
        result = result * 59 + ($arrayIndices == null ? 43 : ((Object)$arrayIndices).hashCode());
        return result;
    }

    public String toString() {
        return "JsonNode(name=" + this.getName() + ", isArray=" + this.isArray() + ", arrayIndices=" + this.getArrayIndices() + ")";
    }
}

