/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="arithmetic", names={"cosh"}, parameter="(Numeric numeric)", descriptions={"- Return \"\" if 'numeric' is NULL;", "- Return the hyperbolic cosine of 'numeric'."}, examples={"cosh(1) = 1.543080634815244", "cosh(0) = 1.0", "cosh(-1) = 1.543080634815244"})
public class CoshFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(CoshFunction.class);
    private ValueParser numberParser;

    public CoshFunction(Function expr) {
        this.numberParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object numberObj = this.numberParser.parse(sourceData, rowIndex, context);
        if (numberObj == null) {
            return null;
        }
        BigDecimal numberValue = OperatorTools.parseBigDecimal(numberObj);
        return Math.cosh(numberValue.doubleValue());
    }
}

