/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"cardinality"}, parameter="(Object input)", descriptions={"- Return \"\" if the input is NULL;", "- Return the number of elements in array if the input is array;", "- Return the number of entries in map if the input is map."}, examples={"cardinality(array('he',7,'xxd')) = 3", "cardinality(map('he',7,'xxd',3)) = 2"})
public class CardinalityFunction
implements ValueParser {
    private final ValueParser valueParser;

    public CardinalityFunction(Function expr) {
        this.valueParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object valueObj = this.valueParser.parse(sourceData, rowIndex, context);
        if (valueObj instanceof ArrayList) {
            return ((ArrayList)valueObj).size();
        }
        if (valueObj instanceof Map) {
            return ((Map)valueObj).size();
        }
        return null;
    }
}

