/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"translate"}, parameter="(String origin_string, String find_chars, String replace_chars)", descriptions={"- Return \"\" if any parameter is NULL;", "- Return the result of replacing all occurrences of both 'find_chars' and 'origin_string' with the characters in 'replace_chars'."}, examples={"translate(apache@inlong.com, '@', '.') = \"apache.inlong.com\"", "translate(hello WorD, 'WD', 'wd') = \"hello word\""})
public class TranslateFunction
implements ValueParser {
    private ValueParser originalStrParser;
    private ValueParser findCharsParser;
    private ValueParser replaceCharsParser;

    public TranslateFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.originalStrParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.findCharsParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.replaceCharsParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object originalStrObject = this.originalStrParser.parse(sourceData, rowIndex, context);
        Object findCharsObject = this.findCharsParser.parse(sourceData, rowIndex, context);
        Object replaceCharsObject = this.replaceCharsParser.parse(sourceData, rowIndex, context);
        if (originalStrObject == null || findCharsObject == null || replaceCharsObject == null) {
            return null;
        }
        String originalStr = OperatorTools.parseString(originalStrObject);
        String findChars = OperatorTools.parseString(findCharsObject);
        String replaceChars = OperatorTools.parseString(replaceCharsObject);
        if (originalStr == null) {
            return "";
        }
        StringBuilder builder = null;
        Map<Character, Character> replacementMap = this.parseReplacementMap(findChars, replaceChars);
        int size = originalStr.length();
        for (int i = 0; i < size; ++i) {
            char ch = originalStr.charAt(i);
            if (replacementMap.containsKey(Character.valueOf(ch))) {
                if (builder == null) {
                    builder = new StringBuilder(size);
                    if (i > 0) {
                        builder.append(originalStr, 0, i);
                    }
                }
                ch = replacementMap.get(Character.valueOf(ch)).charValue();
            }
            if (builder == null) continue;
            builder.append(ch);
        }
        return builder == null ? originalStr : builder.toString();
    }

    private Map<Character, Character> parseReplacementMap(String findChars, String replaceChars) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{findChars, replaceChars})) {
            return ImmutableMap.of();
        }
        int commonSize = Math.min(findChars.length(), replaceChars.length());
        HashMap<Character, Character> replacementMap = new HashMap<Character, Character>();
        for (int i = 0; i < commonSize; ++i) {
            char findChar = findChars.charAt(i);
            char replaceChar = replaceChars.charAt(i);
            replacementMap.put(Character.valueOf(findChar), Character.valueOf(replaceChar));
        }
        return replacementMap;
    }
}

